/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.tools.AlphanumComparator;

public class TestError
implements Comparable<TestError>,
DataSetListener {
    private Boolean ignored = false;
    private Severity severity;
    private String message;
    private String description;
    private String description_en;
    private Collection<? extends OsmPrimitive> primitives;
    private Collection<?> highlighted;
    private Test tester;
    private int code;
    private boolean selected;

    public TestError(Test tester, Severity severity, String message, String description, String description_en, int code, Collection<? extends OsmPrimitive> primitives, Collection<?> highlighted) {
        this.tester = tester;
        this.severity = severity;
        this.message = message;
        this.description = description;
        this.description_en = description_en;
        this.primitives = primitives;
        this.highlighted = highlighted;
        this.code = code;
    }

    public TestError(Test tester, Severity severity, String message, int code, Collection<? extends OsmPrimitive> primitives, Collection<?> highlighted) {
        this(tester, severity, message, null, null, code, primitives, highlighted);
    }

    public TestError(Test tester, Severity severity, String message, String description, String description_en, int code, Collection<? extends OsmPrimitive> primitives) {
        this(tester, severity, message, description, description_en, code, primitives, primitives);
    }

    public TestError(Test tester, Severity severity, String message, int code, Collection<? extends OsmPrimitive> primitives) {
        this(tester, severity, message, null, null, code, primitives, primitives);
    }

    public TestError(Test tester, Severity severity, String message, int code, OsmPrimitive primitive) {
        this(tester, severity, message, null, null, code, Collections.singletonList(primitive), Collections.singletonList(primitive));
    }

    public TestError(Test tester, Severity severity, String message, String description, String description_en, int code, OsmPrimitive primitive) {
        this(tester, severity, message, description, description_en, code, Collections.singletonList(primitive));
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Collection<? extends OsmPrimitive> getPrimitives() {
        return this.primitives;
    }

    public Collection<? extends OsmPrimitive> getSelectablePrimitives() {
        ArrayList<OsmPrimitive> selectablePrimitives = new ArrayList<OsmPrimitive>(this.primitives.size());
        for (OsmPrimitive osmPrimitive : this.primitives) {
            if (!osmPrimitive.isSelectable()) continue;
            selectablePrimitives.add(osmPrimitive);
        }
        return selectablePrimitives;
    }

    public void setPrimitives(List<OsmPrimitive> primitives) {
        this.primitives = primitives;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getIgnoreState() {
        TreeSet<String> strings = new TreeSet<String>();
        StringBuilder ignorestring = new StringBuilder(this.getIgnoreSubGroup());
        for (OsmPrimitive osmPrimitive : this.primitives) {
            if (osmPrimitive.isNew()) {
                return null;
            }
            String type = "u";
            if (osmPrimitive instanceof Way) {
                type = "w";
            } else if (osmPrimitive instanceof Relation) {
                type = "r";
            } else if (osmPrimitive instanceof Node) {
                type = "n";
            }
            strings.add(type + "_" + osmPrimitive.getId());
        }
        for (String string : strings) {
            ignorestring.append(":").append(string);
        }
        return ignorestring.toString();
    }

    public String getIgnoreSubGroup() {
        String ignorestring = this.getIgnoreGroup();
        if (this.description_en != null) {
            ignorestring = ignorestring + "_" + this.description_en;
        }
        return ignorestring;
    }

    public String getIgnoreGroup() {
        return Integer.toString(this.code);
    }

    public void setIgnored(boolean state) {
        this.ignored = state;
    }

    public Boolean getIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    public void setTester(Test tester) {
        this.tester = tester;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFixable() {
        return this.tester != null && this.tester.isFixable(this);
    }

    public Command getFix() {
        if (this.tester == null || !this.tester.isFixable(this) || this.primitives.isEmpty()) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void visitHighlighted(ValidatorVisitor v) {
        for (Object o : this.highlighted) {
            if (o instanceof OsmPrimitive) {
                v.visit((OsmPrimitive)o);
                continue;
            }
            if (o instanceof WaySegment) {
                v.visit((WaySegment)o);
                continue;
            }
            if (!(o instanceof List)) continue;
            v.visit((List)o);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Collection<?> getHighlighted() {
        return this.highlighted;
    }

    @Override
    public int compareTo(TestError o) {
        if (this.equals(o)) {
            return 0;
        }
        MultipleNameVisitor v1 = new MultipleNameVisitor();
        MultipleNameVisitor v2 = new MultipleNameVisitor();
        v1.visit(this.getPrimitives());
        v2.visit(o.getPrimitives());
        return AlphanumComparator.getInstance().compare(v1.toString(), v2.toString());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        try {
            this.primitives.removeAll(event.getPrimitives());
        }
        catch (UnsupportedOperationException e) {
            if (event.getPrimitives().containsAll(this.primitives)) {
                this.primitives = Collections.emptyList();
            }
            Main.warn("Unable to remove primitives from " + this);
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
    }

    public String toString() {
        return "TestError [tester=" + this.tester + ", code=" + this.code + ", message=" + this.message + "]";
    }
}

