/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class Test
extends AbstractVisitor {
    protected final String name;
    protected final String description;
    public boolean enabled = true;
    protected JCheckBox checkEnabled;
    protected JCheckBox checkBeforeUpload;
    public boolean testBeforeUpload = true;
    protected boolean isBeforeUpload;
    protected List<TestError> errors = new ArrayList<TestError>(30);
    protected boolean partialSelection;
    protected ProgressMonitor progressMonitor;
    protected long startTime;

    public Test(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Test(String name) {
        this(name, null);
    }

    public void initialize() throws Exception {
        this.startTime = -1L;
    }

    public void startTest(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        String startMessage = I18n.tr("Running test {0}", this.name);
        this.progressMonitor.beginTask(startMessage);
        Main.debug(startMessage);
        this.errors = new ArrayList<TestError>(30);
        this.startTime = System.currentTimeMillis();
    }

    public void setPartialSelection(boolean partialSelection) {
        this.partialSelection = partialSelection;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void endTest() {
        this.progressMonitor.finishTask();
        this.progressMonitor = null;
        if (this.startTime > 0L) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            Main.debug(I18n.tr("Test ''{0}'' completed in {1}", this.getName(), Utils.getDurationString(elapsedTime)));
        }
    }

    public void visit(Collection<OsmPrimitive> selection) {
        this.progressMonitor.setTicksCount(selection.size());
        for (OsmPrimitive p : selection) {
            if (this.isPrimitiveUsable(p)) {
                p.accept(this);
            }
            this.progressMonitor.worked(1);
        }
    }

    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isUsable() && (!(p instanceof Way) || ((Way)p).getNodesCount() > 1);
    }

    @Override
    public void visit(Node n) {
    }

    @Override
    public void visit(Way w) {
    }

    @Override
    public void visit(Relation r) {
    }

    public void addGui(JPanel testPanel) {
        this.checkEnabled = new JCheckBox(this.name, this.enabled);
        this.checkEnabled.setToolTipText(this.description);
        testPanel.add((Component)this.checkEnabled, GBC.std());
        GBC a = GBC.eol();
        a.anchor = 13;
        this.checkBeforeUpload = new JCheckBox();
        this.checkBeforeUpload.setSelected(this.testBeforeUpload);
        testPanel.add((Component)this.checkBeforeUpload, a);
    }

    public boolean ok() {
        this.enabled = this.checkEnabled.isSelected();
        this.testBeforeUpload = this.checkBeforeUpload.isSelected();
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public boolean testBeforeUpload() {
        return this.testBeforeUpload;
    }

    public void setBeforeUpload(boolean isUpload) {
        this.isBeforeUpload = isUpload;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    protected final Command deletePrimitivesIfNeeded(Collection<? extends OsmPrimitive> primitives) {
        ArrayList<OsmPrimitive> primitivesToDelete = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive.isDeleted()) continue;
            primitivesToDelete.add(osmPrimitive);
        }
        if (!primitivesToDelete.isEmpty()) {
            return DeleteCommand.delete(Main.main.getEditLayer(), primitivesToDelete);
        }
        return null;
    }

    protected static final boolean isBuilding(OsmPrimitive p) {
        String v = p.get("building");
        return v != null && !"no".equals(v) && !"entrance".equals(v);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Test)) {
            return false;
        }
        Test other = (Test)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static abstract class TagTest
    extends Test {
        public TagTest(String name, String description) {
            super(name, description);
        }

        public TagTest(String name) {
            super(name);
        }

        public abstract void check(OsmPrimitive var1);

        @Override
        public void visit(Node n) {
            this.check(n);
        }

        @Override
        public void visit(Way w) {
            this.check(w);
        }

        @Override
        public void visit(Relation r) {
            this.check(r);
        }
    }
}

