/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.tests.Addresses;
import org.openstreetmap.josm.data.validation.tests.ApiCapabilitiesTest;
import org.openstreetmap.josm.data.validation.tests.BarriersEntrances;
import org.openstreetmap.josm.data.validation.tests.Coastlines;
import org.openstreetmap.josm.data.validation.tests.ConditionalKeys;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.DuplicateNode;
import org.openstreetmap.josm.data.validation.tests.DuplicateRelation;
import org.openstreetmap.josm.data.validation.tests.DuplicateWay;
import org.openstreetmap.josm.data.validation.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.data.validation.tests.Highways;
import org.openstreetmap.josm.data.validation.tests.InternetTags;
import org.openstreetmap.josm.data.validation.tests.Lanes;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.data.validation.tests.NameMismatch;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.data.validation.tests.OverlappingWays;
import org.openstreetmap.josm.data.validation.tests.PowerLines;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.data.validation.tests.TagChecker;
import org.openstreetmap.josm.data.validation.tests.TurnrestrictionTest;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.data.validation.tests.UnconnectedWays;
import org.openstreetmap.josm.data.validation.tests.UntaggedNode;
import org.openstreetmap.josm.data.validation.tests.UntaggedWay;
import org.openstreetmap.josm.data.validation.tests.WayConnectedToArea;
import org.openstreetmap.josm.data.validation.tests.WronglyOrderedWays;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmValidator
implements MapView.LayerChangeListener {
    public static volatile ValidatorLayer errorLayer = null;
    public ValidateAction validateAction = new ValidateAction();
    public static double griddetail;
    public static final Collection<String> ignoredErrors;
    private static final Class<Test>[] allAvailableTests;
    private static Map<String, Test> allTestsMap;
    private static boolean testsInitialized;

    public OsmValidator() {
        this.checkValidatorDir();
        OsmValidator.initializeGridDetail();
        this.loadIgnoredErrors();
    }

    public static String getValidatorDir() {
        return new File(Main.pref.getUserDataDirectory(), "validator").getAbsolutePath();
    }

    private void checkValidatorDir() {
        try {
            File pathDir = new File(OsmValidator.getValidatorDir());
            if (!pathDir.exists()) {
                pathDir.mkdirs();
            }
        }
        catch (Exception e) {
            Main.error(e);
        }
    }

    private void loadIgnoredErrors() {
        Path path;
        ignoredErrors.clear();
        if (Main.pref.getBoolean("validator.ignore", true) && Files.exists(path = Paths.get(OsmValidator.getValidatorDir(), new String[0]).resolve("ignorederrors"), new LinkOption[0])) {
            try {
                ignoredErrors.addAll(Files.readAllLines(path, StandardCharsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                Main.debug(Main.getErrorMessage(e));
            }
            catch (IOException e) {
                Main.error(e);
            }
        }
    }

    public static void addIgnoredError(String s) {
        ignoredErrors.add(s);
    }

    public static boolean hasIgnoredError(String s) {
        return ignoredErrors.contains(s);
    }

    public static void saveIgnoredErrors() {
        try (PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(new File(OsmValidator.getValidatorDir(), "ignorederrors")), StandardCharsets.UTF_8), false);){
            for (String e : ignoredErrors) {
                out.println(e);
            }
        }
        catch (IOException e) {
            Main.error(e);
        }
    }

    public static void initializeErrorLayer() {
        if (!Main.pref.getBoolean("validator.layer", true)) {
            return;
        }
        if (errorLayer == null) {
            errorLayer = new ValidatorLayer();
            Main.main.addLayer(errorLayer);
        }
    }

    public static SortedMap<String, Test> getAllTestsMap() {
        OsmValidator.applyPrefs(allTestsMap, false);
        OsmValidator.applyPrefs(allTestsMap, true);
        return new TreeMap<String, Test>(allTestsMap);
    }

    public static <T extends Test> T getTest(Class<T> testClass) {
        if (testClass == null) {
            return null;
        }
        return (T)allTestsMap.get(testClass.getName());
    }

    private static void applyPrefs(Map<String, Test> tests, boolean beforeUpload) {
        for (String testName : Main.pref.getCollection(beforeUpload ? "validator.skipBeforeUpload" : "validator.skip")) {
            Test test = tests.get(testName);
            if (test == null) continue;
            if (beforeUpload) {
                test.testBeforeUpload = false;
                continue;
            }
            test.enabled = false;
        }
    }

    public static Collection<Test> getTests() {
        return OsmValidator.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean beforeUpload) {
        Collection<Test> enabledTests = OsmValidator.getTests();
        for (Test t : new ArrayList<Test>(enabledTests)) {
            if (beforeUpload ? t.testBeforeUpload : t.enabled) continue;
            enabledTests.remove(t);
        }
        return enabledTests;
    }

    public static Class<Test>[] getAllAvailableTests() {
        return Utils.copyArray(allAvailableTests);
    }

    public static final void initializeGridDetail() {
        String code = Main.getProjection().toCode();
        griddetail = Arrays.asList(ProjectionPreference.wgs84.allCodes()).contains(code) ? 10000.0 : (Arrays.asList(ProjectionPreference.mercator.allCodes()).contains(code) ? 0.01 : (Arrays.asList(ProjectionPreference.lambert.allCodes()).contains(code) ? 0.1 : 1.0));
    }

    public static synchronized void initializeTests() {
        if (!testsInitialized) {
            Main.debug("Initializing validator tests");
            long startTime = System.currentTimeMillis();
            OsmValidator.initializeTests(OsmValidator.getTests());
            testsInitialized = true;
            if (Main.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                Main.debug("Initializing validator tests completed in " + Utils.getDurationString(elapsedTime));
            }
        }
    }

    public static void initializeTests(Collection<? extends Test> allTests) {
        for (Test test : allTests) {
            try {
                if (!test.enabled) continue;
                test.initialize();
            }
            catch (Exception e) {
                Main.error(e);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error initializing test {0}:\n {1}", test.getClass().getSimpleName(), e), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == errorLayer) {
            errorLayer = null;
            return;
        }
        if (Main.map.mapView.getLayersOfType(OsmDataLayer.class).isEmpty() && errorLayer != null) {
            Main.main.removeLayer(errorLayer);
        }
    }

    static {
        ignoredErrors = new TreeSet<String>();
        allAvailableTests = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.Ways.class, CrossingWays.Boundaries.class, CrossingWays.Barrier.class, SimilarNamedWays.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.UnconnectedHighways.class, UnconnectedWays.UnconnectedRailways.class, UnconnectedWays.UnconnectedWaterways.class, UnconnectedWays.UnconnectedNaturalOrLanduse.class, UnconnectedWays.UnconnectedPower.class, DuplicateWay.class, NameMismatch.class, MultipolygonTest.class, RelationChecker.class, TurnrestrictionTest.class, DuplicateRelation.class, WayConnectedToArea.class, PowerLines.class, Addresses.class, Highways.class, BarriersEntrances.class, OpeningHourTest.class, MapCSSTagChecker.class, Lanes.class, ConditionalKeys.class, InternetTags.class, ApiCapabilitiesTest.class};
        allTestsMap = new HashMap<String, Test>();
        for (Class<Test> testClass : allAvailableTests) {
            try {
                allTestsMap.put(testClass.getName(), testClass.newInstance());
            }
            catch (Exception e) {
                Main.error(e);
            }
        }
        testsInitialized = false;
    }
}

