/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class TransverseMercator
implements Proj {
    protected double a;
    protected double b;

    @Override
    public String getName() {
        return I18n.tr("Transverse Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "tmerc";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        this.a = params.ellps.a;
        this.b = params.ellps.b;
    }

    @Override
    public double[] project(double phi, double lambda) {
        double ep2 = (Math.pow(this.a, 2.0) - Math.pow(this.b, 2.0)) / Math.pow(this.b, 2.0);
        double nu2 = ep2 * Math.pow(Math.cos(phi), 2.0);
        double N_a = this.a / (this.b * Math.sqrt(1.0 + nu2));
        double t = Math.tan(phi);
        double t2 = t * t;
        double l = lambda;
        double l3coef = 1.0 - t2 + nu2;
        double l4coef = 5.0 - t2 + 9.0 * nu2 + 4.0 * (nu2 * nu2);
        double l5coef = 5.0 - 18.0 * t2 + t2 * t2 + 14.0 * nu2 - 58.0 * t2 * nu2;
        double l6coef = 61.0 - 58.0 * t2 + t2 * t2 + 270.0 * nu2 - 330.0 * t2 * nu2;
        double l7coef = 61.0 - 479.0 * t2 + 179.0 * (t2 * t2) - t2 * t2 * t2;
        double l8coef = 1385.0 - 3111.0 * t2 + 543.0 * (t2 * t2) - t2 * t2 * t2;
        return new double[]{N_a * Math.cos(phi) * l + N_a / 6.0 * Math.pow(Math.cos(phi), 3.0) * l3coef * Math.pow(l, 3.0) + N_a / 120.0 * Math.pow(Math.cos(phi), 5.0) * l5coef * Math.pow(l, 5.0) + N_a / 5040.0 * Math.pow(Math.cos(phi), 7.0) * l7coef * Math.pow(l, 7.0), this.ArcLengthOfMeridian(phi) / this.a + t / 2.0 * N_a * Math.pow(Math.cos(phi), 2.0) * Math.pow(l, 2.0) + t / 24.0 * N_a * Math.pow(Math.cos(phi), 4.0) * l4coef * Math.pow(l, 4.0) + t / 720.0 * N_a * Math.pow(Math.cos(phi), 6.0) * l6coef * Math.pow(l, 6.0) + t / 40320.0 * N_a * Math.pow(Math.cos(phi), 8.0) * l8coef * Math.pow(l, 8.0)};
    }

    @Override
    public double[] invproject(double x, double y) {
        double Nf_a;
        double phif = this.footpointLatitude(y);
        double ep2 = (this.a * this.a - this.b * this.b) / (this.b * this.b);
        double cf = Math.cos(phif);
        double nuf2 = ep2 * Math.pow(cf, 2.0);
        double Nfpow = Nf_a = this.a / (this.b * Math.sqrt(1.0 + nuf2));
        double tf = Math.tan(phif);
        double tf2 = tf * tf;
        double tf4 = tf2 * tf2;
        double x1frac = 1.0 / (Nfpow * cf);
        double x2frac = tf / (2.0 * (Nfpow *= Nf_a));
        double x3frac = 1.0 / (6.0 * (Nfpow *= Nf_a) * cf);
        double x4frac = tf / (24.0 * (Nfpow *= Nf_a));
        double x5frac = 1.0 / (120.0 * (Nfpow *= Nf_a) * cf);
        double x6frac = tf / (720.0 * (Nfpow *= Nf_a));
        double x7frac = 1.0 / (5040.0 * (Nfpow *= Nf_a) * cf);
        double x8frac = tf / (40320.0 * (Nfpow *= Nf_a));
        double x2poly = -1.0 - nuf2;
        double x3poly = -1.0 - 2.0 * tf2 - nuf2;
        double x4poly = 5.0 + 3.0 * tf2 + 6.0 * nuf2 - 6.0 * tf2 * nuf2 - 3.0 * (nuf2 * nuf2) - 9.0 * tf2 * (nuf2 * nuf2);
        double x5poly = 5.0 + 28.0 * tf2 + 24.0 * tf4 + 6.0 * nuf2 + 8.0 * tf2 * nuf2;
        double x6poly = -61.0 - 90.0 * tf2 - 45.0 * tf4 - 107.0 * nuf2 + 162.0 * tf2 * nuf2;
        double x7poly = -61.0 - 662.0 * tf2 - 1320.0 * tf4 - 720.0 * (tf4 * tf2);
        double x8poly = 1385.0 + 3633.0 * tf2 + 4095.0 * tf4 + 1575.0 * (tf4 * tf2);
        return new double[]{phif + x2frac * x2poly * (x * x) + x4frac * x4poly * Math.pow(x, 4.0) + x6frac * x6poly * Math.pow(x, 6.0) + x8frac * x8poly * Math.pow(x, 8.0), x1frac * x + x3frac * x3poly * Math.pow(x, 3.0) + x5frac * x5poly * Math.pow(x, 5.0) + x7frac * x7poly * Math.pow(x, 7.0)};
    }

    private double ArcLengthOfMeridian(double phi) {
        double n = (this.a - this.b) / (this.a + this.b);
        double alpha = (this.a + this.b) / 2.0 * (1.0 + Math.pow(n, 2.0) / 4.0 + Math.pow(n, 4.0) / 64.0);
        double beta = -3.0 * n / 2.0 + 9.0 * Math.pow(n, 3.0) / 16.0 + -3.0 * Math.pow(n, 5.0) / 32.0;
        double gamma = 15.0 * Math.pow(n, 2.0) / 16.0 + -15.0 * Math.pow(n, 4.0) / 32.0;
        double delta = -35.0 * Math.pow(n, 3.0) / 48.0 + 105.0 * Math.pow(n, 5.0) / 256.0;
        double epsilon = 315.0 * Math.pow(n, 4.0) / 512.0;
        return alpha * (phi + beta * Math.sin(2.0 * phi) + gamma * Math.sin(4.0 * phi) + delta * Math.sin(6.0 * phi) + epsilon * Math.sin(8.0 * phi));
    }

    private double footpointLatitude(double y) {
        double n = (this.a - this.b) / (this.a + this.b);
        double alpha_ = (this.a + this.b) / 2.0 * (1.0 + Math.pow(n, 2.0) / 4.0 + Math.pow(n, 4.0) / 64.0);
        double y_ = y / alpha_ * this.a;
        double beta_ = 3.0 * n / 2.0 + -27.0 * Math.pow(n, 3.0) / 32.0 + 269.0 * Math.pow(n, 5.0) / 512.0;
        double gamma_ = 21.0 * Math.pow(n, 2.0) / 16.0 + -55.0 * Math.pow(n, 4.0) / 32.0;
        double delta_ = 151.0 * Math.pow(n, 3.0) / 96.0 + -417.0 * Math.pow(n, 5.0) / 128.0;
        double epsilon_ = 1097.0 * Math.pow(n, 4.0) / 512.0;
        return y_ + beta_ * Math.sin(2.0 * y_) + gamma_ * Math.sin(4.0 * y_) + delta_ * Math.sin(6.0 * y_) + epsilon_ * Math.sin(8.0 * y_);
    }
}

