/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class LonLat
implements Proj {
    private double a;

    @Override
    public String getName() {
        return I18n.tr("Lat/lon (Geodetic)", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "lonlat";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        this.a = params.ellps.a;
    }

    @Override
    public double[] project(double lat_rad, double lon_rad) {
        return new double[]{Math.toDegrees(lon_rad) / this.a, Math.toDegrees(lat_rad) / this.a};
    }

    @Override
    public double[] invproject(double east, double north) {
        return new double[]{Math.toRadians(north * this.a), Math.toRadians(east * this.a)};
    }
}

