/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class LambertConformalConic
implements Proj {
    protected Ellipsoid ellps;
    protected double e;
    private Parameters params;
    protected double n;
    protected double F;
    protected double r0;
    protected static final double epsilon = 1.0E-12;

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        this.ellps = params.ellps;
        this.e = this.ellps.e;
        if (params.lat_0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        if (params.lat_1 != null && params.lat_2 != null) {
            this.initialize2SP(params.lat_0, params.lat_1, params.lat_2);
        } else {
            this.initialize1SP(params.lat_0);
        }
    }

    private void initialize2SP(double lat_0, double lat_1, double lat_2) {
        this.params = new Parameters2SP(lat_0, lat_1, lat_2);
        double m1 = this.m(Math.toRadians(lat_1));
        double m2 = this.m(Math.toRadians(lat_2));
        double t1 = this.t(Math.toRadians(lat_1));
        double t2 = this.t(Math.toRadians(lat_2));
        double tf = this.t(Math.toRadians(lat_0));
        this.n = (Math.log(m1) - Math.log(m2)) / (Math.log(t1) - Math.log(t2));
        this.F = m1 / (this.n * Math.pow(t1, this.n));
        this.r0 = this.F * Math.pow(tf, this.n);
    }

    private void initialize1SP(double lat_0) {
        this.params = new Parameters1SP(lat_0);
        double lat_0_rad = Math.toRadians(lat_0);
        double m0 = this.m(lat_0_rad);
        double t0 = this.t(lat_0_rad);
        this.n = Math.sin(lat_0_rad);
        this.F = m0 / (this.n * Math.pow(t0, this.n));
        this.r0 = this.F * Math.pow(t0, this.n);
    }

    protected double t(double lat_rad) {
        return Math.tan(0.7853981633974483 - lat_rad / 2.0) / Math.pow((1.0 - this.e * Math.sin(lat_rad)) / (1.0 + this.e * Math.sin(lat_rad)), this.e / 2.0);
    }

    protected double m(double lat_rad) {
        return Math.cos(lat_rad) / Math.sqrt(1.0 - this.e * this.e * Math.pow(Math.sin(lat_rad), 2.0));
    }

    @Override
    public String getName() {
        return I18n.tr("Lambert Conformal Conic", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "lcc";
    }

    @Override
    public double[] project(double phi, double lambda) {
        double sinphi = Math.sin(phi);
        double L = 0.5 * Math.log((1.0 + sinphi) / (1.0 - sinphi)) - this.e / 2.0 * Math.log((1.0 + this.e * sinphi) / (1.0 - this.e * sinphi));
        double r = this.F * Math.exp(-this.n * L);
        double gamma = this.n * lambda;
        double X = r * Math.sin(gamma);
        double Y = this.r0 - r * Math.cos(gamma);
        return new double[]{X, Y};
    }

    @Override
    public double[] invproject(double east, double north) {
        double r = Math.sqrt(Math.pow(east, 2.0) + Math.pow(north - this.r0, 2.0));
        double gamma = Math.atan(east / (this.r0 - north));
        double lambda = gamma / this.n;
        double latIso = -1.0 / this.n * Math.log(Math.abs(r / this.F));
        double phi = this.ellps.latitude(latIso, this.e, 1.0E-12);
        return new double[]{phi, lambda};
    }

    public final Parameters getParameters() {
        return this.params;
    }

    public static class Parameters2SP
    extends Parameters {
        public final double standardParallel1;
        public final double standardParallel2;

        public Parameters2SP(double latitudeOrigin, double standardParallel1, double standardParallel2) {
            super(latitudeOrigin);
            this.standardParallel1 = standardParallel1;
            this.standardParallel2 = standardParallel2;
        }
    }

    public static class Parameters1SP
    extends Parameters {
        public Parameters1SP(double latitudeOrigin) {
            super(latitudeOrigin);
        }
    }

    public static abstract class Parameters {
        public final double latitudeOrigin;

        public Parameters(double latitudeOrigin) {
            this.latitudeOrigin = latitudeOrigin;
        }
    }
}

