/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;

public class SevenParameterDatum
extends AbstractDatum {
    protected double dx;
    protected double dy;
    protected double dz;
    protected double rx;
    protected double ry;
    protected double rz;
    protected double s;

    public SevenParameterDatum(String name, String proj4Id, Ellipsoid ellps, double dx, double dy, double dz, double rx, double ry, double rz, double s) {
        super(name, proj4Id, ellps);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.rx = Math.toRadians(rx / 3600.0);
        this.ry = Math.toRadians(ry / 3600.0);
        this.rz = Math.toRadians(rz / 3600.0);
        this.s = s / 1000000.0;
    }

    @Override
    public LatLon toWGS84(LatLon ll) {
        double[] xyz = this.ellps.latLon2Cart(ll);
        double x = this.dx + xyz[0] * (1.0 + this.s) + xyz[2] * this.ry - xyz[1] * this.rz;
        double y = this.dy + xyz[1] * (1.0 + this.s) + xyz[0] * this.rz - xyz[2] * this.rx;
        double z = this.dz + xyz[2] * (1.0 + this.s) + xyz[1] * this.rx - xyz[0] * this.ry;
        return Ellipsoid.WGS84.cart2LatLon(new double[]{x, y, z});
    }

    @Override
    public LatLon fromWGS84(LatLon ll) {
        double[] xyz = Ellipsoid.WGS84.latLon2Cart(ll);
        double x = (1.0 - this.s) * (-this.dx + xyz[0] + ((-this.dz + xyz[2]) * -this.ry - (-this.dy + xyz[1]) * -this.rz));
        double y = (1.0 - this.s) * (-this.dy + xyz[1] + ((-this.dx + xyz[0]) * -this.rz - (-this.dz + xyz[2]) * -this.rx));
        double z = (1.0 - this.s) * (-this.dz + xyz[2] + ((-this.dy + xyz[1]) * -this.rx - (-this.dx + xyz[0]) * -this.ry));
        return this.ellps.cart2LatLon(new double[]{x, y, z});
    }
}

