/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.LatLon;

public final class Ellipsoid {
    public static final Ellipsoid clarkeIGN = Ellipsoid.create_a_b(6378249.2, 6356515.0);
    public static final Ellipsoid hayford = Ellipsoid.create_a_rf(6378388.0, 297.0);
    public static final Ellipsoid GRS67 = Ellipsoid.create_a_rf(6378160.0, 298.247167472);
    public static final Ellipsoid GRS80 = Ellipsoid.create_a_rf(6378137.0, 298.257222101);
    public static final Ellipsoid WGS84 = Ellipsoid.create_a_rf(6378137.0, 298.257223563);
    public static final Ellipsoid Bessel1841 = Ellipsoid.create_a_rf(6377397.155, 299.1528128);
    public final double a;
    public final double b;
    public final double e;
    public final double e2;
    public final double eb2;

    private Ellipsoid(double a, double b, double e, double e2, double eb2) {
        this.a = a;
        this.b = b;
        this.e = e;
        this.e2 = e2;
        this.eb2 = eb2;
    }

    public static Ellipsoid create_a_b(double a, double b) {
        double e2 = (a * a - b * b) / (a * a);
        double e = Math.sqrt(e2);
        double eb2 = e2 / (1.0 - e2);
        return new Ellipsoid(a, b, e, e2, eb2);
    }

    public static Ellipsoid create_a_es(double a, double es) {
        double b = a * Math.sqrt(1.0 - es);
        double e = Math.sqrt(es);
        double eb2 = es / (1.0 - es);
        return new Ellipsoid(a, b, e, es, eb2);
    }

    public static Ellipsoid create_a_f(double a, double f) {
        double b = a * (1.0 - f);
        double e2 = f * (2.0 - f);
        double e = Math.sqrt(e2);
        double eb2 = e2 / (1.0 - e2);
        return new Ellipsoid(a, b, e, e2, eb2);
    }

    public static Ellipsoid create_a_rf(double a, double rf) {
        return Ellipsoid.create_a_f(a, 1.0 / rf);
    }

    public String toString() {
        return "Ellipsoid{a=" + this.a + ", b=" + this.b + "}";
    }

    public double verticalRadiusOfCurvature(double phi) {
        return this.a / Math.sqrt(1.0 - this.e2 * Ellipsoid.sqr(Math.sin(phi)));
    }

    private static double sqr(double x) {
        return x * x;
    }

    public double meridionalArc(double phi) {
        double sin2Phi = Math.sin(2.0 * phi);
        double sin4Phi = Math.sin(4.0 * phi);
        double sin6Phi = Math.sin(6.0 * phi);
        double sin8Phi = Math.sin(8.0 * phi);
        double f = 0.0033528106647474805;
        double n = f / (2.0 - f);
        double n2 = n * n;
        double n3 = n2 * n;
        double n4 = n3 * n;
        double n5 = n4 * n;
        double n1n2 = n - n2;
        double n2n3 = n2 - n3;
        double n3n4 = n3 - n4;
        double n4n5 = n4 - n5;
        double ap = this.a * (1.0 - n + 1.25 * n2n3 + 1.265625 * n4n5);
        double bp = 1.5 * this.a * (n1n2 + 0.875 * n3n4 + 0.859375 * n5);
        double cp = 0.9375 * this.a * (n2n3 + 0.75 * n4n5);
        double dp = 0.7291666666666666 * this.a * (n3n4 + 0.6875 * n5);
        double ep = 0.615234375 * this.a * n4n5;
        return ap * phi - bp * sin2Phi + cp * sin4Phi - dp * sin6Phi + ep * sin8Phi;
    }

    public double meridionalRadiusOfCurvature(double phi) {
        return this.verticalRadiusOfCurvature(phi) / (1.0 + this.eb2 * Ellipsoid.sqr(Math.cos(phi)));
    }

    public double latitudeIsometric(double phi, double e) {
        double v1 = 1.0 - e * Math.sin(phi);
        double v2 = 1.0 + e * Math.sin(phi);
        return Math.log(Math.tan(0.7853981633974483 + phi / 2.0) * Math.pow(v1 / v2, e / 2.0));
    }

    public double latitudeIsometric(double phi) {
        double v1 = 1.0 - this.e * Math.sin(phi);
        double v2 = 1.0 + this.e * Math.sin(phi);
        return Math.log(Math.tan(0.7853981633974483 + phi / 2.0) * Math.pow(v1 / v2, this.e / 2.0));
    }

    public double latitude(double latIso, double e, double epsilon) {
        double lat0;
        double lati = lat0 = 2.0 * Math.atan(Math.exp(latIso)) - 1.5707963267948966;
        double lati1 = 1.0;
        while (Math.abs(lati1 - lati) >= epsilon) {
            lati = lati1;
            double v1 = 1.0 + e * Math.sin(lati);
            double v2 = 1.0 - e * Math.sin(lati);
            lati1 = 2.0 * Math.atan(Math.pow(v1 / v2, e / 2.0) * Math.exp(latIso)) - 1.5707963267948966;
        }
        return lati1;
    }

    public LatLon cart2LatLon(double[] xyz) {
        return this.cart2LatLon(xyz, 1.0E-11);
    }

    public LatLon cart2LatLon(double[] xyz, double epsilon) {
        double norm = Math.sqrt(xyz[0] * xyz[0] + xyz[1] * xyz[1]);
        double lg = 2.0 * Math.atan(xyz[1] / (xyz[0] + norm));
        double lt = Math.atan(xyz[2] / (norm * (1.0 - this.a * this.e2 / Math.sqrt(xyz[0] * xyz[0] + xyz[1] * xyz[1] + xyz[2] * xyz[2]))));
        double delta = 1.0;
        while (delta > epsilon) {
            double s2 = Math.sin(lt);
            s2 *= s2;
            double l = Math.atan(xyz[2] / norm / (1.0 - this.a * this.e2 * Math.cos(lt) / (norm * Math.sqrt(1.0 - this.e2 * s2))));
            delta = Math.abs(l - lt);
            lt = l;
        }
        return new LatLon(Math.toDegrees(lt), Math.toDegrees(lg));
    }

    public double[] latLon2Cart(LatLon coord) {
        double phi = Math.toRadians(coord.lat());
        double lambda = Math.toRadians(coord.lon());
        double Rn = this.a / Math.sqrt(1.0 - this.e2 * Math.pow(Math.sin(phi), 2.0));
        double[] xyz = new double[]{Rn * Math.cos(phi) * Math.cos(lambda), Rn * Math.cos(phi) * Math.sin(lambda), Rn * (1.0 - this.e2) * Math.sin(phi)};
        return xyz;
    }
}

