/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.projection.datum.CentricDatum;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.NullDatum;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class CustomProjection
extends AbstractProjection {
    protected String pref;
    protected String name;
    protected String code;
    protected String cacheDir;
    protected Bounds bounds;

    public CustomProjection() {
    }

    public CustomProjection(String pref2) {
        this(null, null, pref2, null);
    }

    public CustomProjection(String name, String code, String pref2, String cacheDir) {
        this.name = name;
        this.code = code;
        this.pref = pref2;
        this.cacheDir = cacheDir;
        try {
            this.update(pref2);
        }
        catch (ProjectionConfigurationException ex) {
            try {
                this.update(null);
            }
            catch (ProjectionConfigurationException ex1) {
                throw new RuntimeException(ex1);
            }
        }
    }

    public final void update(String pref2) throws ProjectionConfigurationException {
        this.pref = pref2;
        if (pref2 == null) {
            this.ellps = Ellipsoid.WGS84;
            this.datum = WGS84Datum.INSTANCE;
            this.proj = new Mercator();
            this.bounds = new Bounds(-85.05112877980659, -180.0, 85.05112877980659, 180.0, true);
        } else {
            Map<String, String> parameters = this.parseParameterList(pref2);
            this.ellps = this.parseEllipsoid(parameters);
            this.datum = this.parseDatum(parameters, this.ellps);
            this.proj = this.parseProjection(parameters, this.ellps);
            String s = parameters.get(Param.x_0.key);
            if (s != null) {
                this.x_0 = CustomProjection.parseDouble(s, Param.x_0.key);
            }
            if ((s = parameters.get(Param.y_0.key)) != null) {
                this.y_0 = CustomProjection.parseDouble(s, Param.y_0.key);
            }
            if ((s = parameters.get(Param.lon_0.key)) != null) {
                this.lon_0 = CustomProjection.parseAngle(s, Param.lon_0.key);
            }
            if ((s = parameters.get(Param.k_0.key)) != null) {
                this.k_0 = CustomProjection.parseDouble(s, Param.k_0.key);
            }
            if ((s = parameters.get(Param.bounds.key)) != null) {
                this.bounds = CustomProjection.parseBounds(s);
            }
            if ((s = parameters.get(Param.wmssrs.key)) != null) {
                this.code = s;
            }
        }
    }

    private Map<String, String> parseParameterList(String pref2) throws ProjectionConfigurationException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] parts = Utils.WHITE_SPACES_PATTERN.split(pref2.trim());
        if (pref2.trim().isEmpty()) {
            parts = new String[]{};
        }
        for (String part : parts) {
            String value;
            String key;
            if (part.isEmpty() || part.charAt(0) != '+') {
                throw new ProjectionConfigurationException(I18n.tr("Parameter must begin with a ''+'' character (found ''{0}'')", part));
            }
            Matcher m = Pattern.compile("\\+([a-zA-Z0-9_]+)(=(.*))?").matcher(part);
            if (m.matches()) {
                key = m.group(1);
                if ("k".equals(key)) {
                    key = Param.k_0.key;
                }
                value = null;
                if (m.groupCount() >= 3) {
                    value = m.group(3);
                    if (key.equals(Param.proj.key) && ("longlat".equals(value) || "latlon".equals(value) || "latlong".equals(value))) {
                        value = "lonlat";
                    }
                }
                if (!Param.paramsByKey.containsKey(key)) {
                    throw new ProjectionConfigurationException(I18n.tr("Unknown parameter: ''{0}''.", key));
                }
                if (Param.paramsByKey.get((Object)key).hasValue && value == null) {
                    throw new ProjectionConfigurationException(I18n.tr("Value expected for parameter ''{0}''.", key));
                }
                if (!Param.paramsByKey.get((Object)key).hasValue && value != null) {
                    throw new ProjectionConfigurationException(I18n.tr("No value expected for parameter ''{0}''.", key));
                }
            } else {
                throw new ProjectionConfigurationException(I18n.tr("Unexpected parameter format (''{0}'')", part));
            }
            parameters.put(key, value);
        }
        String initKey = (String)parameters.get(Param.init.key);
        if (initKey != null) {
            String init = Projections.getInit(initKey);
            if (init == null) {
                throw new ProjectionConfigurationException(I18n.tr("Value ''{0}'' for option +init not supported.", initKey));
            }
            Map<String, String> initp = null;
            try {
                initp = this.parseParameterList(init);
            }
            catch (ProjectionConfigurationException ex) {
                throw new ProjectionConfigurationException(I18n.tr(initKey + ": " + ex.getMessage(), new Object[0]), ex);
            }
            for (Map.Entry e : parameters.entrySet()) {
                initp.put((String)e.getKey(), (String)e.getValue());
            }
            return initp;
        }
        return parameters;
    }

    public Ellipsoid parseEllipsoid(Map<String, String> parameters) throws ProjectionConfigurationException {
        String code = parameters.get(Param.ellps.key);
        if (code != null) {
            Ellipsoid ellipsoid = Projections.getEllipsoid(code);
            if (ellipsoid == null) {
                throw new ProjectionConfigurationException(I18n.tr("Ellipsoid ''{0}'' not supported.", code));
            }
            return ellipsoid;
        }
        String s = parameters.get(Param.a.key);
        if (s != null) {
            double a = CustomProjection.parseDouble(s, Param.a.key);
            if (parameters.get(Param.es.key) != null) {
                double es = CustomProjection.parseDouble(parameters, Param.es.key);
                return Ellipsoid.create_a_es(a, es);
            }
            if (parameters.get(Param.rf.key) != null) {
                double rf = CustomProjection.parseDouble(parameters, Param.rf.key);
                return Ellipsoid.create_a_rf(a, rf);
            }
            if (parameters.get(Param.f.key) != null) {
                double f = CustomProjection.parseDouble(parameters, Param.f.key);
                return Ellipsoid.create_a_f(a, f);
            }
            if (parameters.get(Param.b.key) != null) {
                double b = CustomProjection.parseDouble(parameters, Param.b.key);
                return Ellipsoid.create_a_b(a, b);
            }
        }
        if (parameters.containsKey(Param.a.key) || parameters.containsKey(Param.es.key) || parameters.containsKey(Param.rf.key) || parameters.containsKey(Param.f.key) || parameters.containsKey(Param.b.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Combination of ellipsoid parameters is not supported.", new Object[0]));
        }
        if (parameters.containsKey(Param.no_defs.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Ellipsoid required (+ellps=* or +a=*, +b=*)", new Object[0]));
        }
        return Ellipsoid.WGS84;
    }

    public Datum parseDatum(Map<String, String> parameters, Ellipsoid ellps) throws ProjectionConfigurationException {
        String nadgridsId = parameters.get(Param.nadgrids.key);
        if (nadgridsId != null) {
            if (nadgridsId.startsWith("@")) {
                nadgridsId = nadgridsId.substring(1);
            }
            if ("null".equals(nadgridsId)) {
                return new NullDatum(null, ellps);
            }
            NTV2GridShiftFileWrapper nadgrids = Projections.getNTV2Grid(nadgridsId);
            if (nadgrids == null) {
                throw new ProjectionConfigurationException(I18n.tr("Grid shift file ''{0}'' for option +nadgrids not supported.", nadgridsId));
            }
            return new NTV2Datum(nadgridsId, null, ellps, nadgrids);
        }
        String towgs84 = parameters.get(Param.towgs84.key);
        if (towgs84 != null) {
            return this.parseToWGS84(towgs84, ellps);
        }
        String datumId = parameters.get(Param.datum.key);
        if (datumId != null) {
            Datum datum = Projections.getDatum(datumId);
            if (datum == null) {
                throw new ProjectionConfigurationException(I18n.tr("Unknown datum identifier: ''{0}''", datumId));
            }
            return datum;
        }
        if (parameters.containsKey(Param.no_defs.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Datum required (+datum=*, +towgs84=* or +nadgrids=*)", new Object[0]));
        }
        return new CentricDatum(null, null, ellps);
    }

    public Datum parseToWGS84(String paramList, Ellipsoid ellps) throws ProjectionConfigurationException {
        String[] numStr = paramList.split(",");
        if (numStr.length != 3 && numStr.length != 7) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''towgs84'' (must be 3 or 7)", new Object[0]));
        }
        ArrayList<Double> towgs84Param = new ArrayList<Double>();
        for (String str : numStr) {
            try {
                towgs84Param.add(Double.parseDouble(str));
            }
            catch (NumberFormatException e) {
                throw new ProjectionConfigurationException(I18n.tr("Unable to parse value of parameter ''towgs84'' (''{0}'')", str), e);
            }
        }
        boolean isCentric = true;
        for (Double param : towgs84Param) {
            if (param == 0.0) continue;
            isCentric = false;
            break;
        }
        if (isCentric) {
            return new CentricDatum(null, null, ellps);
        }
        boolean is3Param = true;
        for (int i = 3; i < towgs84Param.size(); ++i) {
            if ((Double)towgs84Param.get(i) == 0.0) continue;
            is3Param = false;
            break;
        }
        if (is3Param) {
            return new ThreeParameterDatum(null, null, ellps, (Double)towgs84Param.get(0), (Double)towgs84Param.get(1), (Double)towgs84Param.get(2));
        }
        return new SevenParameterDatum(null, null, ellps, (Double)towgs84Param.get(0), (Double)towgs84Param.get(1), (Double)towgs84Param.get(2), (Double)towgs84Param.get(3), (Double)towgs84Param.get(4), (Double)towgs84Param.get(5), (Double)towgs84Param.get(6));
    }

    public Proj parseProjection(Map<String, String> parameters, Ellipsoid ellps) throws ProjectionConfigurationException {
        String id = parameters.get(Param.proj.key);
        if (id == null) {
            throw new ProjectionConfigurationException(I18n.tr("Projection required (+proj=*)", new Object[0]));
        }
        Proj proj = Projections.getBaseProjection(id);
        if (proj == null) {
            throw new ProjectionConfigurationException(I18n.tr("Unknown projection identifier: ''{0}''", id));
        }
        ProjParameters projParams = new ProjParameters();
        projParams.ellps = ellps;
        String s = parameters.get(Param.lat_0.key);
        if (s != null) {
            projParams.lat_0 = CustomProjection.parseAngle(s, Param.lat_0.key);
        }
        if ((s = parameters.get(Param.lat_1.key)) != null) {
            projParams.lat_1 = CustomProjection.parseAngle(s, Param.lat_1.key);
        }
        if ((s = parameters.get(Param.lat_2.key)) != null) {
            projParams.lat_2 = CustomProjection.parseAngle(s, Param.lat_2.key);
        }
        proj.initialize(projParams);
        return proj;
    }

    public static Bounds parseBounds(String boundsStr) throws ProjectionConfigurationException {
        String[] numStr = boundsStr.split(",");
        if (numStr.length != 4) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''+bounds'' (must be 4)", new Object[0]));
        }
        return new Bounds(CustomProjection.parseAngle(numStr[1], "minlat (+bounds)"), CustomProjection.parseAngle(numStr[0], "minlon (+bounds)"), CustomProjection.parseAngle(numStr[3], "maxlat (+bounds)"), CustomProjection.parseAngle(numStr[2], "maxlon (+bounds)"), false);
    }

    public static double parseDouble(Map<String, String> parameters, String parameterName) throws ProjectionConfigurationException {
        if (!parameters.containsKey(parameterName)) {
            throw new IllegalArgumentException(I18n.tr("Unknown parameter ''{0}''", parameterName));
        }
        String doubleStr = parameters.get(parameterName);
        if (doubleStr == null) {
            throw new ProjectionConfigurationException(I18n.tr("Expected number argument for parameter ''{0}''", parameterName));
        }
        return CustomProjection.parseDouble(doubleStr, parameterName);
    }

    public static double parseDouble(String doubleStr, String parameterName) throws ProjectionConfigurationException {
        try {
            return Double.parseDouble(doubleStr);
        }
        catch (NumberFormatException e) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as number.", parameterName, doubleStr), e);
        }
    }

    public static double parseAngle(String angleStr, String parameterName) throws ProjectionConfigurationException {
        String s = angleStr;
        double value = 0.0;
        boolean neg = false;
        Matcher m = Pattern.compile("^-").matcher(s);
        if (m.find()) {
            neg = true;
            s = s.substring(m.end());
        }
        String FLOAT = "(\\d+(\\.\\d*)?)";
        boolean dms = false;
        double deg = 0.0;
        double min = 0.0;
        double sec = 0.0;
        m = Pattern.compile("^(\\d+(\\.\\d*)?)d").matcher(s);
        if (m.find()) {
            s = s.substring(m.end());
            deg = Double.parseDouble(m.group(1));
            dms = true;
        }
        if ((m = Pattern.compile("^(\\d+(\\.\\d*)?)'").matcher(s)).find()) {
            s = s.substring(m.end());
            min = Double.parseDouble(m.group(1));
            dms = true;
        }
        if ((m = Pattern.compile("^(\\d+(\\.\\d*)?)\"").matcher(s)).find()) {
            s = s.substring(m.end());
            sec = Double.parseDouble(m.group(1));
            dms = true;
        }
        if (dms) {
            value = deg + min / 60.0 + sec / 3600.0;
        } else {
            m = Pattern.compile("^(\\d+(\\.\\d*)?)").matcher(s);
            if (m.find()) {
                s = s.substring(m.end());
                value += Double.parseDouble(m.group(1));
            }
        }
        m = Pattern.compile("^(N|E)", 2).matcher(s);
        if (m.find()) {
            s = s.substring(m.end());
        } else {
            m = Pattern.compile("^(S|W)", 2).matcher(s);
            if (m.find()) {
                s = s.substring(m.end());
                boolean bl = neg = !neg;
            }
        }
        if (neg) {
            value = -value;
        }
        if (!s.isEmpty()) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as coordinate value.", parameterName, angleStr));
        }
        return value;
    }

    @Override
    public Integer getEpsgCode() {
        if (this.code != null && this.code.startsWith("EPSG:")) {
            try {
                return Integer.parseInt(this.code.substring(5));
            }
            catch (NumberFormatException e) {
                Main.warn(e);
            }
        }
        return null;
    }

    @Override
    public String toCode() {
        return this.code != null ? this.code : "proj:" + (this.pref == null ? "ERROR" : this.pref);
    }

    @Override
    public String getCacheDirectoryName() {
        return this.cacheDir != null ? this.cacheDir : "proj-" + Utils.md5Hex(this.pref == null ? "" : this.pref).substring(0, 4);
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        if (this.bounds != null) {
            return this.bounds;
        }
        return new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
    }

    @Override
    public String toString() {
        return this.name != null ? this.name : I18n.tr("Custom Projection", new Object[0]);
    }

    public static enum Param {
        x_0("x_0", true),
        y_0("y_0", true),
        lon_0("lon_0", true),
        k_0("k_0", true),
        ellps("ellps", true),
        a("a", true),
        es("es", true),
        rf("rf", true),
        f("f", true),
        b("b", true),
        datum("datum", true),
        towgs84("towgs84", true),
        nadgrids("nadgrids", true),
        proj("proj", true),
        lat_0("lat_0", true),
        lat_1("lat_1", true),
        lat_2("lat_2", true),
        wktext("wktext", false),
        units("units", true),
        no_defs("no_defs", false),
        init("init", true),
        wmssrs("wmssrs", true),
        bounds("bounds", true);

        public final String key;
        public final boolean hasValue;
        public static final Map<String, Param> paramsByKey;

        private Param(String key, boolean hasValue) {
            this.key = key;
            this.hasValue = hasValue;
        }

        static {
            paramsByKey = new HashMap<String, Param>();
            for (Param p : Param.values()) {
                paramsByKey.put(p.key, p);
            }
        }
    }
}

