/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.proj.Proj;

public abstract class AbstractProjection
implements Projection {
    protected Ellipsoid ellps;
    protected Datum datum;
    protected Proj proj;
    protected double x_0 = 0.0;
    protected double y_0 = 0.0;
    protected double lon_0 = 0.0;
    protected double k_0 = 1.0;

    public final Ellipsoid getEllipsoid() {
        return this.ellps;
    }

    public final Datum getDatum() {
        return this.datum;
    }

    public final Proj getProj() {
        return this.proj;
    }

    public final double getFalseEasting() {
        return this.x_0;
    }

    public final double getFalseNorthing() {
        return this.y_0;
    }

    public final double getCentralMeridian() {
        return this.lon_0;
    }

    public final double getScaleFactor() {
        return this.k_0;
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon ll) {
        ll = this.datum.fromWGS84(ll);
        double[] en = this.proj.project(Math.toRadians(ll.lat()), Math.toRadians(ll.lon() - this.lon_0));
        return new EastNorth(this.ellps.a * this.k_0 * en[0] + this.x_0, this.ellps.a * this.k_0 * en[1] + this.y_0);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth en) {
        double[] latlon_rad = this.proj.invproject((en.east() - this.x_0) / this.ellps.a / this.k_0, (en.north() - this.y_0) / this.ellps.a / this.k_0);
        LatLon ll = new LatLon(Math.toDegrees(latlon_rad[0]), Math.toDegrees(latlon_rad[1]) + this.lon_0);
        return this.datum.toWGS84(ll);
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    public abstract Integer getEpsgCode();

    @Override
    public String toCode() {
        return "EPSG:" + this.getEpsgCode();
    }

    protected static final double convertMinuteSecond(double minute, double second) {
        return minute / 60.0 + second / 3600.0;
    }

    protected static final double convertDegreeMinuteSecond(double degree, double minute, double second) {
        return degree + minute / 60.0 + second / 3600.0;
    }
}

