/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.AbstractProperty;

public class IntegerProperty
extends AbstractProperty<Integer> {
    public IntegerProperty(String key, int defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public Integer get() {
        return Main.pref.getInteger(this.getKey(), (Integer)this.getDefaultValue());
    }

    @Override
    public boolean put(Integer value) {
        return Main.pref.putInteger(this.getKey(), value);
    }

    public boolean parseAndPut(String value) {
        Integer intVal;
        try {
            intVal = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.put(intVal);
    }
}

