/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.AbstractProperty;

public abstract class CachedProperty<T>
extends AbstractProperty<T>
implements Preferences.PreferenceChangedListener {
    private final String defaultValueAsString;
    private T value;
    private int updateCount;

    protected CachedProperty(String key, String defaultValueAsString) {
        super(key, null);
        Main.pref.addPreferenceChangeListener(this);
        this.defaultValueAsString = defaultValueAsString;
        this.updateValue();
    }

    protected final void updateValue() {
        this.value = !Main.pref.get(this.key).isEmpty() ? this.fromString(Main.pref.get(this.key)) : this.getDefaultValue();
        ++this.updateCount;
    }

    protected abstract T fromString(String var1);

    @Override
    public T get() {
        return this.value;
    }

    public void put(String value) {
        Main.pref.put(this.key, value);
        this.value = this.fromString(value);
        ++this.updateCount;
    }

    @Override
    public final boolean put(T value) {
        throw new IllegalAccessError("You cannot use put(T). Use put(String) instead.");
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public T getDefaultValue() {
        return this.fromString(this.getDefaultValueAsString());
    }

    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    public String getAsString() {
        return Main.pref.get(this.getKey(), this.getDefaultValueAsString());
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        if (e.getKey().equals(this.key)) {
            this.updateValue();
        }
    }
}

