/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public final class MultipolygonCache
implements SelectionChangedListener,
DataSetListener,
ProjectionChangeListener,
MapView.LayerChangeListener {
    private static final MultipolygonCache INSTANCE = new MultipolygonCache();
    private final Map<NavigatableComponent, Map<DataSet, Map<Relation, Multipolygon>>> cache = new HashMap<NavigatableComponent, Map<DataSet, Map<Relation, Multipolygon>>>();
    private final Collection<Multipolygon.PolyData> selectedPolyData = new ArrayList<Multipolygon.PolyData>();

    private MultipolygonCache() {
        Main.addProjectionChangeListener(this);
        DataSet.addSelectionListener(this);
        MapView.addLayerChangeListener(this);
    }

    public static final MultipolygonCache getInstance() {
        return INSTANCE;
    }

    public final Multipolygon get(NavigatableComponent nc, Relation r) {
        return this.get(nc, r, false);
    }

    public final Multipolygon get(NavigatableComponent nc, Relation r, boolean forceRefresh) {
        Multipolygon multipolygon = null;
        if (nc != null && r != null) {
            Map<Relation, Multipolygon> map2;
            Map<DataSet, Map<Relation, Multipolygon>> map1 = this.cache.get(nc);
            if (map1 == null) {
                map1 = new HashMap<DataSet, Map<Relation, Multipolygon>>();
                this.cache.put(nc, map1);
            }
            if ((map2 = map1.get(r.getDataSet())) == null) {
                map2 = new HashMap<Relation, Multipolygon>();
                map1.put(r.getDataSet(), map2);
            }
            if ((multipolygon = map2.get(r)) == null || forceRefresh) {
                multipolygon = new Multipolygon(r);
                map2.put(r, multipolygon);
                for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                    if (!pd.selected) continue;
                    this.selectedPolyData.add(pd);
                }
            }
        }
        return multipolygon;
    }

    public final void clear(NavigatableComponent nc) {
        Map<DataSet, Map<Relation, Multipolygon>> map = this.cache.remove(nc);
        if (map != null) {
            map.clear();
            map = null;
        }
    }

    public final void clear(DataSet ds) {
        for (Map<DataSet, Map<Relation, Multipolygon>> map1 : this.cache.values()) {
            Map<Relation, Multipolygon> map2 = map1.remove(ds);
            if (map2 == null) continue;
            map2.clear();
            map2 = null;
        }
    }

    public final void clear() {
        this.cache.clear();
    }

    private final Collection<Map<Relation, Multipolygon>> getMapsFor(DataSet ds) {
        ArrayList<Map<Relation, Multipolygon>> result = new ArrayList<Map<Relation, Multipolygon>>();
        for (Map<DataSet, Map<Relation, Multipolygon>> map : this.cache.values()) {
            Map<Relation, Multipolygon> map2 = map.get(ds);
            if (map2 == null) continue;
            result.add(map2);
        }
        return result;
    }

    private static final boolean isMultipolygon(OsmPrimitive p) {
        return p instanceof Relation && ((Relation)p).isMultipolygon();
    }

    private final void updateMultipolygonsReferringTo(AbstractDatasetChangedEvent event) {
        this.updateMultipolygonsReferringTo(event, event.getPrimitives(), event.getDataset());
    }

    private final void updateMultipolygonsReferringTo(AbstractDatasetChangedEvent event, Collection<? extends OsmPrimitive> primitives, DataSet ds) {
        this.updateMultipolygonsReferringTo(event, primitives, ds, null);
    }

    private final Collection<Map<Relation, Multipolygon>> updateMultipolygonsReferringTo(AbstractDatasetChangedEvent event, Collection<? extends OsmPrimitive> primitives, DataSet ds, Collection<Map<Relation, Multipolygon>> initialMaps) {
        Collection<Map<Relation, Multipolygon>> maps = initialMaps;
        if (primitives != null) {
            for (OsmPrimitive osmPrimitive : primitives) {
                if (MultipolygonCache.isMultipolygon(osmPrimitive)) {
                    if (maps == null) {
                        maps = this.getMapsFor(ds);
                    }
                    this.processEvent(event, (Relation)osmPrimitive, maps);
                    continue;
                }
                if (osmPrimitive instanceof Way && osmPrimitive.getDataSet() != null) {
                    for (OsmPrimitive ref : osmPrimitive.getReferrers()) {
                        if (!MultipolygonCache.isMultipolygon(ref)) continue;
                        if (maps == null) {
                            maps = this.getMapsFor(ds);
                        }
                        this.processEvent(event, (Relation)ref, maps);
                    }
                    continue;
                }
                if (!(osmPrimitive instanceof Node) || osmPrimitive.getDataSet() == null) continue;
                maps = this.updateMultipolygonsReferringTo(event, osmPrimitive.getReferrers(), ds, maps);
            }
        }
        return maps;
    }

    private final void processEvent(AbstractDatasetChangedEvent event, Relation r, Collection<Map<Relation, Multipolygon>> maps) {
        if (event instanceof NodeMovedEvent || event instanceof WayNodesChangedEvent) {
            this.dispatchEvent(event, r, maps);
        } else if (event instanceof PrimitivesRemovedEvent) {
            if (event.getPrimitives().contains(r)) {
                this.removeMultipolygonFrom(r, maps);
            }
        } else {
            this.removeMultipolygonFrom(r, maps);
        }
    }

    private final void dispatchEvent(AbstractDatasetChangedEvent event, Relation r, Collection<Map<Relation, Multipolygon>> maps) {
        for (Map<Relation, Multipolygon> map : maps) {
            Multipolygon m = map.get(r);
            if (m == null) continue;
            for (Multipolygon.PolyData pd : m.getCombinedPolygons()) {
                if (event instanceof NodeMovedEvent) {
                    pd.nodeMoved((NodeMovedEvent)event);
                    continue;
                }
                if (!(event instanceof WayNodesChangedEvent)) continue;
                pd.wayNodesChanged((WayNodesChangedEvent)event);
            }
        }
    }

    private final void removeMultipolygonFrom(Relation r, Collection<Map<Relation, Multipolygon>> maps) {
        for (Map<Relation, Multipolygon> map : maps) {
            map.remove(r);
        }
        for (OsmPrimitive member : r.getMemberPrimitives()) {
            member.clearCachedStyle();
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.updateMultipolygonsReferringTo(event);
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        Collection<Map<Relation, Multipolygon>> maps = null;
        for (OsmPrimitive p : event.getPrimitives()) {
            if (!MultipolygonCache.isMultipolygon(p)) continue;
            if (maps == null) {
                maps = this.getMapsFor(event.getDataset());
            }
            for (Map map : maps) {
                map.remove(p);
            }
        }
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof OsmDataLayer) {
            this.clear(((OsmDataLayer)oldLayer).data);
        }
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        this.clear();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        Iterator<Multipolygon.PolyData> it = this.selectedPolyData.iterator();
        while (it.hasNext()) {
            it.next().selected = false;
            it.remove();
        }
        DataSet ds = null;
        Collection<Map<Relation, Multipolygon>> maps = null;
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.getDataSet() == null) continue;
            if (ds == null) {
                ds = osmPrimitive.getDataSet();
            }
            for (OsmPrimitive ref : osmPrimitive.getReferrers()) {
                if (!MultipolygonCache.isMultipolygon(ref)) continue;
                if (maps == null) {
                    maps = this.getMapsFor(ds);
                }
                for (Map map : maps) {
                    Multipolygon multipolygon = (Multipolygon)map.get(ref);
                    if (multipolygon == null) continue;
                    for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                        if (!pd.getWayIds().contains(osmPrimitive.getUniqueId())) continue;
                        pd.selected = true;
                        this.selectedPolyData.add(pd);
                    }
                }
            }
        }
    }
}

