/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;

public class Multipolygon {
    public static final String PREF_KEY_OUTER_ROLES = "mappaint.multipolygon.outer.roles";
    public static final String PREF_KEY_OUTER_ROLE_PREFIXES = "mappaint.multipolygon.outer.role-prefixes";
    public static final String PREF_KEY_INNER_ROLES = "mappaint.multipolygon.inner.roles";
    public static final String PREF_KEY_INNER_ROLE_PREFIXES = "mappaint.multipolygon.inner.role-prefixes";
    private static MultipolygonRoleMatcher roleMatcher;
    private final List<Way> innerWays = new ArrayList<Way>();
    private final List<Way> outerWays = new ArrayList<Way>();
    private final List<PolyData> innerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> outerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> combinedPolygons = new ArrayList<PolyData>();
    private boolean incomplete;

    private static synchronized MultipolygonRoleMatcher getMultipolygonRoleMatcher() {
        if (roleMatcher == null) {
            roleMatcher = new MultipolygonRoleMatcher();
            if (Main.pref != null) {
                Multipolygon.roleMatcher.initFromPreferences();
                Main.pref.addPreferenceChangeListener(roleMatcher);
            }
        }
        return roleMatcher;
    }

    public Multipolygon(Relation r) {
        this.load(r);
    }

    private final void load(Relation r) {
        MultipolygonRoleMatcher matcher = Multipolygon.getMultipolygonRoleMatcher();
        for (RelationMember m : r.getMembers()) {
            Way w;
            if (m.getMember().isIncomplete()) {
                this.incomplete = true;
                continue;
            }
            if (!m.getMember().isDrawable() || !m.isWay() || (w = m.getWay()).getNodesCount() < 2) continue;
            if (matcher.isInnerRole(m.getRole())) {
                this.innerWays.add(w);
                continue;
            }
            if (matcher.isOuterRole(m.getRole())) {
                this.outerWays.add(w);
                continue;
            }
            if (m.hasRole()) continue;
            this.outerWays.add(w);
        }
        this.createPolygons(this.innerWays, this.innerPolygons);
        this.createPolygons(this.outerWays, this.outerPolygons);
        if (!this.outerPolygons.isEmpty()) {
            this.addInnerToOuters();
        }
    }

    public final boolean isIncomplete() {
        return this.incomplete;
    }

    private void createPolygons(List<Way> ways, List<PolyData> result) {
        ArrayList<Way> waysToJoin = new ArrayList<Way>();
        for (Way way : ways) {
            if (way.isClosed()) {
                result.add(new PolyData(way));
                continue;
            }
            waysToJoin.add(way);
        }
        for (JoinedWay jw : Multipolygon.joinWays(waysToJoin)) {
            result.add(new PolyData(jw));
        }
    }

    public static Collection<JoinedWay> joinWays(Collection<Way> waysToJoin) {
        ArrayList<JoinedWay> result = new ArrayList<JoinedWay>();
        Way[] joinArray = waysToJoin.toArray(new Way[waysToJoin.size()]);
        int left = waysToJoin.size();
        while (left > 0) {
            Way w = null;
            boolean selected = false;
            List<Node> nodes = null;
            HashSet<Long> wayIds = new HashSet<Long>();
            boolean joined = true;
            while (joined && left > 0) {
                joined = false;
                for (int i = 0; i < joinArray.length && left != 0; ++i) {
                    int nl;
                    Way c;
                    if (joinArray[i] == null || (c = joinArray[i]).getNodesCount() == 0) continue;
                    if (w == null) {
                        w = c;
                        selected = w.isSelected();
                        joinArray[i] = null;
                        --left;
                        continue;
                    }
                    int mode = 0;
                    int cl = c.getNodesCount() - 1;
                    if (nodes == null) {
                        nl = w.getNodesCount() - 1;
                        if (w.getNode(nl) == c.getNode(0)) {
                            mode = 21;
                        } else if (w.getNode(nl) == c.getNode(cl)) {
                            mode = 22;
                        } else if (w.getNode(0) == c.getNode(0)) {
                            mode = 11;
                        } else if (w.getNode(0) == c.getNode(cl)) {
                            mode = 12;
                        }
                    } else {
                        nl = nodes.size() - 1;
                        if (nodes.get(nl) == c.getNode(0)) {
                            mode = 21;
                        } else if (nodes.get(0) == c.getNode(cl)) {
                            mode = 12;
                        } else if (nodes.get(0) == c.getNode(0)) {
                            mode = 11;
                        } else if (nodes.get(nl) == c.getNode(cl)) {
                            mode = 22;
                        }
                    }
                    if (mode == 0) continue;
                    joinArray[i] = null;
                    joined = true;
                    if (c.isSelected()) {
                        selected = true;
                    }
                    --left;
                    if (nodes == null) {
                        nodes = w.getNodes();
                        wayIds.add(w.getUniqueId());
                    }
                    nodes.remove(mode == 21 || mode == 22 ? nl : 0);
                    if (mode == 21) {
                        nodes.addAll(c.getNodes());
                    } else if (mode == 12) {
                        nodes.addAll(0, c.getNodes());
                    } else if (mode == 22) {
                        for (Node node : c.getNodes()) {
                            nodes.add(nl, node);
                        }
                    } else {
                        for (Node node : c.getNodes()) {
                            nodes.add(0, node);
                        }
                    }
                    wayIds.add(c.getUniqueId());
                }
            }
            if (nodes == null && w != null) {
                nodes = w.getNodes();
                wayIds.add(w.getUniqueId());
            }
            result.add(new JoinedWay(nodes, wayIds, selected));
        }
        return result;
    }

    public PolyData findOuterPolygon(PolyData inner, List<PolyData> outerPolygons) {
        Rectangle2D innerBox = inner.getBounds();
        PolyData insidePolygon = null;
        PolyData intersectingPolygon = null;
        int insideCount = 0;
        int intersectingCount = 0;
        for (PolyData outer : outerPolygons) {
            if (outer.getBounds().contains(innerBox)) {
                insidePolygon = outer;
                ++insideCount;
                continue;
            }
            if (!outer.getBounds().intersects(innerBox)) continue;
            intersectingPolygon = outer;
            ++intersectingCount;
        }
        if (insideCount == 1) {
            return insidePolygon;
        }
        if (intersectingCount == 1) {
            return intersectingPolygon;
        }
        PolyData result = null;
        for (PolyData combined : outerPolygons) {
            if (combined.contains(inner.poly) == PolyData.Intersection.OUTSIDE || result != null && result.contains(combined.poly) != PolyData.Intersection.INSIDE) continue;
            result = combined;
        }
        return result;
    }

    private final void addInnerToOuters() {
        if (this.innerPolygons.isEmpty()) {
            this.combinedPolygons.addAll(this.outerPolygons);
        } else if (this.outerPolygons.size() == 1) {
            PolyData combinedOuter = new PolyData(this.outerPolygons.get(0));
            for (PolyData inner : this.innerPolygons) {
                combinedOuter.addInner(inner);
            }
            this.combinedPolygons.add(combinedOuter);
        } else {
            for (PolyData outer : this.outerPolygons) {
                this.combinedPolygons.add(new PolyData(outer));
            }
            for (PolyData pdInner : this.innerPolygons) {
                PolyData o = this.findOuterPolygon(pdInner, this.combinedPolygons);
                if (o == null) {
                    o = this.outerPolygons.get(0);
                }
                o.addInner(pdInner);
            }
        }
        this.innerPolygons.clear();
        this.outerPolygons.clear();
    }

    public List<Way> getOuterWays() {
        return this.outerWays;
    }

    public List<Way> getInnerWays() {
        return this.innerWays;
    }

    public List<PolyData> getCombinedPolygons() {
        return this.combinedPolygons;
    }

    public static class PolyData {
        private final Path2D.Double poly;
        public boolean selected;
        private Rectangle2D bounds;
        private final Collection<Long> wayIds;
        private final List<Node> nodes;
        private final List<PolyData> inners;

        public PolyData(Way closedWay) {
            this(closedWay.getNodes(), closedWay.isSelected(), Collections.singleton(closedWay.getUniqueId()));
        }

        public PolyData(JoinedWay joinedWay) {
            this(joinedWay.getNodes(), joinedWay.isSelected(), joinedWay.getWayIds());
        }

        private PolyData(List<Node> nodes, boolean selected, Collection<Long> wayIds) {
            this.wayIds = Collections.unmodifiableCollection(wayIds);
            this.nodes = new ArrayList<Node>(nodes);
            this.selected = selected;
            this.inners = new ArrayList<PolyData>();
            this.poly = new Path2D.Double();
            this.poly.setWindingRule(0);
            this.buildPoly();
        }

        private void buildPoly() {
            boolean initial = true;
            for (Node n : this.nodes) {
                EastNorth p = n.getEastNorth();
                if (p == null) continue;
                if (initial) {
                    this.poly.moveTo(p.getX(), p.getY());
                    initial = false;
                    continue;
                }
                this.poly.lineTo(p.getX(), p.getY());
            }
            if (!initial) {
                this.poly.closePath();
            }
            for (PolyData inner : this.inners) {
                this.appendInner(inner.poly);
            }
        }

        public PolyData(PolyData copy) {
            this.selected = copy.selected;
            this.poly = (Path2D.Double)copy.poly.clone();
            this.wayIds = Collections.unmodifiableCollection(copy.wayIds);
            this.nodes = new ArrayList<Node>(copy.nodes);
            this.inners = new ArrayList<PolyData>(copy.inners);
        }

        public Intersection contains(Path2D.Double p) {
            int contains = 0;
            int total = 0;
            double[] coords = new double[6];
            PathIterator it = p.getPathIterator(null);
            while (!it.isDone()) {
                switch (it.currentSegment(coords)) {
                    case 0: 
                    case 1: {
                        if (this.poly.contains(coords[0], coords[1])) {
                            ++contains;
                        }
                        ++total;
                    }
                }
                it.next();
            }
            if (contains == total) {
                return Intersection.INSIDE;
            }
            if (contains == 0) {
                return Intersection.OUTSIDE;
            }
            return Intersection.CROSSING;
        }

        public void addInner(PolyData inner) {
            this.inners.add(inner);
            this.appendInner(inner.poly);
        }

        private void appendInner(Path2D.Double inner) {
            this.poly.append(inner.getPathIterator(null), false);
        }

        public Path2D.Double get() {
            return this.poly;
        }

        public Rectangle2D getBounds() {
            if (this.bounds == null) {
                this.bounds = this.poly.getBounds2D();
            }
            return this.bounds;
        }

        public Collection<Long> getWayIds() {
            return this.wayIds;
        }

        private void resetNodes(DataSet dataSet) {
            if (!this.nodes.isEmpty()) {
                DataSet ds = dataSet;
                Iterator<Node> it = this.nodes.iterator();
                while (it.hasNext() && ds == null) {
                    ds = it.next().getDataSet();
                }
                this.nodes.clear();
                if (ds == null) {
                    Main.warn("DataSet not found while resetting nodes in Multipolygon. This should not happen, you may report it to JOSM developers.");
                } else if (this.wayIds.size() == 1) {
                    Way w = (Way)ds.getPrimitiveById(this.wayIds.iterator().next(), OsmPrimitiveType.WAY);
                    this.nodes.addAll(w.getNodes());
                } else if (!this.wayIds.isEmpty()) {
                    ArrayList<Way> waysToJoin = new ArrayList<Way>();
                    for (Long wayId : this.wayIds) {
                        Way w = (Way)ds.getPrimitiveById(wayId, OsmPrimitiveType.WAY);
                        if (w == null || w.getNodesCount() <= 0) continue;
                        waysToJoin.add(w);
                    }
                    if (!waysToJoin.isEmpty()) {
                        this.nodes.addAll(Multipolygon.joinWays(waysToJoin).iterator().next().getNodes());
                    }
                }
                this.resetPoly();
            }
        }

        private void resetPoly() {
            this.poly.reset();
            this.buildPoly();
            this.bounds = null;
        }

        public void nodeMoved(NodeMovedEvent event) {
            Node n = event.getNode();
            boolean innerChanged = false;
            for (PolyData inner : this.inners) {
                if (!inner.nodes.contains(n)) continue;
                inner.resetPoly();
                innerChanged = true;
            }
            if (this.nodes.contains(n) || innerChanged) {
                this.resetPoly();
            }
        }

        public void wayNodesChanged(WayNodesChangedEvent event) {
            Long wayId = event.getChangedWay().getUniqueId();
            boolean innerChanged = false;
            for (PolyData inner : this.inners) {
                if (!inner.wayIds.contains(wayId)) continue;
                inner.resetNodes(event.getDataset());
                innerChanged = true;
            }
            if (this.wayIds.contains(wayId) || innerChanged) {
                this.resetNodes(event.getDataset());
            }
        }

        public static enum Intersection {
            INSIDE,
            OUTSIDE,
            CROSSING;

        }
    }

    public static class JoinedWay {
        private final List<Node> nodes;
        private final Collection<Long> wayIds;
        private final boolean selected;

        public JoinedWay(List<Node> nodes, Collection<Long> wayIds, boolean selected) {
            this.nodes = nodes;
            this.wayIds = wayIds;
            this.selected = selected;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public Collection<Long> getWayIds() {
            return this.wayIds;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isClosed() {
            return this.nodes.isEmpty() || this.nodes.get(this.nodes.size() - 1).equals(this.nodes.get(0));
        }
    }

    private static class MultipolygonRoleMatcher
    implements Preferences.PreferenceChangedListener {
        private final List<String> outerExactRoles = new ArrayList<String>();
        private final List<String> outerRolePrefixes = new ArrayList<String>();
        private final List<String> innerExactRoles = new ArrayList<String>();
        private final List<String> innerRolePrefixes = new ArrayList<String>();

        private MultipolygonRoleMatcher() {
        }

        private void initDefaults() {
            this.outerExactRoles.clear();
            this.outerRolePrefixes.clear();
            this.innerExactRoles.clear();
            this.innerRolePrefixes.clear();
            this.outerExactRoles.add("outer");
            this.innerExactRoles.add("inner");
        }

        private void setNormalized(Collection<String> literals, List<String> target) {
            target.clear();
            for (String l : literals) {
                if (l == null || target.contains(l = l.trim())) continue;
                target.add(l);
            }
        }

        private void initFromPreferences() {
            this.initDefaults();
            if (Main.pref == null) {
                return;
            }
            Collection<String> literals = Main.pref.getCollection(Multipolygon.PREF_KEY_OUTER_ROLES);
            if (literals != null && !literals.isEmpty()) {
                this.setNormalized(literals, this.outerExactRoles);
            }
            if ((literals = Main.pref.getCollection(Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES)) != null && !literals.isEmpty()) {
                this.setNormalized(literals, this.outerRolePrefixes);
            }
            if ((literals = Main.pref.getCollection(Multipolygon.PREF_KEY_INNER_ROLES)) != null && !literals.isEmpty()) {
                this.setNormalized(literals, this.innerExactRoles);
            }
            if ((literals = Main.pref.getCollection(Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES)) != null && !literals.isEmpty()) {
                this.setNormalized(literals, this.innerRolePrefixes);
            }
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent evt) {
            if (Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES.equals(evt.getKey()) || Multipolygon.PREF_KEY_INNER_ROLES.equals(evt.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES.equals(evt.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLES.equals(evt.getKey())) {
                this.initFromPreferences();
            }
        }

        public boolean isOuterRole(String role) {
            if (role == null) {
                return false;
            }
            for (String candidate : this.outerExactRoles) {
                if (!role.equals(candidate)) continue;
                return true;
            }
            for (String candidate : this.outerRolePrefixes) {
                if (!role.startsWith(candidate)) continue;
                return true;
            }
            return false;
        }

        public boolean isInnerRole(String role) {
            if (role == null) {
                return false;
            }
            for (String candidate : this.innerExactRoles) {
                if (!role.equals(candidate)) continue;
                return true;
            }
            for (String candidate : this.innerRolePrefixes) {
                if (!role.startsWith(candidate)) continue;
                return true;
            }
            return false;
        }
    }
}

