/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class WireframeMapRenderer
extends AbstractMapRenderer
implements Visitor {
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color taggedColor;
    protected Color connectionColor;
    protected Color taggedConnectionColor;
    protected boolean showDirectionArrow;
    protected boolean showOnewayArrow;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected boolean fillTaggedNode;
    protected boolean fillConnectionNode;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int connectionNodeSize;
    protected int taggedNodeSize;
    protected Color currentColor = null;
    protected GeneralPath currentPath = new GeneralPath();
    private DataSet ds;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);
    private Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);

    public WireframeMapRenderer(Graphics2D g, NavigatableComponent nc, boolean isInactiveMode) {
        super(g, nc, isInactiveMode);
    }

    @Override
    public void getColors() {
        super.getColors();
        this.dfltWayColor = PaintColors.DEFAULT_WAY.get();
        this.relationColor = PaintColors.RELATION.get();
        this.untaggedWayColor = PaintColors.UNTAGGED_WAY.get();
        this.highlightColor = PaintColors.HIGHLIGHT_WIREFRAME.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = this.taggedColor != this.nodeColor ? this.taggedColor : this.connectionColor;
    }

    @Override
    protected void getSettings(boolean virtual) {
        super.getSettings(virtual);
        MapPaintSettings settings = MapPaintSettings.INSTANCE;
        this.showDirectionArrow = settings.isShowDirectionArrow();
        this.showOnewayArrow = settings.isShowOnewayArrow();
        this.showHeadArrowOnly = settings.isShowHeadArrowOnly();
        this.showOrderNumber = settings.isShowOrderNumber();
        this.selectedNodeSize = settings.getSelectedNodeSize();
        this.unselectedNodeSize = settings.getUnselectedNodeSize();
        this.connectionNodeSize = settings.getConnectionNodeSize();
        this.taggedNodeSize = settings.getTaggedNodeSize();
        this.fillSelectedNode = settings.isFillSelectedNode();
        this.fillUnselectedNode = settings.isFillUnselectedNode();
        this.fillConnectionNode = settings.isFillConnectionNode();
        this.fillTaggedNode = settings.isFillTaggedNode();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.wireframe.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void render(DataSet data, boolean virtual, Bounds bounds) {
        BBox bbox = bounds.toBBox();
        this.ds = data;
        this.getSettings(virtual);
        for (Relation rel : data.searchRelations(bbox)) {
            if (!rel.isDrawable() || this.ds.isSelected(rel) || rel.isDisabledAndHidden()) continue;
            rel.accept(this);
        }
        ArrayList<Way> highlightedWays = new ArrayList<Way>();
        ArrayList<Way> untaggedWays = new ArrayList<Way>();
        for (Way way : data.searchWays(bbox)) {
            if (!way.isDrawable() || this.ds.isSelected(way) || way.isDisabledAndHidden()) continue;
            if (way.isHighlighted()) {
                highlightedWays.add(way);
                continue;
            }
            if (!way.isTagged()) {
                untaggedWays.add(way);
                continue;
            }
            way.accept(this);
        }
        this.displaySegments();
        ArrayList<Way> specialWays = new ArrayList<Way>(untaggedWays);
        specialWays.addAll(highlightedWays);
        for (Way way : specialWays) {
            way.accept(this);
        }
        specialWays.clear();
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (!osmPrimitive.isDrawable()) continue;
            osmPrimitive.accept(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.searchNodes(bbox)) {
            if (!osmPrimitive.isDrawable() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isDisabledAndHidden()) continue;
            osmPrimitive.accept(this);
        }
        this.drawVirtualNodes(data, bbox);
        for (WaySegment waySegment : data.getHighlightedWaySegments()) {
            this.drawSegment(this.nc.getPoint(waySegment.getFirstNode()), this.nc.getPoint(waySegment.getSecondNode()), this.highlightColor, false);
        }
        this.displaySegments();
    }

    private static final int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    @Override
    public void visit(Node n) {
        if (n.isIncomplete()) {
            return;
        }
        if (n.isHighlighted()) {
            this.drawNode(n, this.highlightColor, this.selectedNodeSize, this.fillSelectedNode);
        } else {
            Color color = this.isInactiveMode || n.isDisabled() ? this.inactiveColor : (n.isSelected() ? this.selectedColor : (n.isMemberOfSelected() ? this.relationSelectedColor : (n.isConnectionNode() ? (this.isNodeTagged(n) ? this.taggedConnectionColor : this.connectionColor) : (this.isNodeTagged(n) ? this.taggedColor : this.nodeColor))));
            int size = WireframeMapRenderer.max(this.ds.isSelected(n) ? this.selectedNodeSize : 0, this.isNodeTagged(n) ? this.taggedNodeSize : 0, n.isConnectionNode() ? this.connectionNodeSize : 0, this.unselectedNodeSize);
            boolean fill = this.ds.isSelected(n) && this.fillSelectedNode || this.isNodeTagged(n) && this.fillTaggedNode || n.isConnectionNode() && this.fillConnectionNode || this.fillUnselectedNode;
            this.drawNode(n, color, size, fill);
        }
    }

    private boolean isNodeTagged(Node n) {
        return n.isTagged() || n.isAnnotated();
    }

    @Override
    public void visit(Way w) {
        boolean showOnlyHeadArrowOnly;
        if (w.isIncomplete() || w.getNodesCount() < 2) {
            return;
        }
        boolean showThisDirectionArrow = this.ds.isSelected(w) || this.showDirectionArrow;
        boolean bl = showOnlyHeadArrowOnly = showThisDirectionArrow && !this.ds.isSelected(w) && this.showHeadArrowOnly;
        Color wayColor = this.isInactiveMode || w.isDisabled() ? this.inactiveColor : (w.isHighlighted() ? this.highlightColor : (w.isSelected() ? this.selectedColor : (w.isMemberOfSelected() ? this.relationSelectedColor : (!w.isTagged() ? this.untaggedWayColor : this.dfltWayColor))));
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            Point lastP = this.nc.getPoint(it.next());
            int orderNumber = 1;
            while (it.hasNext()) {
                Point p = this.nc.getPoint(it.next());
                this.drawSegment(lastP, p, wayColor, showOnlyHeadArrowOnly ? !it.hasNext() : showThisDirectionArrow);
                if (this.showOrderNumber && !this.isInactiveMode) {
                    this.drawOrderNumber(lastP, p, orderNumber, this.g.getColor());
                }
                lastP = p;
                ++orderNumber;
            }
        }
    }

    @Override
    public void visit(Relation r) {
        if (r.isIncomplete()) {
            return;
        }
        Color col = this.isInactiveMode || r.isDisabled() ? this.inactiveColor : (r.isSelected() ? this.selectedColor : (r.isMultipolygon() && r.isMemberOfSelected() ? this.relationSelectedColor : this.relationColor));
        this.g.setColor(col);
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete() || !m.getMember().isDrawable()) continue;
            if (m.isNode()) {
                Point p = this.nc.getPoint(m.getNode());
                if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) continue;
                this.g.drawOval(p.x - 4, p.y - 4, 9, 9);
                continue;
            }
            if (!m.isWay()) continue;
            GeneralPath path = new GeneralPath();
            boolean first = true;
            for (Node n : m.getWay().getNodes()) {
                if (!n.isDrawable()) continue;
                Point p = this.nc.getPoint(n);
                if (first) {
                    path.moveTo(p.x, p.y);
                    first = false;
                    continue;
                }
                path.lineTo(p.x, p.y);
            }
            this.g.draw(this.relatedWayStroke.createStrokedShape(path));
        }
    }

    @Override
    public void visit(Changeset cs) {
    }

    @Override
    public void drawNode(Node n, Color color, int size, boolean fill) {
        if (size > 1) {
            int radius = size / 2;
            Point p = this.nc.getPoint(n);
            if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (fill) {
                this.g.fillRect(p.x - radius, p.y - radius, size, size);
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            } else {
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            }
        }
    }

    protected void drawSegment(GeneralPath path, Point p1, Point p2, boolean showDirection) {
        Rectangle bounds = this.g.getClipBounds();
        bounds.grow(100, 100);
        LineClip clip = new LineClip(p1, p2, bounds);
        if (clip.execute()) {
            p1 = clip.getP1();
            p2 = clip.getP2();
            path.moveTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
            if (showDirection) {
                double l = 10.0 / p1.distance(p2);
                double sx = l * (double)(p1.x - p2.x);
                double sy = l * (double)(p1.y - p2.y);
                path.lineTo(p2.x + (int)Math.round(cosPHI * sx - sinPHI * sy), p2.y + (int)Math.round(sinPHI * sx + cosPHI * sy));
                path.moveTo(p2.x + (int)Math.round(cosPHI * sx + sinPHI * sy), p2.y + (int)Math.round(-sinPHI * sx + cosPHI * sy));
                path.lineTo(p2.x, p2.y);
            }
        }
    }

    protected void drawSegment(Point p1, Point p2, Color col, boolean showDirection) {
        if (col != this.currentColor) {
            this.displaySegments(col);
        }
        this.drawSegment(this.currentPath, p1, p2, showDirection);
    }

    protected boolean isPolygonVisible(Polygon polygon) {
        Rectangle bounds = polygon.getBounds();
        if (bounds.width == 0 && bounds.height == 0) {
            return false;
        }
        if (bounds.x > this.nc.getWidth()) {
            return false;
        }
        if (bounds.y > this.nc.getHeight()) {
            return false;
        }
        if (bounds.x + bounds.width < 0) {
            return false;
        }
        return bounds.y + bounds.height >= 0;
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color newColor) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            this.g.draw(this.currentPath);
            this.currentPath = new GeneralPath();
            this.currentColor = newColor;
        }
    }
}

