/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.RepeatImageElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.CompositeList;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class StyledMapRenderer
extends AbstractMapRenderer {
    private static final Pair<Integer, ExecutorService> THREAD_POOL = Utils.newThreadPool("mappaint.StyledMapRenderer.style_creation.numberOfThreads");
    private static Map<Font, Boolean> IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG = new HashMap<Font, Boolean>();
    private double circum;
    private MapPaintSettings paintSettings;
    private Color highlightColorTransparent;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);
    private Collection<WaySegment> highlightWaySegments;
    private int highlightLineWidth;
    private int highlightPointRadius;
    private int widerHighlight;
    private int highlightStep;
    private boolean useWiderHighlight;
    private boolean useStrokes;
    private boolean showNames;
    private boolean showIcons;
    private boolean isOutlineOnly;
    private Font orderFont;
    private boolean leftHandTraffic;
    private Object antialiasing;

    public static boolean isGlyphVectorDoubleTranslationBug(Font font) {
        Boolean cached = IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.get(font);
        if (cached != null) {
            return cached;
        }
        String overridePref = Main.pref.get("glyph-bug", "auto");
        if ("auto".equals(overridePref)) {
            FontRenderContext frc = new FontRenderContext(null, false, false);
            GlyphVector gv = font.createGlyphVector(frc, "x");
            gv.setGlyphTransform(0, AffineTransform.getTranslateInstance(1000.0, 1000.0));
            Shape shape = gv.getGlyphOutline(0);
            Main.trace("#10446: shape: " + shape.getBounds());
            int x = shape.getBounds().x;
            boolean isBug = x > 1500;
            IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.put(font, isBug);
            return isBug;
        }
        boolean override = Boolean.parseBoolean(overridePref);
        IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.put(font, override);
        return override;
    }

    public StyledMapRenderer(Graphics2D g, NavigatableComponent nc, boolean isInactiveMode) {
        super(g, nc, isInactiveMode);
        if (nc != null) {
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            this.useWiderHighlight = !(focusOwner instanceof AbstractButton) && focusOwner != nc;
        }
    }

    private Polygon buildPolygon(Point center, int radius, int sides) {
        return this.buildPolygon(center, radius, sides, 0.0);
    }

    private Polygon buildPolygon(Point center, int radius, int sides, double rotation) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < sides; ++i) {
            double angle = Math.PI * 2 / (double)sides * (double)i - rotation;
            int x = (int)Math.round((double)center.x + (double)radius * Math.cos(angle));
            int y = (int)Math.round((double)center.y + (double)radius * Math.sin(angle));
            polygon.addPoint(x, y);
        }
        return polygon;
    }

    private void displaySegments(GeneralPath path, GeneralPath orientationArrows, GeneralPath onewayArrows, GeneralPath onewayArrowsCasing, Color color, BasicStroke line, BasicStroke dashes, Color dashedColor) {
        this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
        if (this.useStrokes) {
            this.g.setStroke(line);
        }
        this.g.draw(path);
        if (!this.isInactiveMode && this.useStrokes && dashes != null) {
            this.g.setColor(dashedColor);
            this.g.setStroke(dashes);
            this.g.draw(path);
        }
        if (orientationArrows != null) {
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
            this.g.setStroke(new BasicStroke(line.getLineWidth(), line.getEndCap(), 0, line.getMiterLimit()));
            this.g.draw(orientationArrows);
        }
        if (onewayArrows != null) {
            this.g.setStroke(new BasicStroke(1.0f, line.getEndCap(), 0, line.getMiterLimit()));
            this.g.fill(onewayArrowsCasing);
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : this.backgroundColor);
            this.g.fill(onewayArrows);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    private void displayText(GlyphVector gv, String s, int x, int y, boolean disabled, TextElement text) {
        if (this.isInactiveMode || disabled) {
            this.g.setColor(this.inactiveColor);
            if (gv != null) {
                this.g.drawGlyphVector(gv, x, y);
            } else {
                this.g.setFont(text.font);
                this.g.drawString(s, x, y);
            }
        } else if (text.haloRadius != null) {
            Shape textOutline;
            this.g.setStroke(new BasicStroke(2.0f * text.haloRadius.floatValue(), 0, 1));
            this.g.setColor(text.haloColor);
            if (gv == null) {
                if (s.isEmpty()) {
                    return;
                }
                FontRenderContext frc = this.g.getFontRenderContext();
                TextLayout tl = new TextLayout(s, text.font, frc);
                textOutline = tl.getOutline(AffineTransform.getTranslateInstance(x, y));
            } else {
                textOutline = gv.getOutline(x, y);
            }
            this.g.draw(textOutline);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(text.color);
            this.g.fill(textOutline);
        } else {
            this.g.setColor(text.color);
            if (gv != null) {
                this.g.drawGlyphVector(gv, x, y);
            } else {
                this.g.setFont(text.font);
                this.g.drawString(s, x, y);
            }
        }
    }

    protected void drawArea(OsmPrimitive osm, Path2D.Double path, Color color, MapImage fillImage, boolean disabled, TextElement text) {
        Shape area = path.createTransformedShape(this.nc.getAffineTransform());
        if (!this.isOutlineOnly) {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (fillImage == null) {
                if (this.isInactiveMode) {
                    this.g.setComposite(AlphaComposite.getInstance(3, 0.33f));
                }
                this.g.setColor(color);
                this.g.fill(area);
            } else {
                TexturePaint texture = new TexturePaint(fillImage.getImage(disabled), new Rectangle(0, 0, fillImage.getWidth(), fillImage.getHeight()));
                this.g.setPaint(texture);
                Float alpha = Float.valueOf(fillImage.getAlphaFloat());
                if (alpha.floatValue() != 1.0f) {
                    this.g.setComposite(AlphaComposite.getInstance(3, alpha.floatValue()));
                }
                this.g.fill(area);
                this.g.setPaintMode();
            }
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        }
        this.drawAreaText(osm, text, area);
    }

    private void drawAreaText(OsmPrimitive osm, TextElement text, Shape area) {
        if (text != null && this.isShowNames()) {
            if (text.labelCompositionStrategy == null) {
                return;
            }
            String name = text.labelCompositionStrategy.compose(osm);
            if (name == null) {
                return;
            }
            Rectangle pb = area.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D nb = fontMetrics.getStringBounds(name, this.g);
            if ((double)pb.width >= nb.getWidth() && (double)pb.height >= nb.getHeight()) {
                int nbh;
                int nbw;
                double h;
                int y2;
                double w = (double)pb.width - nb.getWidth();
                int x2 = pb.x + (int)(w / 2.0);
                Rectangle centeredNBounds = new Rectangle(x2, y2 = pb.y + (int)((h = (double)pb.height - nb.getHeight()) / 2.0), nbw = (int)nb.getWidth(), nbh = (int)nb.getHeight());
                boolean labelOK = area.contains(centeredNBounds);
                if (!labelOK) {
                    int x1 = pb.x + (int)(w / 4.0);
                    int x3 = pb.x + (int)(3.0 * w / 4.0);
                    int y1 = pb.y + (int)(h / 4.0);
                    int y3 = pb.y + (int)(3.0 * h / 4.0);
                    Rectangle[] candidates = new Rectangle[]{new Rectangle(x2, y1, nbw, nbh), new Rectangle(x3, y2, nbw, nbh), new Rectangle(x2, y3, nbw, nbh), new Rectangle(x1, y2, nbw, nbh), new Rectangle(x1, y1, nbw, nbh), new Rectangle(x3, y1, nbw, nbh), new Rectangle(x3, y3, nbw, nbh), new Rectangle(x1, y3, nbw, nbh)};
                    for (int i = 0; i < candidates.length && !labelOK; ++i) {
                        centeredNBounds = candidates[i];
                        labelOK = area.contains(centeredNBounds);
                    }
                }
                if (labelOK) {
                    Font defaultFont = this.g.getFont();
                    int x = (int)(centeredNBounds.getMinX() - nb.getMinX());
                    int y = (int)(centeredNBounds.getMinY() - nb.getMinY());
                    this.displayText(null, name, x, y, osm.isDisabled(), text);
                    this.g.setFont(defaultFont);
                } else if (Main.isDebugEnabled()) {
                    Main.debug("Couldn't find a correct label placement for " + osm + " / " + name);
                }
            }
        }
    }

    public void drawArea(Relation r, Color color, MapImage fillImage, boolean disabled, TextElement text) {
        Multipolygon multipolygon = MultipolygonCache.getInstance().get(this.nc, r);
        if (!r.isDisabled() && !multipolygon.getOuterWays().isEmpty()) {
            for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                Path2D.Double p = pd.get();
                if (!this.isAreaVisible(p)) continue;
                this.drawArea(r, p, pd.selected ? this.paintSettings.getRelationSelectedColor(color.getAlpha()) : color, fillImage, disabled, text);
            }
        }
    }

    public void drawArea(Way w, Color color, MapImage fillImage, boolean disabled, TextElement text) {
        this.drawArea(w, this.getPath(w), color, fillImage, disabled, text);
    }

    public void drawBoxText(Node n, BoxTextElemStyle bs) {
        FontRenderContext frc;
        if (!this.isShowNames() || bs == null) {
            return;
        }
        Point p = this.nc.getPoint(n);
        TextElement text = bs.text;
        String s = text.labelCompositionStrategy.compose(n);
        if (s == null) {
            return;
        }
        Font defaultFont = this.g.getFont();
        this.g.setFont(text.font);
        int x = p.x + text.xOffset;
        int y = p.y + text.yOffset;
        Rectangle box = bs.getBox();
        if (bs.hAlign == BoxTextElemStyle.HorizontalTextAlignment.RIGHT) {
            x += box.x + box.width + 2;
        } else {
            frc = this.g.getFontRenderContext();
            Rectangle2D bounds = text.font.getStringBounds(s, frc);
            int textWidth = (int)bounds.getWidth();
            if (bs.hAlign == BoxTextElemStyle.HorizontalTextAlignment.CENTER) {
                x -= textWidth / 2;
            } else if (bs.hAlign == BoxTextElemStyle.HorizontalTextAlignment.LEFT) {
                x -= -box.x + 4 + textWidth;
            } else {
                throw new AssertionError();
            }
        }
        if (bs.vAlign == BoxTextElemStyle.VerticalTextAlignment.BOTTOM) {
            y += box.y + box.height;
        } else {
            frc = this.g.getFontRenderContext();
            LineMetrics metrics = text.font.getLineMetrics(s, frc);
            if (bs.vAlign == BoxTextElemStyle.VerticalTextAlignment.ABOVE) {
                y = (int)((float)y - ((float)(-box.y) + metrics.getDescent()));
            } else if (bs.vAlign == BoxTextElemStyle.VerticalTextAlignment.TOP) {
                y = (int)((float)y - ((float)(-box.y) - metrics.getAscent()));
            } else if (bs.vAlign == BoxTextElemStyle.VerticalTextAlignment.CENTER) {
                y = (int)((float)y + (metrics.getAscent() - metrics.getDescent()) / 2.0f);
            } else if (bs.vAlign == BoxTextElemStyle.VerticalTextAlignment.BELOW) {
                y = (int)((float)y + ((float)(box.y + box.height) + metrics.getAscent() + 2.0f));
            } else {
                throw new AssertionError();
            }
        }
        this.displayText(null, s, x, y, n.isDisabled(), text);
        this.g.setFont(defaultFont);
    }

    public void drawRepeatImage(Way way, MapImage pattern, boolean disabled, float offset, float spacing, float phase, RepeatImageElemStyle.LineImageAlignment align) {
        int dy2;
        int dy1;
        int imgWidth = pattern.getWidth();
        double repeat = (float)imgWidth + spacing;
        int imgHeight = pattern.getHeight();
        Point lastP = null;
        double currentWayLength = (double)phase % repeat;
        if (currentWayLength < 0.0) {
            currentWayLength += repeat;
        }
        switch (align) {
            case TOP: {
                dy1 = 0;
                dy2 = imgHeight;
                break;
            }
            case CENTER: {
                dy1 = -imgHeight / 2;
                dy2 = imgHeight + dy1;
                break;
            }
            case BOTTOM: {
                dy1 = -imgHeight;
                dy2 = 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OffsetIterator it = new OffsetIterator(way.getNodes(), offset);
        while (it.hasNext()) {
            Point thisP = it.next();
            if (lastP != null) {
                double segmentLength = thisP.distance(lastP);
                double dx = thisP.x - lastP.x;
                double dy = thisP.y - lastP.y;
                double pos = repeat - currentWayLength % repeat;
                AffineTransform saveTransform = this.g.getTransform();
                this.g.translate(lastP.x, lastP.y);
                this.g.rotate(Math.atan2(dy, dx));
                if (pos > (double)spacing) {
                    if (pos > segmentLength + (double)spacing) {
                        this.g.drawImage(pattern.getImage(disabled), 0, dy1, (int)segmentLength, dy2, (int)(repeat - pos), 0, (int)(repeat - pos + segmentLength), imgHeight, null);
                    } else {
                        this.g.drawImage(pattern.getImage(disabled), 0, dy1, (int)(pos - (double)spacing), dy2, (int)(repeat - pos), 0, imgWidth, imgHeight, null);
                    }
                }
                while (pos < segmentLength) {
                    if (pos + (double)imgWidth > segmentLength) {
                        this.g.drawImage(pattern.getImage(disabled), (int)pos, dy1, (int)segmentLength, dy2, 0, 0, (int)segmentLength - (int)pos, imgHeight, null);
                    } else {
                        this.g.drawImage((Image)pattern.getImage(disabled), (int)pos, dy1, this.nc);
                    }
                    pos += repeat;
                }
                this.g.setTransform(saveTransform);
                currentWayLength += segmentLength;
            }
            lastP = thisP;
        }
    }

    @Override
    public void drawNode(Node n, Color color, int size, boolean fill) {
        if (size <= 0 && !n.isHighlighted()) {
            return;
        }
        Point p = this.nc.getPoint(n);
        if (n.isHighlighted()) {
            this.drawPointHighlight(p, size);
        }
        if (size > 1) {
            if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
                return;
            }
            int radius = size / 2;
            if (this.isInactiveMode || n.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            if (fill) {
                this.g.fillRect(p.x - radius - 1, p.y - radius - 1, size + 1, size + 1);
            } else {
                this.g.drawRect(p.x - radius - 1, p.y - radius - 1, size, size);
            }
        }
    }

    public void drawNodeIcon(Node n, MapImage img, boolean disabled, boolean selected, boolean member) {
        float alpha;
        Point p = this.nc.getPoint(n);
        int w = img.getWidth();
        int h = img.getHeight();
        if (n.isHighlighted()) {
            this.drawPointHighlight(p, Math.max(w, h));
        }
        if ((alpha = img.getAlphaFloat()) != 1.0f) {
            this.g.setComposite(AlphaComposite.getInstance(3, alpha));
        }
        this.g.drawImage((Image)img.getImage(disabled), p.x - w / 2 + img.offsetX, p.y - h / 2 + img.offsetY, this.nc);
        this.g.setPaintMode();
        if (selected || member) {
            Color color = disabled ? this.inactiveColor : (selected ? this.selectedColor : this.relationSelectedColor);
            this.g.setColor(color);
            this.g.drawRect(p.x - w / 2 + img.offsetX - 2, p.y - h / 2 + img.offsetY - 2, w + 4, h + 4);
        }
    }

    public void drawNodeSymbol(Node n, NodeElemStyle.Symbol s, Color fillColor, Color strokeColor) {
        Point p = this.nc.getPoint(n);
        int radius = s.size / 2;
        if (n.isHighlighted()) {
            this.drawPointHighlight(p, s.size);
        }
        if (fillColor != null) {
            this.g.setColor(fillColor);
            switch (s.symbol) {
                case SQUARE: {
                    this.g.fillRect(p.x - radius, p.y - radius, s.size, s.size);
                    break;
                }
                case CIRCLE: {
                    this.g.fillOval(p.x - radius, p.y - radius, s.size, s.size);
                    break;
                }
                case TRIANGLE: {
                    this.g.fillPolygon(this.buildPolygon(p, radius, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.fillPolygon(this.buildPolygon(p, radius, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.fillPolygon(this.buildPolygon(p, radius, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.fillPolygon(this.buildPolygon(p, radius, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.fillPolygon(this.buildPolygon(p, radius, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.fillPolygon(this.buildPolygon(p, radius, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.fillPolygon(this.buildPolygon(p, radius, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (s.stroke != null) {
            this.g.setStroke(s.stroke);
            this.g.setColor(strokeColor);
            switch (s.symbol) {
                case SQUARE: {
                    this.g.drawRect(p.x - radius, p.y - radius, s.size - 1, s.size - 1);
                    break;
                }
                case CIRCLE: {
                    this.g.drawOval(p.x - radius, p.y - radius, s.size - 1, s.size - 1);
                    break;
                }
                case TRIANGLE: {
                    this.g.drawPolygon(this.buildPolygon(p, radius, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.drawPolygon(this.buildPolygon(p, radius, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.drawPolygon(this.buildPolygon(p, radius, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.drawPolygon(this.buildPolygon(p, radius, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.drawPolygon(this.buildPolygon(p, radius, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.drawPolygon(this.buildPolygon(p, radius, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.drawPolygon(this.buildPolygon(p, radius, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.g.setStroke(new BasicStroke());
        }
    }

    public void drawOrderNumber(Node n1, Node n2, int orderNumber, Color clr) {
        Point p1 = this.nc.getPoint(n1);
        Point p2 = this.nc.getPoint(n2);
        this.drawOrderNumber(p1, p2, orderNumber, clr);
    }

    private void drawPathHighlight(GeneralPath path, BasicStroke line) {
        if (path == null) {
            return;
        }
        this.g.setColor(this.highlightColorTransparent);
        float w = line.getLineWidth() + (float)this.highlightLineWidth;
        if (this.useWiderHighlight) {
            w += (float)this.widerHighlight;
        }
        while (w >= line.getLineWidth()) {
            this.g.setStroke(new BasicStroke(w, line.getEndCap(), line.getLineJoin(), line.getMiterLimit()));
            this.g.draw(path);
            w -= (float)this.highlightStep;
        }
    }

    private void drawPointHighlight(Point p, int size) {
        this.g.setColor(this.highlightColorTransparent);
        int s = size + this.highlightPointRadius;
        if (this.useWiderHighlight) {
            s += this.widerHighlight;
        }
        while (s >= size) {
            int r = (int)Math.floor(s / 2);
            this.g.fillRoundRect(p.x - r, p.y - r, s, s, r, r);
            s -= this.highlightStep;
        }
    }

    public void drawRestriction(Image img, Point pVia, double vx, double vx2, double vy, double vy2, double angle, boolean selected) {
        Image smallImg = ImageProvider.createRotatedImage(img, angle, new Dimension(16, 16));
        int w = smallImg.getWidth(null);
        int h = smallImg.getHeight(null);
        this.g.drawImage(smallImg, (int)((double)pVia.x + vx + vx2) - w / 2, (int)((double)pVia.y + vy + vy2) - h / 2, this.nc);
        if (selected) {
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : this.relationSelectedColor);
            this.g.drawRect((int)((double)pVia.x + vx + vx2) - w / 2 - 2, (int)((double)pVia.y + vy + vy2) - h / 2 - 2, w + 4, h + 4);
        }
    }

    public void drawRestriction(Relation r, MapImage icon, boolean disabled) {
        Node viaNode;
        Way fromWay = null;
        Way toWay = null;
        OsmPrimitive via = null;
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete()) {
                return;
            }
            if (m.isWay()) {
                Way w = m.getWay();
                if (w.getNodesCount() < 2) continue;
                switch (m.getRole()) {
                    case "from": {
                        if (fromWay != null) break;
                        fromWay = w;
                        break;
                    }
                    case "to": {
                        if (toWay != null) break;
                        toWay = w;
                        break;
                    }
                    case "via": {
                        if (via != null) break;
                        via = w;
                    }
                }
                continue;
            }
            if (!m.isNode()) continue;
            Node n = m.getNode();
            if (!"via".equals(m.getRole()) || via != null) continue;
            via = n;
        }
        if (fromWay == null || toWay == null || via == null) {
            return;
        }
        if (via instanceof Node) {
            viaNode = via;
            if (!fromWay.isFirstLastNode(viaNode)) {
                return;
            }
        } else {
            Way viaWay = (Way)via;
            Node firstNode = viaWay.firstNode();
            Node lastNode = viaWay.lastNode();
            Boolean onewayvia = false;
            String onewayviastr = viaWay.get("oneway");
            if (onewayviastr != null) {
                if ("-1".equals(onewayviastr)) {
                    onewayvia = true;
                    Node tmp = firstNode;
                    firstNode = lastNode;
                    lastNode = tmp;
                } else {
                    onewayvia = OsmUtils.getOsmBoolean(onewayviastr);
                    if (onewayvia == null) {
                        onewayvia = false;
                    }
                }
            }
            if (fromWay.isFirstLastNode(firstNode)) {
                viaNode = firstNode;
            } else if (!onewayvia.booleanValue() && fromWay.isFirstLastNode(lastNode)) {
                viaNode = lastNode;
            } else {
                return;
            }
        }
        Node fromNode = fromWay.firstNode() == via ? fromWay.getNode(1) : fromWay.getNode(fromWay.getNodesCount() - 2);
        Point pFrom = this.nc.getPoint(fromNode);
        Point pVia = this.nc.getPoint(viaNode);
        double distanceFromVia = 14.0;
        double dx = pFrom.x >= pVia.x ? (double)(pFrom.x - pVia.x) : (double)(pVia.x - pFrom.x);
        double dy = pFrom.y >= pVia.y ? (double)(pFrom.y - pVia.y) : (double)(pVia.y - pFrom.y);
        double fromAngle = dx == 0.0 ? 1.5707963267948966 : Math.atan(dy / dx);
        double fromAngleDeg = Math.toDegrees(fromAngle);
        double vx = distanceFromVia * Math.cos(fromAngle);
        double vy = distanceFromVia * Math.sin(fromAngle);
        if (pFrom.x < pVia.x) {
            vx = -vx;
        }
        if (pFrom.y < pVia.y) {
            vy = -vy;
        }
        double distanceFromWay = 10.0;
        double vx2 = 0.0;
        double vy2 = 0.0;
        double iconAngle = 0.0;
        if (pFrom.x >= pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg - 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 90.0));
            }
            iconAngle = 270.0 + fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg));
            } else {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 180.0));
            }
            iconAngle = 90.0 - fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg - 90.0));
            }
            iconAngle = 90.0 + fromAngleDeg;
        }
        if (pFrom.x >= pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 180.0));
            } else {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg));
            }
            iconAngle = 270.0 - fromAngleDeg;
        }
        this.drawRestriction(icon.getImage(disabled), pVia, vx, vx2, vy, vy2, iconAngle, r.isSelected());
    }

    public void drawTextOnPath(Way way, TextElement text) {
        Bidi bd;
        double tStart;
        double offsetSign;
        double angleOffset;
        double t1;
        double t2;
        if (way == null || text == null) {
            return;
        }
        String name = text.getString(way);
        if (name == null || name.isEmpty()) {
            return;
        }
        FontMetrics fontMetrics = this.g.getFontMetrics(text.font);
        Rectangle2D rec = fontMetrics.getStringBounds(name, this.g);
        Rectangle bounds = this.g.getClipBounds();
        Polygon poly = new Polygon();
        Point lastPoint = null;
        Iterator<Node> it = way.getNodes().iterator();
        double pathLength = 0.0;
        ArrayList<Double> longHalfSegmentStart = new ArrayList<Double>();
        ArrayList<Double> longHalfSegmentEnd = new ArrayList<Double>();
        ArrayList<Double> longHalfsegmentQuality = new ArrayList<Double>();
        while (it.hasNext()) {
            Node n = it.next();
            Point p = this.nc.getPoint(n);
            poly.addPoint(p.x, p.y);
            if (lastPoint != null) {
                long dx = p.x - lastPoint.x;
                long dy = p.y - lastPoint.y;
                double segmentLength = Math.sqrt(dx * dx + dy * dy);
                if (segmentLength > 2.0 * (rec.getWidth() + 4.0)) {
                    Point center = new Point((lastPoint.x + p.x) / 2, (lastPoint.y + p.y) / 2);
                    double q = 0.0;
                    if (bounds != null) {
                        if (bounds.contains(lastPoint) && bounds.contains(center)) {
                            q = 2.0;
                        } else if (bounds.contains(lastPoint) || bounds.contains(center)) {
                            q = 1.0;
                        }
                    }
                    longHalfSegmentStart.add(pathLength);
                    longHalfSegmentEnd.add(pathLength + segmentLength / 2.0);
                    longHalfsegmentQuality.add(q);
                    q = 0.0;
                    if (bounds != null) {
                        if (bounds.contains(center) && bounds.contains(p)) {
                            q = 2.0;
                        } else if (bounds.contains(center) || bounds.contains(p)) {
                            q = 1.0;
                        }
                    }
                    longHalfSegmentStart.add(pathLength + segmentLength / 2.0);
                    longHalfSegmentEnd.add(pathLength + segmentLength);
                    longHalfsegmentQuality.add(q);
                }
                pathLength += segmentLength;
            }
            lastPoint = p;
        }
        if (rec.getWidth() > pathLength) {
            return;
        }
        if (!longHalfSegmentStart.isEmpty()) {
            if (way.getNodesCount() == 2) {
                longHalfsegmentQuality.set(0, (Double)longHalfsegmentQuality.get(0) + 0.5);
            }
            double bestStart = Double.NaN;
            double bestEnd = Double.NaN;
            double bestDistanceToCenter = Double.MAX_VALUE;
            double bestQuality = -1.0;
            for (int i = 0; i < longHalfSegmentStart.size(); ++i) {
                double start = (Double)longHalfSegmentStart.get(i);
                double end = (Double)longHalfSegmentEnd.get(i);
                double dist = Math.abs(0.5 * (end + start) - 0.5 * pathLength);
                if (!((Double)longHalfsegmentQuality.get(i) > bestQuality) && (!(dist < bestDistanceToCenter) || (Double)longHalfsegmentQuality.get(i) != bestQuality)) continue;
                bestStart = start;
                bestEnd = end;
                bestDistanceToCenter = dist;
                bestQuality = (Double)longHalfsegmentQuality.get(i);
            }
            double remaining = bestEnd - bestStart - rec.getWidth();
            double smallerSpace = Math.min(Math.max(0.2 * remaining, 7.0), 0.5 * remaining);
            if ((bestEnd + bestStart) / 2.0 < pathLength / 2.0) {
                t2 = bestEnd - smallerSpace;
                t1 = t2 - rec.getWidth();
            } else {
                t1 = bestStart + smallerSpace;
                t2 = t1 + rec.getWidth();
            }
        } else {
            t1 = pathLength / 2.0 - rec.getWidth() / 2.0;
            t2 = pathLength / 2.0 + rec.getWidth() / 2.0;
        }
        double[] p1 = this.pointAt(t1 /= pathLength, poly, pathLength);
        double[] p2 = this.pointAt(t2 /= pathLength, poly, pathLength);
        if (p1 == null || p2 == null) {
            return;
        }
        if (p1[0] < p2[0] && p1[2] < 1.5707963267948966 && p1[2] > -1.5707963267948966) {
            angleOffset = 0.0;
            offsetSign = 1.0;
            tStart = t1;
        } else {
            angleOffset = Math.PI;
            offsetSign = -1.0;
            tStart = t2;
        }
        FontRenderContext frc = this.g.getFontRenderContext();
        char[] chars = name.toCharArray();
        int dirFlag = 0;
        if (Bidi.requiresBidi(chars, 0, chars.length) && (bd = new Bidi(name, -2)).isRightToLeft()) {
            dirFlag = 1;
        }
        GlyphVector gv = text.font.layoutGlyphVector(frc, chars, 0, chars.length, dirFlag);
        for (int i = 0; i < gv.getNumGlyphs(); ++i) {
            Rectangle2D rect = gv.getGlyphLogicalBounds(i).getBounds2D();
            double t = tStart + offsetSign * (rect.getX() + rect.getWidth() / 2.0) / pathLength;
            double[] p = this.pointAt(t, poly, pathLength);
            if (p == null) continue;
            AffineTransform trfm = AffineTransform.getTranslateInstance(p[0] - rect.getX(), p[1]);
            trfm.rotate(p[2] + angleOffset);
            double off = -rect.getY() - rect.getHeight() / 2.0 + (double)text.yOffset;
            trfm.translate(-rect.getWidth() / 2.0, off);
            if (StyledMapRenderer.isGlyphVectorDoubleTranslationBug(text.font)) {
                AffineTransform tmp = AffineTransform.getTranslateInstance(-0.5 * trfm.getTranslateX(), -0.5 * trfm.getTranslateY());
                tmp.concatenate(trfm);
                trfm = tmp;
            }
            gv.setGlyphTransform(i, trfm);
        }
        this.displayText(gv, null, 0, 0, way.isDisabled(), text);
    }

    public void drawWay(Way way, Color color, BasicStroke line, BasicStroke dashes, Color dashedColor, float offset, boolean showOrientation, boolean showHeadArrowOnly, boolean showOneway, boolean onewayReversed) {
        GeneralPath path = new GeneralPath();
        GeneralPath orientationArrows = showOrientation ? new GeneralPath() : null;
        GeneralPath onewayArrows = showOneway ? new GeneralPath() : null;
        GeneralPath onewayArrowsCasing = showOneway ? new GeneralPath() : null;
        Rectangle bounds = this.g.getClipBounds();
        if (bounds != null) {
            bounds.grow(100, 100);
        }
        double wayLength = 0.0;
        Point lastPoint = null;
        boolean initialMoveToNeeded = true;
        List<Node> wayNodes = way.getNodes();
        if (wayNodes.size() < 2) {
            return;
        }
        if (!way.isHighlighted() && this.highlightWaySegments != null) {
            GeneralPath highlightSegs = null;
            for (WaySegment ws : this.highlightWaySegments) {
                if (ws.way != way || (float)ws.lowerIndex < offset) continue;
                if (highlightSegs == null) {
                    highlightSegs = new GeneralPath();
                }
                Point p1 = this.nc.getPoint(ws.getFirstNode());
                Point p2 = this.nc.getPoint(ws.getSecondNode());
                highlightSegs.moveTo(p1.x, p1.y);
                highlightSegs.lineTo(p2.x, p2.y);
            }
            this.drawPathHighlight(highlightSegs, line);
        }
        OffsetIterator it = new OffsetIterator(wayNodes, offset);
        while (it.hasNext()) {
            Point p2;
            Point p1;
            LineClip clip;
            Point p = (Point)it.next();
            if (lastPoint != null && (clip = new LineClip(p1 = lastPoint, p2 = p, bounds)).execute()) {
                double segmentLength;
                if (!p1.equals(clip.getP1())) {
                    p1 = clip.getP1();
                    path.moveTo(p1.x, p1.y);
                } else if (initialMoveToNeeded) {
                    initialMoveToNeeded = false;
                    path.moveTo(p1.x, p1.y);
                }
                p2 = clip.getP2();
                path.lineTo(p2.x, p2.y);
                if ((showHeadArrowOnly ? !it.hasNext() : showOrientation) && (segmentLength = p1.distance(p2)) != 0.0) {
                    double l = (10.0 + (double)line.getLineWidth()) / segmentLength;
                    double sx = l * (double)(p1.x - p2.x);
                    double sy = l * (double)(p1.y - p2.y);
                    orientationArrows.moveTo((double)p2.x + cosPHI * sx - sinPHI * sy, (double)p2.y + sinPHI * sx + cosPHI * sy);
                    orientationArrows.lineTo(p2.x, p2.y);
                    orientationArrows.lineTo((double)p2.x + cosPHI * sx + sinPHI * sy, (double)p2.y - sinPHI * sx + cosPHI * sy);
                }
                if (showOneway) {
                    segmentLength = p1.distance(p2);
                    if (segmentLength != 0.0) {
                        double nx = (double)(p2.x - p1.x) / segmentLength;
                        double ny = (double)(p2.y - p1.y) / segmentLength;
                        double interval = 60.0;
                        for (double dist = 60.0 - wayLength % 60.0; dist < segmentLength; dist += 60.0) {
                            for (int i = 0; i < 2; ++i) {
                                float onewaySize = i == 0 ? 3.0f : 2.0f;
                                GeneralPath onewayPath = i == 0 ? onewayArrowsCasing : onewayArrows;
                                double fac = (double)((float)(-(onewayReversed ? -1 : 1)) * onewaySize) * (1.0 + sinPHI) / (sinPHI * cosPHI);
                                double sx = nx * fac;
                                double sy = ny * fac;
                                double x = (double)p1.x + nx * (dist + (double)(onewayReversed ? -1 : 1) * ((double)onewaySize / sinPHI));
                                double y = (double)p1.y + ny * (dist + (double)(onewayReversed ? -1 : 1) * ((double)onewaySize / sinPHI));
                                onewayPath.moveTo(x, y);
                                onewayPath.lineTo(x + cosPHI * sx - sinPHI * sy, y + sinPHI * sx + cosPHI * sy);
                                onewayPath.lineTo(x + cosPHI * sx + sinPHI * sy, y - sinPHI * sx + cosPHI * sy);
                                onewayPath.lineTo(x, y);
                            }
                        }
                    }
                    wayLength += segmentLength;
                }
            }
            lastPoint = p;
        }
        if (way.isHighlighted()) {
            this.drawPathHighlight(path, line);
        }
        this.displaySegments(path, orientationArrows, onewayArrows, onewayArrowsCasing, color, line, dashes, dashedColor);
    }

    public double getCircum() {
        return this.circum;
    }

    @Override
    public void getColors() {
        super.getColors();
        this.highlightColorTransparent = new Color(this.highlightColor.getRed(), this.highlightColor.getGreen(), this.highlightColor.getBlue(), 100);
        this.backgroundColor = PaintColors.getBackgroundColor();
    }

    @Override
    public void getSettings(boolean virtual) {
        super.getSettings(virtual);
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.circum = this.nc.getDist100Pixel();
        this.leftHandTraffic = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.useStrokes = (double)this.paintSettings.getUseStrokesDistance() > this.circum;
        this.showNames = (double)this.paintSettings.getShowNamesDistance() > this.circum;
        this.showIcons = (double)this.paintSettings.getShowIconsDistance() > this.circum;
        this.isOutlineOnly = this.paintSettings.isOutlineOnly();
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Droid Sans"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        this.antialiasing = Main.pref.getBoolean("mappaint.use-antialiasing", true) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        this.highlightLineWidth = Main.pref.getInteger("mappaint.highlight.width", 4);
        this.highlightPointRadius = Main.pref.getInteger("mappaint.highlight.radius", 7);
        this.widerHighlight = Main.pref.getInteger("mappaint.highlight.bigger-increment", 5);
        this.highlightStep = Main.pref.getInteger("mappaint.highlight.step", 4);
    }

    private Path2D.Double getPath(Way w) {
        Path2D.Double path = new Path2D.Double();
        boolean initial = true;
        for (Node n : w.getNodes()) {
            EastNorth p = n.getEastNorth();
            if (p == null) continue;
            if (initial) {
                path.moveTo(p.getX(), p.getY());
                initial = false;
                continue;
            }
            path.lineTo(p.getX(), p.getY());
        }
        return path;
    }

    private boolean isAreaVisible(Path2D.Double area) {
        Rectangle2D bounds = area.getBounds2D();
        if (bounds.isEmpty()) {
            return false;
        }
        Point2D p = this.nc.getPoint2D(new EastNorth(bounds.getX(), bounds.getY()));
        if (p.getX() > (double)this.nc.getWidth()) {
            return false;
        }
        if (p.getY() < 0.0) {
            return false;
        }
        p = this.nc.getPoint2D(new EastNorth(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight()));
        if (p.getX() < 0.0) {
            return false;
        }
        return !(p.getY() > (double)this.nc.getHeight());
    }

    public boolean isInactiveMode() {
        return this.isInactiveMode;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    private double[] pointAt(double t, Polygon poly, double pathLength) {
        double totalLen = t * pathLength;
        double curLen = 0.0;
        for (int i = 1; i < poly.npoints; ++i) {
            long dx = poly.xpoints[i] - poly.xpoints[i - 1];
            long dy = poly.ypoints[i] - poly.ypoints[i - 1];
            double segLen = Math.sqrt(dx * dx + dy * dy);
            if (totalLen > curLen + segLen) {
                curLen += segLen;
                continue;
            }
            return new double[]{(double)poly.xpoints[i - 1] + (totalLen - curLen) / segLen * (double)dx, (double)poly.ypoints[i - 1] + (totalLen - curLen) / segLen * (double)dy, Math.atan2(dy, dx)};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DataSet data, boolean renderVirtualNodes, Bounds bounds) {
        BBox bbox = bounds.toBBox();
        this.getSettings(renderVirtualNodes);
        data.getReadLock().lock();
        try {
            this.highlightWaySegments = data.getHighlightedWaySegments();
            long timeStart = 0L;
            long timePhase1 = 0L;
            if (Main.isTraceEnabled()) {
                timeStart = System.currentTimeMillis();
                System.err.print("BENCHMARK: rendering ");
            }
            List<Node> nodes = data.searchNodes(bbox);
            List<Way> ways = data.searchWays(bbox);
            List<Relation> relations = data.searchRelations(bbox);
            ArrayList<StyleRecord> allStyleElems = new ArrayList<StyleRecord>(nodes.size() + ways.size() + relations.size());
            ConcurrentTasksHelper helper = new ConcurrentTasksHelper(allStyleElems, data);
            helper.process(relations);
            helper.process(new CompositeList<Way>(nodes, ways));
            if (Main.isTraceEnabled()) {
                timePhase1 = System.currentTimeMillis();
                System.err.print("phase 1 (calculate styles): " + (timePhase1 - timeStart) + " ms");
            }
            Collections.sort(allStyleElems);
            for (StyleRecord r : allStyleElems) {
                r.style.paintPrimitive(r.osm, this.paintSettings, this, (r.flags & 4) != 0, (r.flags & 8) != 0, (r.flags & 2) != 0);
            }
            if (Main.isTraceEnabled()) {
                long timeFinished = System.currentTimeMillis();
                System.err.println("; phase 2 (draw): " + (timeFinished - timePhase1) + " ms; total: " + (timeFinished - timeStart) + " ms" + " (scale: " + this.circum + " zoom level: " + Selector.GeneralSelector.scale2level(this.circum) + ")");
            }
            this.drawVirtualNodes(data, bbox);
        }
        finally {
            data.getReadLock().unlock();
        }
    }

    private class ConcurrentTasksHelper {
        private final List<StyleRecord> allStyleElems;
        private final DataSet data;

        public ConcurrentTasksHelper(List<StyleRecord> allStyleElems, DataSet data) {
            this.allStyleElems = allStyleElems;
            this.data = data;
        }

        void process(List<? extends OsmPrimitive> prims) {
            ArrayList<ComputeStyleListWorker> tasks = new ArrayList<ComputeStyleListWorker>();
            int bucketsize = Math.max(100, prims.size() / (Integer)THREAD_POOL.a / 3);
            int noBuckets = (prims.size() + bucketsize - 1) / bucketsize;
            boolean singleThread = (Integer)THREAD_POOL.a == 1 || noBuckets == 1;
            for (int i = 0; i < noBuckets; ++i) {
                int from = i * bucketsize;
                int to = Math.min((i + 1) * bucketsize, prims.size());
                ArrayList<StyleRecord> target = singleThread ? this.allStyleElems : new ArrayList<StyleRecord>(to - from);
                tasks.add(new ComputeStyleListWorker(prims, from, to, target));
            }
            if (singleThread) {
                try {
                    for (ComputeStyleListWorker task : tasks) {
                        task.call();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (!tasks.isEmpty()) {
                try {
                    for (Future future : ((ExecutorService)THREAD_POOL.b).invokeAll(tasks)) {
                        this.allStyleElems.addAll((Collection)future.get());
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private class ComputeStyleListWorker
    implements Callable<List<StyleRecord>>,
    Visitor {
        private final List<? extends OsmPrimitive> input;
        private final int from;
        private final int to;
        private final List<StyleRecord> output;
        private final ElemStyles styles = MapPaintStyles.getStyles();
        private final boolean drawArea = StyledMapRenderer.access$000(StyledMapRenderer.this) <= (double)Main.pref.getInteger("mappaint.fillareas", 10000000);
        private final boolean drawMultipolygon = this.drawArea && Main.pref.getBoolean("mappaint.multipolygon", true);
        private final boolean drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);

        public ComputeStyleListWorker(List<? extends OsmPrimitive> input, int from, int to, List<StyleRecord> output) {
            this.input = input;
            this.from = from;
            this.to = to;
            this.output = output;
            this.styles.setDrawMultipolygon(this.drawMultipolygon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StyleRecord> call() throws Exception {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                for (int i = this.from; i < this.to; ++i) {
                    OsmPrimitive osm = this.input.get(i);
                    if (!osm.isDrawable()) continue;
                    osm.accept(this);
                }
                List<StyleRecord> list = this.output;
                return list;
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
        }

        @Override
        public void visit(Node n) {
            if (n.isDisabled()) {
                this.add(n, 1);
            } else if (n.isSelected()) {
                this.add(n, 4);
            } else if (n.isMemberOfSelected()) {
                this.add(n, 2);
            } else {
                this.add(n, 0);
            }
        }

        @Override
        public void visit(Way w) {
            if (w.isDisabled()) {
                this.add(w, 1);
            } else if (w.isSelected()) {
                this.add(w, 4);
            } else if (w.isOuterMemberOfSelected()) {
                this.add(w, 8);
            } else if (w.isMemberOfSelected()) {
                this.add(w, 2);
            } else {
                this.add(w, 0);
            }
        }

        @Override
        public void visit(Relation r) {
            if (r.isDisabled()) {
                this.add(r, 1);
            } else if (r.isSelected()) {
                this.add(r, 4);
            } else if (r.isOuterMemberOfSelected()) {
                this.add(r, 8);
            } else if (r.isMemberOfSelected()) {
                this.add(r, 2);
            } else {
                this.add(r, 0);
            }
        }

        @Override
        public void visit(Changeset cs) {
            throw new UnsupportedOperationException();
        }

        public void add(Node osm, int flags) {
            StyleCache.StyleList sl = this.styles.get(osm, StyledMapRenderer.this.circum, StyledMapRenderer.this.nc);
            for (ElemStyle s : sl) {
                this.output.add(new StyleRecord(s, osm, flags));
            }
        }

        public void add(Relation osm, int flags) {
            StyleCache.StyleList sl = this.styles.get(osm, StyledMapRenderer.this.circum, StyledMapRenderer.this.nc);
            for (ElemStyle s : sl) {
                if (this.drawMultipolygon && this.drawArea && s instanceof AreaElemStyle && (flags & 1) == 0) {
                    this.output.add(new StyleRecord(s, osm, flags));
                    continue;
                }
                if (!this.drawRestriction || !(s instanceof NodeElemStyle)) continue;
                this.output.add(new StyleRecord(s, osm, flags));
            }
        }

        public void add(Way osm, int flags) {
            StyleCache.StyleList sl = this.styles.get(osm, StyledMapRenderer.this.circum, StyledMapRenderer.this.nc);
            for (ElemStyle s : sl) {
                if ((!this.drawArea || (flags & 1) != 0) && s instanceof AreaElemStyle) continue;
                this.output.add(new StyleRecord(s, osm, flags));
            }
        }
    }

    private static class StyleRecord
    implements Comparable<StyleRecord> {
        final ElemStyle style;
        final OsmPrimitive osm;
        final int flags;

        public StyleRecord(ElemStyle style, OsmPrimitive osm, int flags) {
            this.style = style;
            this.osm = osm;
            this.flags = flags;
        }

        @Override
        public int compareTo(StyleRecord other) {
            if ((this.flags & 1) != 0 && (other.flags & 1) == 0) {
                return -1;
            }
            if ((this.flags & 1) == 0 && (other.flags & 1) != 0) {
                return 1;
            }
            int d0 = Float.compare(this.style.major_z_index, other.style.major_z_index);
            if (d0 != 0) {
                return d0;
            }
            if (this.flags > other.flags) {
                return 1;
            }
            if (this.flags < other.flags) {
                return -1;
            }
            int dz = Float.compare(this.style.z_index, other.style.z_index);
            if (dz != 0) {
                return dz;
            }
            if (this.style == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && other.style != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return 1;
            }
            if (this.style != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && other.style == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return -1;
            }
            long id = this.osm.getUniqueId() - other.osm.getUniqueId();
            if (id > 0L) {
                return 1;
            }
            if (id < 0L) {
                return -1;
            }
            return Float.compare(this.style.object_z_index, other.style.object_z_index);
        }
    }

    private class OffsetIterator
    implements Iterator<Point> {
        private List<Node> nodes;
        private float offset;
        private int idx;
        private Point prev = null;
        private int x_prev0;
        private int y_prev0;

        public OffsetIterator(List<Node> nodes, float offset) {
            this.nodes = nodes;
            this.offset = offset;
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.nodes.size();
        }

        @Override
        public Point next() {
            if (Math.abs(this.offset) < 0.1f) {
                return StyledMapRenderer.this.nc.getPoint(this.nodes.get(this.idx++));
            }
            Point current = StyledMapRenderer.this.nc.getPoint(this.nodes.get(this.idx));
            if (this.idx == this.nodes.size() - 1) {
                ++this.idx;
                if (this.prev != null) {
                    return new Point(this.x_prev0 + current.x - this.prev.x, this.y_prev0 + current.y - this.prev.y);
                }
                return current;
            }
            Point next = StyledMapRenderer.this.nc.getPoint(this.nodes.get(this.idx + 1));
            int dx_next = next.x - current.x;
            int dy_next = next.y - current.y;
            double len_next = Math.sqrt(dx_next * dx_next + dy_next * dy_next);
            if (len_next == 0.0) {
                len_next = 1.0;
            }
            int x_current0 = current.x + (int)Math.round((double)(this.offset * (float)dy_next) / len_next);
            int y_current0 = current.y - (int)Math.round((double)(this.offset * (float)dx_next) / len_next);
            if (this.idx == 0) {
                ++this.idx;
                this.prev = current;
                this.x_prev0 = x_current0;
                this.y_prev0 = y_current0;
                return new Point(x_current0, y_current0);
            }
            int dy_prev = current.y - this.prev.y;
            int dx_prev = current.x - this.prev.x;
            int det = dx_next * dy_prev - dx_prev * dy_next;
            if (det == 0) {
                ++this.idx;
                this.prev = current;
                this.x_prev0 = x_current0;
                this.y_prev0 = y_current0;
                return new Point(x_current0, y_current0);
            }
            int m = dx_next * (y_current0 - this.y_prev0) - dy_next * (x_current0 - this.x_prev0);
            int cx_ = this.x_prev0 + Math.round((float)m * (float)dx_prev / (float)det);
            int cy_ = this.y_prev0 + Math.round((float)m * (float)dy_prev / (float)det);
            ++this.idx;
            this.prev = current;
            this.x_prev0 = x_current0;
            this.y_prev0 = y_current0;
            return new Point(cx_, cy_);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

