/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.Rendering;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractMapRenderer
implements Rendering {
    protected Graphics2D g;
    protected NavigatableComponent nc;
    protected boolean isInactiveMode;
    protected Color backgroundColor;
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color relationSelectedColor;
    protected Color nodeColor;
    protected Color highlightColor;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;

    public AbstractMapRenderer(Graphics2D g, NavigatableComponent nc, boolean isInactiveMode) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(g);
        CheckParameterUtil.ensureParameterNotNull(nc);
        this.g = g;
        this.nc = nc;
        this.isInactiveMode = isInactiveMode;
    }

    public abstract void drawNode(Node var1, Color var2, int var3, boolean var4);

    protected void drawOrderNumber(Point p1, Point p2, int orderNumber, Color clr) {
        if (this.isSegmentVisible(p1, p2) && AbstractMapRenderer.isLargeSegment(p1, p2, this.segmentNumberSpace)) {
            String on = Integer.toString(orderNumber);
            int strlen = on.length();
            int x = (p1.x + p2.x) / 2 - 4 * strlen;
            int y = (p1.y + p2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && AbstractMapRenderer.isLargeSegment(p1, p2, this.virtualNodeSpace)) {
                y = (p1.y + p2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(x - 1, y - 12, 8 * strlen + 1, 14);
            this.g.setColor(clr);
            this.g.drawString(on, x, y);
        }
    }

    public void drawVirtualNodes(DataSet data, BBox bbox) {
        if (this.virtualNodeSize == 0 || data == null || bbox == null) {
            return;
        }
        GeneralPath path = new GeneralPath();
        for (Way osm : data.searchWays(bbox)) {
            if (!osm.isUsable() || osm.isDisabledAndHidden() || osm.isDisabled()) continue;
            this.visitVirtual(path, osm);
        }
        this.g.setColor(this.nodeColor);
        this.g.draw(path);
        try {
            path = new GeneralPath();
            for (WaySegment wseg : data.getHighlightedVirtualNodes()) {
                if (!wseg.way.isUsable() || wseg.way.isDisabled()) continue;
                this.visitVirtual(path, wseg.toWay());
            }
            this.g.setColor(this.highlightColor);
            this.g.draw(path);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void getColors() {
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
    }

    protected void getSettings(boolean virtual) {
        this.virtualNodeSize = virtual ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.getColors();
    }

    public static boolean isLargeSegment(Point2D p1, Point2D p2, int space) {
        double yd;
        double xd = Math.abs(p1.getX() - p2.getX());
        return xd + (yd = Math.abs(p1.getY() - p2.getY())) > (double)space;
    }

    protected boolean isSegmentVisible(Point p1, Point p2) {
        if (p1.x < 0 && p2.x < 0) {
            return false;
        }
        if (p1.y < 0 && p2.y < 0) {
            return false;
        }
        if (p1.x > this.nc.getWidth() && p2.x > this.nc.getWidth()) {
            return false;
        }
        return p1.y <= this.nc.getHeight() || p2.y <= this.nc.getHeight();
    }

    public void visitVirtual(GeneralPath path, Way w) {
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            Point lastP = this.nc.getPoint(it.next());
            while (it.hasNext()) {
                Point p = this.nc.getPoint(it.next());
                if (this.isSegmentVisible(lastP, p) && AbstractMapRenderer.isLargeSegment(lastP, p, this.virtualNodeSpace)) {
                    int x = (p.x + lastP.x) / 2;
                    int y = (p.y + lastP.y) / 2;
                    path.moveTo(x - this.virtualNodeSize, y);
                    path.lineTo(x + this.virtualNodeSize, y);
                    path.moveTo(x, y - this.virtualNodeSize);
                    path.lineTo(x, y + this.virtualNodeSize);
                }
                lastP = p;
            }
        }
    }
}

