/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class BoundingXYVisitor
extends AbstractVisitor {
    private ProjectionBounds bounds = null;

    @Override
    public void visit(Node n) {
        this.visit(n.getEastNorth());
    }

    @Override
    public void visit(Way w) {
        if (w.isIncomplete()) {
            return;
        }
        for (Node n : w.getNodes()) {
            this.visit(n);
        }
    }

    @Override
    public void visit(Relation e) {
        for (RelationMember m : e.getMembers()) {
            if (m.isRelation()) continue;
            m.getMember().accept(this);
        }
    }

    public void visit(Bounds b) {
        if (b != null) {
            this.visit(b.getMin());
            this.visit(b.getMax());
        }
    }

    public void visit(ProjectionBounds b) {
        if (b != null) {
            this.visit(b.getMin());
            this.visit(b.getMax());
        }
    }

    public void visit(LatLon latlon) {
        if (latlon != null) {
            if (latlon instanceof CachedLatLon) {
                this.visit(((CachedLatLon)latlon).getEastNorth());
            } else {
                this.visit(Main.getProjection().latlon2eastNorth(latlon));
            }
        }
    }

    public void visit(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.bounds == null) {
                this.bounds = new ProjectionBounds(eastNorth);
            } else {
                this.bounds.extend(eastNorth);
            }
        }
    }

    public boolean hasExtend() {
        return this.bounds != null && this.bounds.hasExtend();
    }

    public ProjectionBounds getBounds() {
        return this.bounds;
    }

    public void enlargeBoundingBox() {
        this.enlargeBoundingBox(Main.pref.getDouble("edit.zoom-enlarge-bbox", 0.002));
    }

    public void enlargeBoundingBox(double enlargeDegree) {
        if (this.bounds == null) {
            return;
        }
        LatLon minLatlon = Main.getProjection().eastNorth2latlon(this.bounds.getMin());
        LatLon maxLatlon = Main.getProjection().eastNorth2latlon(this.bounds.getMax());
        this.bounds = new ProjectionBounds(Main.getProjection().latlon2eastNorth(new LatLon(minLatlon.lat() - enlargeDegree, minLatlon.lon() - enlargeDegree)), Main.getProjection().latlon2eastNorth(new LatLon(maxLatlon.lat() + enlargeDegree, maxLatlon.lon() + enlargeDegree)));
    }

    public void enlargeBoundingBoxLogarithmically(double maxEnlargePercent) {
        if (this.bounds == null) {
            return;
        }
        double diffEast = this.bounds.getMax().east() - this.bounds.getMin().east();
        double diffNorth = this.bounds.getMax().north() - this.bounds.getMin().north();
        double enlargeEast = Math.min(maxEnlargePercent - 10.0 * Math.log(diffEast), 1.0) / 100.0;
        double enlargeNorth = Math.min(maxEnlargePercent - 10.0 * Math.log(diffNorth), 1.0) / 100.0;
        this.visit(this.bounds.getMin().add(-enlargeEast / 2.0, -enlargeNorth / 2.0));
        this.visit(this.bounds.getMax().add(enlargeEast / 2.0, enlargeNorth / 2.0));
    }

    public void enlargeToMinSize(double size) {
        if (this.bounds == null) {
            return;
        }
        double en_size = size * Main.map.mapView.getScale() / Main.map.mapView.getDist100Pixel() * 100.0;
        this.visit(this.bounds.getMin().add(-en_size / 2.0, -en_size / 2.0));
        this.visit(this.bounds.getMax().add(en_size / 2.0, en_size / 2.0));
    }

    public String toString() {
        return "BoundingXYVisitor[" + this.bounds + "]";
    }

    public void computeBoundingBox(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive == null) continue;
            osmPrimitive.accept(this);
        }
    }
}

