/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public abstract class HistoryOsmPrimitive
implements Comparable<HistoryOsmPrimitive> {
    private long id;
    private boolean visible;
    private User user;
    private long changesetId;
    private Changeset changeset;
    private Date timestamp;
    private long version;
    private Map<String, String> tags;

    protected final void ensurePositiveLong(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", name, value));
        }
    }

    public HistoryOsmPrimitive(long id, long version, boolean visible, User user, long changesetId, Date timestamp) throws IllegalArgumentException {
        this(id, version, visible, user, changesetId, timestamp, true);
    }

    public HistoryOsmPrimitive(long id, long version, boolean visible, User user, long changesetId, Date timestamp, boolean checkHistoricParams) throws IllegalArgumentException {
        this.ensurePositiveLong(id, "id");
        this.ensurePositiveLong(version, "version");
        CheckParameterUtil.ensureParameterNotNull(user, "user");
        if (checkHistoricParams) {
            this.ensurePositiveLong(changesetId, "changesetId");
            CheckParameterUtil.ensureParameterNotNull(timestamp, "timestamp");
        }
        this.id = id;
        this.version = version;
        this.visible = visible;
        this.user = user;
        this.changesetId = changesetId;
        this.timestamp = timestamp;
        this.tags = new HashMap<String, String>();
    }

    public HistoryOsmPrimitive(OsmPrimitive p) {
        this(p.getId(), p.getVersion(), p.isVisible(), p.getUser(), p.getChangesetId(), p.getTimestamp());
    }

    public static HistoryOsmPrimitive forOsmPrimitive(OsmPrimitive p) {
        if (p instanceof Node) {
            return new HistoryNode((Node)p);
        }
        if (p instanceof Way) {
            return new HistoryWay((Way)p);
        }
        if (p instanceof Relation) {
            return new HistoryRelation((Relation)p);
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.id, this.getType());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public User getUser() {
        return this.user;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean matches(long id, long version) {
        return this.id == id && this.version == version;
    }

    public boolean matches(long id) {
        return this.id == id;
    }

    public abstract OsmPrimitiveType getType();

    @Override
    public int compareTo(HistoryOsmPrimitive o) {
        if (this.id != o.id) {
            throw new ClassCastException(I18n.tr("Cannot compare primitive with ID ''{0}'' to primitive with ID ''{1}''.", o.id, this.id));
        }
        return Long.valueOf(this.version).compareTo(o.version);
    }

    public void put(String key, String value) {
        this.tags.put(key, value);
    }

    public String get(String key) {
        return this.tags.get(key);
    }

    public boolean hasTag(String key) {
        return this.tags.get(key) != null;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public void setChangeset(Changeset changeset) {
        this.changeset = changeset;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? new HashMap<String, String>() : new HashMap<String, String>(tags);
    }

    public String getName() {
        if (this.get("name") != null) {
            return this.get("name");
        }
        return null;
    }

    public abstract String getDisplayName(HistoryNameFormatter var1);

    public String getLocalName() {
        String key = "name:" + Locale.getDefault().toString();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage();
        if (this.get(key) != null) {
            return this.get(key);
        }
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HistoryOsmPrimitive)) {
            return false;
        }
        HistoryOsmPrimitive other = (HistoryOsmPrimitive)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [version=" + this.version + ", id=" + this.id + ", visible=" + this.visible + ", " + (this.timestamp != null ? "timestamp=" + this.timestamp : "") + ", " + (this.user != null ? "user=" + this.user + ", " : "") + "changesetId=" + this.changesetId + "]";
    }
}

