/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.Date;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;

public class HistoryNode
extends HistoryOsmPrimitive {
    private LatLon coords;

    public HistoryNode(long id, long version, boolean visible, User user, long changesetId, Date timestamp, LatLon coords) throws IllegalArgumentException {
        this(id, version, visible, user, changesetId, timestamp, coords, true);
    }

    public HistoryNode(long id, long version, boolean visible, User user, long changesetId, Date timestamp, LatLon coords, boolean checkHistoricParams) throws IllegalArgumentException {
        super(id, version, visible, user, changesetId, timestamp, checkHistoricParams);
        this.setCoords(coords);
    }

    public HistoryNode(Node n) {
        super(n);
        this.setCoords(n.getCoor());
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    public final LatLon getCoords() {
        return this.coords;
    }

    public final void setCoords(LatLon coords) {
        this.coords = coords;
    }

    @Override
    public String getDisplayName(HistoryNameFormatter formatter) {
        return formatter.format(this);
    }
}

