/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;

public class SelectionEventManager
implements SelectionChangedListener {
    private static final SelectionEventManager instance = new SelectionEventManager();
    private Collection<? extends OsmPrimitive> selection;
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> normalListeners = new CopyOnWriteArrayList();
    private final Runnable edtRunnable = new Runnable(){

        @Override
        public void run() {
            if (SelectionEventManager.this.selection != null) {
                SelectionEventManager.this.fireEvents(SelectionEventManager.this.inEDTListeners, SelectionEventManager.this.selection);
            }
        }
    };

    public static SelectionEventManager getInstance() {
        return instance;
    }

    public SelectionEventManager() {
        DataSet.addSelectionListener(this);
    }

    public void addSelectionListener(SelectionChangedListener listener, DatasetEventManager.FireMode fireMode) {
        if (fireMode == DatasetEventManager.FireMode.IN_EDT) {
            throw new UnsupportedOperationException("IN_EDT mode not supported, you probably want to use IN_EDT_CONSOLIDATED.");
        }
        if (fireMode == DatasetEventManager.FireMode.IN_EDT || fireMode == DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED) {
            this.inEDTListeners.addIfAbsent(new ListenerInfo(listener));
        } else {
            this.normalListeners.addIfAbsent(new ListenerInfo(listener));
        }
    }

    public void removeSelectionListener(SelectionChangedListener listener) {
        ListenerInfo searchListener = new ListenerInfo(listener);
        this.inEDTListeners.remove(searchListener);
        this.normalListeners.remove(searchListener);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.fireEvents(this.normalListeners, newSelection);
        this.selection = newSelection;
        SwingUtilities.invokeLater(this.edtRunnable);
    }

    private void fireEvents(List<ListenerInfo> listeners, Collection<? extends OsmPrimitive> newSelection) {
        for (ListenerInfo listener : listeners) {
            listener.listener.selectionChanged(newSelection);
        }
    }

    private static class ListenerInfo {
        final SelectionChangedListener listener;

        public ListenerInfo(SelectionChangedListener listener) {
            this.listener = listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ListenerInfo && ((ListenerInfo)o).listener == this.listener;
        }
    }
}

