/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class DatasetEventManager
implements DataSetListenerAdapter.Listener,
MapView.EditLayerChangeListener {
    private static final DatasetEventManager instance = new DatasetEventManager();
    private final Queue<AbstractDatasetChangedEvent> eventsInEDT = new LinkedBlockingQueue<AbstractDatasetChangedEvent>();
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> normalListeners = new CopyOnWriteArrayList();
    private final DataSetListener myListener = new DataSetListenerAdapter(this);
    private final Runnable edtRunnable = new Runnable(){

        @Override
        public void run() {
            while (!DatasetEventManager.this.eventsInEDT.isEmpty()) {
                ArrayList events = new ArrayList();
                events.addAll(DatasetEventManager.this.eventsInEDT);
                DataSet dataSet = null;
                AbstractDatasetChangedEvent consolidatedEvent = null;
                AbstractDatasetChangedEvent event = null;
                while ((event = (AbstractDatasetChangedEvent)DatasetEventManager.this.eventsInEDT.poll()) != null) {
                    DatasetEventManager.this.fireEvents(DatasetEventManager.this.inEDTListeners, event);
                    if (consolidatedEvent != null && dataSet != event.getDataset()) {
                        DatasetEventManager.this.fireConsolidatedEvents(DatasetEventManager.this.inEDTListeners, consolidatedEvent);
                        consolidatedEvent = null;
                    }
                    dataSet = event.getDataset();
                    if (event instanceof DataChangedEvent) {
                        DataChangedEvent dataEvent = (DataChangedEvent)event;
                        if (dataEvent.getEvents() == null) {
                            consolidatedEvent = dataEvent;
                            continue;
                        }
                        if (consolidatedEvent == null) {
                            consolidatedEvent = new DataChangedEvent(dataSet, dataEvent.getEvents());
                            continue;
                        }
                        if (consolidatedEvent instanceof DataChangedEvent) {
                            List<AbstractDatasetChangedEvent> evts = ((DataChangedEvent)consolidatedEvent).getEvents();
                            if (evts == null) continue;
                            evts.addAll(dataEvent.getEvents());
                            continue;
                        }
                        AbstractDatasetChangedEvent oldConsolidateEvent = consolidatedEvent;
                        consolidatedEvent = new DataChangedEvent(dataSet, dataEvent.getEvents());
                        ((DataChangedEvent)consolidatedEvent).getEvents().add(oldConsolidateEvent);
                        continue;
                    }
                    if (consolidatedEvent == null) {
                        consolidatedEvent = event;
                        continue;
                    }
                    if (consolidatedEvent instanceof DataChangedEvent) {
                        List<AbstractDatasetChangedEvent> evs = ((DataChangedEvent)consolidatedEvent).getEvents();
                        if (evs == null) continue;
                        evs.add(event);
                        continue;
                    }
                    consolidatedEvent = new DataChangedEvent(dataSet, new ArrayList<AbstractDatasetChangedEvent>(Arrays.asList(consolidatedEvent)));
                }
                DatasetEventManager.this.fireConsolidatedEvents(DatasetEventManager.this.inEDTListeners, consolidatedEvent);
            }
        }
    };

    public static DatasetEventManager getInstance() {
        return instance;
    }

    public DatasetEventManager() {
        MapView.addEditLayerChangeListener(this);
    }

    public void addDatasetListener(DataSetListener listener, FireMode fireMode) {
        if (fireMode == FireMode.IN_EDT || fireMode == FireMode.IN_EDT_CONSOLIDATED) {
            this.inEDTListeners.addIfAbsent(new ListenerInfo(listener, fireMode == FireMode.IN_EDT_CONSOLIDATED));
        } else {
            this.normalListeners.addIfAbsent(new ListenerInfo(listener, false));
        }
    }

    public void removeDatasetListener(DataSetListener listener) {
        ListenerInfo searchListener = new ListenerInfo(listener, false);
        this.inEDTListeners.remove(searchListener);
        this.normalListeners.remove(searchListener);
    }

    @Override
    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (oldLayer != null) {
            oldLayer.data.removeDataSetListener(this.myListener);
        }
        if (newLayer != null) {
            newLayer.data.addDataSetListener(this.myListener);
            this.processDatasetEvent(new DataChangedEvent(newLayer.data));
        } else {
            this.processDatasetEvent(new DataChangedEvent(null));
        }
    }

    private void fireEvents(List<ListenerInfo> listeners, AbstractDatasetChangedEvent event) {
        for (ListenerInfo listener : listeners) {
            if (listener.consolidate) continue;
            event.fire(listener.listener);
        }
    }

    private void fireConsolidatedEvents(List<ListenerInfo> listeners, AbstractDatasetChangedEvent event) {
        for (ListenerInfo listener : listeners) {
            if (!listener.consolidate) continue;
            event.fire(listener.listener);
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.fireEvents(this.normalListeners, event);
        this.eventsInEDT.add(event);
        SwingUtilities.invokeLater(this.edtRunnable);
    }

    private static class ListenerInfo {
        final DataSetListener listener;
        final boolean consolidate;

        public ListenerInfo(DataSetListener listener, boolean consolidate) {
            this.listener = listener;
            this.consolidate = consolidate;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ListenerInfo && ((ListenerInfo)o).listener == this.listener;
        }
    }

    public static enum FireMode {
        IMMEDIATELY,
        IN_EDT,
        IN_EDT_CONSOLIDATED;

    }
}

