/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Line2D;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

public final class WaySegment
implements Comparable<WaySegment> {
    public Way way;
    public int lowerIndex;

    public WaySegment(Way w, int i) {
        this.way = w;
        this.lowerIndex = i;
    }

    public Node getFirstNode() {
        return this.way.getNode(this.lowerIndex);
    }

    public Node getSecondNode() {
        return this.way.getNode(this.lowerIndex + 1);
    }

    public Way toWay() {
        Way w = new Way();
        w.addNode(this.getFirstNode());
        w.addNode(this.getSecondNode());
        return w;
    }

    public boolean equals(Object o) {
        return o instanceof WaySegment && ((WaySegment)o).way == this.way && ((WaySegment)o).lowerIndex == this.lowerIndex;
    }

    public int hashCode() {
        return this.way.hashCode() ^ this.lowerIndex;
    }

    @Override
    public int compareTo(WaySegment o) {
        return this.equals(o) ? 0 : this.toWay().compareTo(o.toWay());
    }

    public boolean intersects(WaySegment s2) {
        if (this.getFirstNode().equals(s2.getFirstNode()) || this.getSecondNode().equals(s2.getSecondNode()) || this.getFirstNode().equals(s2.getSecondNode()) || this.getSecondNode().equals(s2.getFirstNode())) {
            return false;
        }
        return Line2D.linesIntersect(this.getFirstNode().getEastNorth().east(), this.getFirstNode().getEastNorth().north(), this.getSecondNode().getEastNorth().east(), this.getSecondNode().getEastNorth().north(), s2.getFirstNode().getEastNorth().east(), s2.getFirstNode().getEastNorth().north(), s2.getSecondNode().getEastNorth().east(), s2.getSecondNode().getEastNorth().north());
    }

    public String toString() {
        return "WaySegment [way=" + this.way.getUniqueId() + ", lowerIndex=" + this.lowerIndex + "]";
    }
}

