/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class User {
    private static long uidCounter = 0L;
    private static Map<Long, User> userMap = new HashMap<Long, User>();
    private static final User anonymous = User.createLocalUser(I18n.tr("<anonymous>", new Object[0]));
    private final Set<String> names = new HashSet<String>();
    private final long uid;

    private static long getNextLocalUid() {
        return --uidCounter;
    }

    public static synchronized User createLocalUser(String name) {
        for (long i = -1L; i >= uidCounter; --i) {
            User olduser = User.getById(i);
            if (olduser == null || !olduser.hasName(name)) continue;
            return olduser;
        }
        User user = new User(User.getNextLocalUid(), name);
        userMap.put(user.getId(), user);
        return user;
    }

    public static synchronized User createOsmUser(long uid, String name) {
        User user = userMap.get(uid);
        if (user == null) {
            user = new User(uid, name);
            userMap.put(user.getId(), user);
        }
        if (name != null) {
            user.addName(name);
        }
        return user;
    }

    public static synchronized void clearUserMap() {
        userMap.clear();
    }

    public static synchronized User getById(long uid) {
        return userMap.get(uid);
    }

    public static synchronized List<User> getByName(String name) {
        if (name == null) {
            name = "";
        }
        ArrayList<User> ret = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.hasName(name)) continue;
            ret.add(user);
        }
        return ret;
    }

    public static User getAnonymous() {
        return anonymous;
    }

    public String getName() {
        return Utils.join("/", this.names);
    }

    public List<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public void addName(String name) {
        this.names.add(name);
    }

    public boolean hasName(String name) {
        return this.names.contains(name);
    }

    public long getId() {
        return this.uid;
    }

    private User(long uid, String name) {
        this.uid = uid;
        if (name != null) {
            this.addName(name);
        }
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return this.uid == other.uid;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("id:").append(this.uid);
        if (this.names.size() == 1) {
            s.append(" name:").append(this.getName());
        } else if (this.names.size() > 1) {
            s.append(String.format(" %d names:%s", this.names.size(), this.getName()));
        }
        return s.toString();
    }
}

