/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Set;
import java.util.TreeSet;

public final class TigerUtils {
    public static boolean isTigerTag(String tag) {
        return tag.indexOf("tiger:") != -1;
    }

    public static boolean tagIsInt(String name) {
        return "tiger:tlid".equals(name);
    }

    public static Object tagObj(String name) {
        if (TigerUtils.tagIsInt(name)) {
            return Integer.valueOf(name);
        }
        return name;
    }

    public static String combineTags(String name, Set<String> values) {
        TreeSet<Object> resultSet = new TreeSet<Object>();
        for (String value : values) {
            String[] stringArray;
            for (String part : stringArray = value.split(":")) {
                resultSet.add(TigerUtils.tagObj(part));
            }
            if (values.size() != 1 || resultSet.size() != stringArray.length) continue;
            return value;
        }
        StringBuilder combined = new StringBuilder();
        for (Object e : resultSet) {
            if (combined.length() > 0) {
                combined.append(":");
            }
            combined.append(e);
        }
        return combined.toString();
    }

    public static String combineTags(String name, String t1, String t2) {
        TreeSet<String> set = new TreeSet<String>();
        set.add(t1);
        set.add(t2);
        return TigerUtils.combineTags(name, set);
    }
}

