/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class Tag {
    private String key;
    private String value;

    public Tag() {
        this("", "");
    }

    public Tag(String key) {
        this(key, "");
    }

    public Tag(String key, String value) {
        this.key = key == null ? "" : key;
        this.value = value == null ? "" : value;
    }

    public Tag(Tag tag) {
        this(tag.getKey(), tag.getValue());
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean matchesKey(String key) {
        return this.key.equals(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tag) {
            Tag other = (Tag)obj;
            return this.key.equals(other.getKey()) && this.value.equals(other.getValue());
        }
        return false;
    }

    public static Tag ofString(String s) {
        CheckParameterUtil.ensureParameterNotNull(s, "s");
        String[] x = s.split("=", 2);
        if (x.length == 2) {
            return new Tag(x[0], x[1]);
        }
        throw new IllegalArgumentException("'" + s + "' does not contain '='");
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public static String removeWhiteSpaces(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Utils.strip(s).replaceAll("\\s+", " ");
    }
}

