/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.Utils;

public class Storage<T>
extends AbstractSet<T> {
    private final Hash<? super T, ? super T> hash;
    private T[] data;
    private int mask;
    private int size;
    private volatile transient int modCount = 0;
    private float loadFactor = 0.6f;
    private final boolean safeIterator;
    private boolean arrayCopyNecessary;

    public Storage() {
        this(Storage.defaultHash(), 16, false);
    }

    public Storage(int capacity) {
        this(Storage.defaultHash(), capacity, false);
    }

    public Storage(Hash<? super T, ? super T> ha) {
        this(ha, 16, false);
    }

    public Storage(boolean safeIterator) {
        this(Storage.defaultHash(), 16, safeIterator);
    }

    public Storage(int capacity, boolean safeIterator) {
        this(Storage.defaultHash(), capacity, safeIterator);
    }

    public Storage(Hash<? super T, ? super T> ha, boolean safeIterator) {
        this(ha, 16, safeIterator);
    }

    public Storage(Hash<? super T, ? super T> ha, int capacity) {
        this(ha, capacity, false);
    }

    public Storage(Hash<? super T, ? super T> ha, int capacity, boolean safeIterator) {
        this.hash = ha;
        int cap = 1 << (int)Math.ceil(Math.log((float)capacity / this.loadFactor) / Math.log(2.0));
        Object[] newData = new Object[cap];
        this.data = newData;
        this.mask = this.data.length - 1;
        this.safeIterator = safeIterator;
    }

    private void copyArray() {
        if (this.arrayCopyNecessary) {
            this.data = Utils.copyArray(this.data);
            this.arrayCopyNecessary = false;
        }
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        if (this.safeIterator) {
            this.arrayCopyNecessary = true;
            return new SafeReadonlyIter(this.data);
        }
        return new Iter();
    }

    @Override
    public synchronized boolean contains(Object o) {
        Object t = o;
        int bucket = this.getBucket(this.hash, t);
        return bucket >= 0;
    }

    @Override
    public synchronized boolean add(T t) {
        T orig = this.putUnique(t);
        return orig == t;
    }

    @Override
    public synchronized boolean remove(Object o) {
        Object t = o;
        Object tOrig = this.removeElem(t);
        return tOrig != null;
    }

    @Override
    public synchronized void clear() {
        this.copyArray();
        ++this.modCount;
        this.size = 0;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
    }

    @Override
    public synchronized int hashCode() {
        int h = 0;
        for (T t : this) {
            h += this.hash.getHashCode(t);
        }
        return h;
    }

    public synchronized T put(T t) {
        this.copyArray();
        ++this.modCount;
        this.ensureSpace();
        int bucket = this.getBucket(this.hash, t);
        if (bucket < 0) {
            ++this.size;
            assert (this.data[bucket ^= 0xFFFFFFFF] == null);
        }
        T old = this.data[bucket];
        this.data[bucket] = t;
        return old;
    }

    public synchronized T get(T t) {
        int bucket = this.getBucket(this.hash, t);
        return bucket < 0 ? null : (T)this.data[bucket];
    }

    public synchronized T putUnique(T t) {
        this.copyArray();
        ++this.modCount;
        this.ensureSpace();
        int bucket = this.getBucket(this.hash, t);
        if (bucket < 0) {
            ++this.size;
            assert (this.data[~bucket] == null);
            this.data[bucket ^ 0xFFFFFFFF] = t;
            return t;
        }
        return this.data[bucket];
    }

    public synchronized T removeElem(T t) {
        this.copyArray();
        ++this.modCount;
        int bucket = this.getBucket(this.hash, t);
        return bucket < 0 ? null : (T)this.doRemove(bucket);
    }

    public <K> Map<K, T> foreignKey(Hash<K, ? super T> h) {
        return new FMap(h);
    }

    private int rehash(int h) {
        return 1103515245 * h >> 2;
    }

    private <K> int getBucket(Hash<K, ? super T> ha, K key) {
        T entry;
        int hcode = this.rehash(ha.getHashCode(key));
        int bucket = hcode & this.mask;
        while ((entry = this.data[bucket]) != null) {
            if (ha.equals(key, entry)) {
                return bucket;
            }
            bucket = bucket + 1 & this.mask;
        }
        return ~bucket;
    }

    private T doRemove(int slot) {
        T t = this.data[slot];
        assert (t != null);
        this.fillTheHole(slot);
        --this.size;
        return t;
    }

    private void fillTheHole(int hole) {
        T entry;
        int bucket = hole + 1 & this.mask;
        while ((entry = this.data[bucket]) != null) {
            int right = this.rehash(this.hash.getHashCode(entry)) & this.mask;
            if (bucket < right && (right <= hole || hole <= bucket) || right <= hole && hole <= bucket) {
                this.data[hole] = this.data[bucket];
                hole = bucket;
            }
            bucket = bucket + 1 & this.mask;
        }
        this.data[hole] = null;
    }

    private void ensureSpace() {
        if ((float)this.size > (float)this.data.length * this.loadFactor) {
            Object[] big = new Object[this.data.length * 2];
            int nMask = big.length - 1;
            for (T o : this.data) {
                if (o == null) continue;
                int bucket = this.rehash(this.hash.getHashCode(o)) & nMask;
                while (big[bucket] != null) {
                    bucket = bucket + 1 & nMask;
                }
                big[bucket] = o;
            }
            this.data = big;
            this.mask = nMask;
        }
    }

    public static <O> Hash<O, O> defaultHash() {
        return new Hash<O, O>(){

            @Override
            public int getHashCode(O t) {
                return t.hashCode();
            }

            @Override
            public boolean equals(O t1, O t2) {
                return t1.equals(t2);
            }
        };
    }

    private final class Iter
    implements Iterator<T> {
        private final int mods;
        int slot = 0;
        int removeSlot = -1;

        Iter() {
            this.mods = Storage.this.modCount;
        }

        @Override
        public boolean hasNext() {
            this.align();
            return this.slot < Storage.this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeSlot = this.slot;
            return Storage.this.data[this.slot++];
        }

        @Override
        public void remove() {
            if (this.removeSlot == -1) {
                throw new IllegalStateException();
            }
            Storage.this.doRemove(this.removeSlot);
            this.slot = this.removeSlot;
            this.removeSlot = -1;
        }

        private void align() {
            if (this.mods != Storage.this.modCount) {
                throw new ConcurrentModificationException();
            }
            while (this.slot < Storage.this.data.length && Storage.this.data[this.slot] == null) {
                ++this.slot;
            }
        }
    }

    private final class SafeReadonlyIter
    implements Iterator<T> {
        final T[] data;
        int slot = 0;

        SafeReadonlyIter(T[] data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            this.align();
            return this.slot < this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.data[this.slot++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void align() {
            while (this.slot < this.data.length && this.data[this.slot] == null) {
                ++this.slot;
            }
        }
    }

    private final class FMap<K>
    implements Map<K, T> {
        Hash<K, ? super T> fHash;

        private FMap(Hash<K, ? super T> h) {
            this.fHash = h;
        }

        @Override
        public int size() {
            return Storage.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Storage.this.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            Object key = o;
            int bucket = Storage.this.getBucket(this.fHash, key);
            return bucket >= 0;
        }

        @Override
        public boolean containsValue(Object value) {
            return Storage.this.contains(value);
        }

        @Override
        public T get(Object o) {
            Object key = o;
            int bucket = Storage.this.getBucket(this.fHash, key);
            return bucket < 0 ? null : Storage.this.data[bucket];
        }

        @Override
        public T put(K key, T value) {
            if (!this.fHash.equals(key, value)) {
                throw new IllegalArgumentException("inconsistent key");
            }
            return Storage.this.put(value);
        }

        @Override
        public T remove(Object o) {
            Storage.this.modCount++;
            Object key = o;
            int bucket = Storage.this.getBucket(this.fHash, key);
            return bucket < 0 ? null : Storage.this.doRemove(bucket);
        }

        @Override
        public void putAll(Map<? extends K, ? extends T> m) {
            if (m instanceof FMap) {
                Storage.this.addAll(m.values());
            } else {
                for (Map.Entry e : m.entrySet()) {
                    this.put(e.getKey(), (T)e.getValue());
                }
            }
        }

        @Override
        public void clear() {
            Storage.this.clear();
        }

        @Override
        public Set<K> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<T> values() {
            return Storage.this;
        }

        @Override
        public Set<Map.Entry<K, T>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PrimitiveIdHash
    implements Hash<PrimitiveId, PrimitiveId> {
        @Override
        public int getHashCode(PrimitiveId k) {
            return (int)k.getUniqueId() ^ k.getType().hashCode();
        }

        @Override
        public boolean equals(PrimitiveId key, PrimitiveId value) {
            if (key == null || value == null) {
                return false;
            }
            return key.getUniqueId() == value.getUniqueId() && key.getType() == value.getType();
        }
    }
}

