/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class SimplePrimitiveId
implements Serializable,
PrimitiveId {
    private final long id;
    private final OsmPrimitiveType type;
    public static final Pattern ID_PATTERN = Pattern.compile("((n(ode)?|w(ay)?|r(el(ation)?)?)/?)(\\d+)");

    public SimplePrimitiveId(long id, OsmPrimitiveType type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.type;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimplePrimitiveId other = (SimplePrimitiveId)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.id;
    }

    public static SimplePrimitiveId fromString(String s) {
        Matcher m = ID_PATTERN.matcher(s);
        if (m.matches()) {
            return new SimplePrimitiveId(Long.parseLong(m.group(m.groupCount())), s.charAt(0) == 'n' ? OsmPrimitiveType.NODE : (s.charAt(0) == 'w' ? OsmPrimitiveType.WAY : OsmPrimitiveType.RELATION));
        }
        throw new IllegalArgumentException("The string " + s + " does not match the pattern " + ID_PATTERN);
    }

    public static List<SimplePrimitiveId> fuzzyParse(String s) {
        ArrayList<SimplePrimitiveId> ids = new ArrayList<SimplePrimitiveId>();
        Matcher m = ID_PATTERN.matcher(s);
        while (m.find()) {
            char firstChar = s.charAt(m.start());
            ids.add(new SimplePrimitiveId(Long.parseLong(m.group(m.groupCount())), firstChar == 'n' ? OsmPrimitiveType.NODE : (firstChar == 'w' ? OsmPrimitiveType.WAY : OsmPrimitiveType.RELATION)));
        }
        return ids;
    }
}

