/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class RelationMemberData
implements PrimitiveId {
    private final String role;
    private final long memberId;
    private final OsmPrimitiveType memberType;

    public RelationMemberData(String role, OsmPrimitiveType type, long id) {
        this.role = role == null ? "" : role;
        this.memberType = type;
        this.memberId = id;
    }

    public RelationMemberData(String role, PrimitiveId primitive) {
        this(role, primitive.getType(), primitive.getUniqueId());
    }

    public long getMemberId() {
        return this.memberId;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitiveType getMemberType() {
        return this.memberType;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public String toString() {
        return (this.memberType != null ? this.memberType.getAPIName() : "undefined") + " " + this.memberId;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.memberType;
    }

    @Override
    public long getUniqueId() {
        return this.memberId;
    }

    @Override
    public boolean isNew() {
        return this.memberId <= 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.memberId ^ this.memberId >>> 32);
        result = 31 * result + (this.memberType == null ? 0 : this.memberType.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationMemberData other = (RelationMemberData)obj;
        if (this.memberId != other.memberId) {
            return false;
        }
        if (this.memberType != other.memberType) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }
}

