/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Arrays;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMember
implements PrimitiveId {
    private final String role;
    private final OsmPrimitive member;

    public String getRole() {
        return this.role;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public boolean hasRole(String ... roles) {
        return Arrays.asList(roles).contains(this.role);
    }

    public boolean isRelation() {
        return this.member instanceof Relation;
    }

    public boolean isWay() {
        return this.member instanceof Way;
    }

    public OsmPrimitiveType getDisplayType() {
        return this.member.getDisplayType();
    }

    public boolean isNode() {
        return this.member instanceof Node;
    }

    public Relation getRelation() {
        return (Relation)this.member;
    }

    public Way getWay() {
        return (Way)this.member;
    }

    public Node getNode() {
        return (Node)this.member;
    }

    public OsmPrimitive getMember() {
        return this.member;
    }

    public RelationMember(String role, OsmPrimitive member) {
        CheckParameterUtil.ensureParameterNotNull(member, "member");
        if (role == null) {
            role = "";
        }
        this.role = role;
        this.member = member;
    }

    public RelationMember(RelationMember other) {
        this(other.role, other.member);
    }

    public String toString() {
        return '\"' + this.role + "\"=" + this.member;
    }

    public boolean refersTo(OsmPrimitive primitive) {
        return this.member == primitive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.member.hashCode();
        result = 31 * result + this.role.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationMember) {
            RelationMember other = (RelationMember)obj;
            return this.member.equals(other.getMember()) && this.role.equals(other.getRole());
        }
        return false;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.member.getType();
    }

    @Override
    public long getUniqueId() {
        return this.member.getUniqueId();
    }

    @Override
    public boolean isNew() {
        return this.member.isNew();
    }
}

