/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;

public class RelationData
extends PrimitiveData
implements IRelation {
    private List<RelationMemberData> members = new ArrayList<RelationMemberData>();

    public RelationData() {
    }

    public RelationData(RelationData data) {
        super(data);
        this.members.addAll(data.members);
    }

    public List<RelationMemberData> getMembers() {
        return this.members;
    }

    public void setMembers(List<RelationMemberData> memberData) {
        this.members = new ArrayList<RelationMemberData>(memberData);
    }

    @Override
    public int getMembersCount() {
        return this.members.size();
    }

    @Override
    public long getMemberId(int idx) {
        return this.members.get(idx).getMemberId();
    }

    @Override
    public String getRole(int idx) {
        return this.members.get(idx).getRole();
    }

    @Override
    public OsmPrimitiveType getMemberType(int idx) {
        return this.members.get(idx).getMemberType();
    }

    @Override
    public RelationData makeCopy() {
        return new RelationData(this);
    }

    @Override
    public String toString() {
        return super.toString() + " REL " + this.members;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }
}

