/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class QuadBuckets<T extends OsmPrimitive>
implements Collection<T> {
    public static final int MAX_OBJECTS_PER_LEVEL = 16;
    private QBLevel<T> root;
    private QBLevel<T> search_cache;
    private int size;

    static void abort(String s) {
        throw new AssertionError((Object)s);
    }

    public QuadBuckets() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.root = new QBLevel(this);
        this.search_cache = null;
        this.size = 0;
    }

    @Override
    public boolean add(T n) {
        this.root.add(n);
        ++this.size;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        for (OsmPrimitive o : this) {
            if (objects.contains(o) || this.remove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object o : objects) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends T> objects) {
        boolean changed = false;
        for (OsmPrimitive o : objects) {
            changed |= this.add((T)o);
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        OsmPrimitive t = (OsmPrimitive)o;
        this.search_cache = null;
        QBLevel<OsmPrimitive> bucket = this.root.findBucket(t.getBBox());
        if (bucket.remove_content(t)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        OsmPrimitive t = (OsmPrimitive)o;
        QBLevel<T> bucket = this.root.findBucket(t.getBBox());
        return bucket != null && ((QBLevel)bucket).content != null && ((QBLevel)bucket).content.contains(t);
    }

    public ArrayList<T> toArrayList() {
        ArrayList<OsmPrimitive> a = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive n : this) {
            a.add(n);
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <A> A[] toArray(A[] template) {
        return this.toArrayList().toArray(template);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<T> search(BBox search_bbox) {
        ArrayList ret = new ArrayList();
        boolean cache_searches = true;
        if (cache_searches) {
            if (this.search_cache == null) {
                this.search_cache = this.root;
            }
            while (this.search_cache != null && !this.search_cache.bbox().bounds(search_bbox)) {
                this.search_cache = ((QBLevel)this.search_cache).parent;
            }
            if (this.search_cache == null) {
                this.search_cache = this.root;
                Main.info("bbox: " + search_bbox + " is out of the world");
            }
        } else {
            this.search_cache = this.root;
        }
        QBLevel tmp = ((QBLevel)this.search_cache).parent;
        ((QBLevel)this.search_cache).search(search_bbox, ret);
        while (tmp != null) {
            tmp.search_contents(search_bbox, ret);
            tmp = tmp.parent;
        }
        return ret;
    }

    class QuadBucketIterator
    implements Iterator<T> {
        QBLevel<T> current_node;
        int content_index;
        int iterated_over;

        final QBLevel<T> next_content_node(QBLevel<T> q) {
            if (q == null) {
                return null;
            }
            QBLevel orig = q;
            QBLevel next = q.nextContentNode();
            if (orig == next) {
                QuadBuckets.abort("got same leaf back leaf: " + q.isLeaf());
            }
            return next;
        }

        public QuadBucketIterator(QuadBuckets<T> qb) {
            this.current_node = !qb.root.hasChildren() || qb.root.hasContent() ? qb.root : this.next_content_node(qb.root);
            this.iterated_over = 0;
        }

        @Override
        public boolean hasNext() {
            return this.peek() != null;
        }

        T peek() {
            if (this.current_node == null) {
                return null;
            }
            while (this.current_node.content == null || this.content_index >= this.current_node.content.size()) {
                this.content_index = 0;
                this.current_node = this.next_content_node(this.current_node);
                if (this.current_node != null) continue;
            }
            if (this.current_node == null || this.current_node.content == null) {
                return null;
            }
            return (OsmPrimitive)this.current_node.content.get(this.content_index);
        }

        @Override
        public T next() {
            Object ret = this.peek();
            ++this.content_index;
            ++this.iterated_over;
            return ret;
        }

        @Override
        public void remove() {
            --this.content_index;
            Object object = this.peek();
            this.current_node.remove_content(object);
        }
    }

    static class QBLevel<T extends OsmPrimitive> {
        private final int level;
        private final int index;
        private final BBox bbox;
        private final long quad;
        private final QBLevel<T> parent;
        private boolean isLeaf = true;
        private List<T> content;
        private QBLevel<T> nw;
        private QBLevel<T> ne;
        private QBLevel<T> sw;
        private QBLevel<T> se;
        private final QuadBuckets<T> buckets;

        private QBLevel<T> getChild(int index) {
            switch (index) {
                case 3: {
                    if (this.ne == null) {
                        this.ne = new QBLevel<T>(this, index, this.buckets);
                    }
                    return this.ne;
                }
                case 1: {
                    if (this.nw == null) {
                        this.nw = new QBLevel<T>(this, index, this.buckets);
                    }
                    return this.nw;
                }
                case 2: {
                    if (this.se == null) {
                        this.se = new QBLevel<T>(this, index, this.buckets);
                    }
                    return this.se;
                }
                case 0: {
                    if (this.sw == null) {
                        this.sw = new QBLevel<T>(this, index, this.buckets);
                    }
                    return this.sw;
                }
            }
            return null;
        }

        private QBLevel<T>[] getChildren() {
            return new QBLevel[]{this.sw, this.nw, this.se, this.ne};
        }

        public String toString() {
            return super.toString() + "[" + this.level + "]: " + this.bbox();
        }

        public QBLevel(QuadBuckets<T> buckets) {
            this.level = 0;
            this.index = 0;
            this.quad = 0L;
            this.parent = null;
            this.bbox = new BBox(-180.0, 90.0, 180.0, -90.0);
            this.buckets = buckets;
        }

        public QBLevel(QBLevel<T> parent, int parent_index, QuadBuckets<T> buckets) {
            this.parent = parent;
            this.level = parent.level + 1;
            this.index = parent_index;
            this.buckets = buckets;
            int shift = (24 - this.level) * 2;
            long mult = 1L;
            if (shift >= 30) {
                shift -= 30;
                mult = 0x40000000L;
            }
            long this_quadpart = mult * (long)(parent_index << shift);
            this.quad = parent.quad | this_quadpart;
            this.bbox = this.calculateBBox();
        }

        private BBox calculateBBox() {
            LatLon bottom_left = this.coor();
            double lat = bottom_left.lat() + this.parent.height() / 2.0;
            double lon = bottom_left.lon() + this.parent.width() / 2.0;
            return new BBox(bottom_left.lon(), bottom_left.lat(), lon, lat);
        }

        QBLevel<T> findBucket(BBox bbox) {
            if (!this.hasChildren()) {
                return this;
            }
            int idx = bbox.getIndex(this.level);
            if (idx == -1) {
                return this;
            }
            return this.getChild(idx).findBucket(bbox);
        }

        boolean remove_content(T o) {
            if (this.content == null) {
                return false;
            }
            boolean ret = this.content.remove(o);
            if (this.content.isEmpty()) {
                this.content = null;
            }
            if (this.canRemove()) {
                this.remove_from_parent();
            }
            return ret;
        }

        void __split() {
            List<T> tmpcontent = this.content;
            this.content = null;
            for (OsmPrimitive o : tmpcontent) {
                int idx = o.getBBox().getIndex(this.level);
                if (idx == -1) {
                    this.__add_content(o);
                    continue;
                }
                this.getChild(idx).doAdd(o);
            }
            this.isLeaf = false;
        }

        boolean __add_content(T o) {
            boolean ret = false;
            if (this.content == null) {
                this.content = new ArrayList<T>();
            }
            ret = this.content.add(o);
            return ret;
        }

        boolean matches(T o, BBox search_bbox) {
            if (o instanceof Node) {
                LatLon latLon = ((Node)o).getCoor();
                return search_bbox.bounds(latLon != null ? latLon : LatLon.ZERO);
            }
            return ((OsmPrimitive)o).getBBox().intersects(search_bbox);
        }

        private void search_contents(BBox search_bbox, List<T> result) {
            if (this.content == null) {
                return;
            }
            for (OsmPrimitive o : this.content) {
                if (!this.matches(o, search_bbox)) continue;
                result.add(o);
            }
        }

        boolean isLeaf() {
            return this.isLeaf;
        }

        boolean hasChildren() {
            return this.nw != null || this.ne != null || this.sw != null || this.se != null;
        }

        QBLevel<T> next_sibling() {
            return this.parent == null ? null : this.parent.firstSiblingOf(this);
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel<T> nextSibling() {
            QBLevel<T> next = this;
            QBLevel<T> sibling = next.next_sibling();
            while (sibling == null && (next = next.parent) != null) {
                sibling = next.next_sibling();
            }
            next = sibling;
            return next;
        }

        QBLevel<T> firstChild() {
            if (this.sw != null) {
                return this.sw;
            }
            if (this.nw != null) {
                return this.nw;
            }
            if (this.se != null) {
                return this.se;
            }
            return this.ne;
        }

        QBLevel<T> firstSiblingOf(QBLevel<T> child) {
            switch (child.index) {
                case 0: {
                    if (this.nw != null) {
                        return this.nw;
                    }
                }
                case 1: {
                    if (this.se != null) {
                        return this.se;
                    }
                }
                case 2: {
                    return this.ne;
                }
            }
            return null;
        }

        QBLevel<T> nextNode() {
            if (!this.hasChildren()) {
                return this.nextSibling();
            }
            return this.firstChild();
        }

        QBLevel<T> nextContentNode() {
            QBLevel<T> next = this.nextNode();
            if (next == null) {
                return next;
            }
            if (next.hasContent()) {
                return next;
            }
            return next.nextContentNode();
        }

        void doAdd(T o) {
            this.__add_content(o);
            if (this.isLeaf() && this.content.size() > 16 && this.level < 24) {
                this.__split();
            }
        }

        void add(T o) {
            this.findBucket(((OsmPrimitive)o).getBBox()).doAdd(o);
        }

        private void search(BBox search_bbox, List<T> result) {
            if (!this.bbox().intersects(search_bbox)) {
                return;
            }
            if (this.bbox().bounds(search_bbox)) {
                ((QuadBuckets)this.buckets).search_cache = this;
            }
            if (this.hasContent()) {
                this.search_contents(search_bbox, result);
            }
            if (this.nw != null) {
                super.search(search_bbox, result);
            }
            if (this.ne != null) {
                super.search(search_bbox, result);
            }
            if (this.se != null) {
                super.search(search_bbox, result);
            }
            if (this.sw != null) {
                super.search(search_bbox, result);
            }
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        double width() {
            return this.bbox.width();
        }

        double height() {
            return this.bbox.height();
        }

        public BBox bbox() {
            return this.bbox;
        }

        final LatLon coor() {
            return QuadTiling.tile2LatLon(this.quad);
        }

        void remove_from_parent() {
            if (this.parent == null) {
                return;
            }
            if (!this.canRemove()) {
                QuadBuckets.abort("attempt to remove non-empty child: " + this.content + " " + Arrays.toString(this.getChildren()));
            }
            if (this.parent.nw == this) {
                this.parent.nw = null;
            } else if (this.parent.ne == this) {
                this.parent.ne = null;
            } else if (this.parent.sw == this) {
                this.parent.sw = null;
            } else if (this.parent.se == this) {
                this.parent.se = null;
            }
            if (this.parent.canRemove()) {
                this.parent.remove_from_parent();
            }
        }

        boolean canRemove() {
            if (this.content != null && !this.content.isEmpty()) {
                return false;
            }
            return !this.hasChildren();
        }
    }
}

