/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;

public abstract class PrimitiveData
extends AbstractPrimitive {
    public PrimitiveData() {
        this.id = OsmPrimitive.generateUniqueId();
    }

    public PrimitiveData(PrimitiveData data) {
        this.cloneFrom(data);
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void setIncomplete(boolean incomplete) {
        super.setIncomplete(incomplete);
    }

    public abstract PrimitiveData makeCopy();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(Arrays.toString(this.keys)).append(this.getFlagsAsString());
        return builder.toString();
    }

    public static <T extends PrimitiveData> List<T> getFilteredList(Collection<T> list, OsmPrimitiveType type) {
        ArrayList<PrimitiveData> ret = new ArrayList<PrimitiveData>();
        for (PrimitiveData p : list) {
            if (!type.getDataClass().isInstance(p)) continue;
            ret.add(p);
        }
        return ret;
    }

    @Override
    protected final void keysChangedImpl(Map<String, String> originalKeys) {
    }

    @Override
    public abstract OsmPrimitiveType getType();
}

