/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.TextTagParser;

public final class OsmUtils {
    static final List<String> TRUE_VALUES = new ArrayList<String>(Arrays.asList("true", "yes", "1", "on"));
    static final List<String> FALSE_VALUES = new ArrayList<String>(Arrays.asList("false", "no", "0", "off"));
    static final List<String> REVERSE_VALUES = new ArrayList<String>(Arrays.asList("reverse", "-1"));
    public static final String trueval = "yes";
    public static final String falseval = "no";
    public static final String reverseval = "-1";

    public static Boolean getOsmBoolean(String value) {
        if (value == null) {
            return null;
        }
        String lowerValue = value.toLowerCase(Locale.ENGLISH);
        if (TRUE_VALUES.contains(lowerValue)) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(lowerValue)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String getNamedOsmBoolean(String value) {
        Boolean res = OsmUtils.getOsmBoolean(value);
        return res == null ? value : (res != false ? trueval : falseval);
    }

    public static boolean isReversed(String value) {
        return REVERSE_VALUES.contains(value);
    }

    public static boolean isTrue(String value) {
        return TRUE_VALUES.contains(value);
    }

    public static boolean isFalse(String value) {
        return FALSE_VALUES.contains(value);
    }

    public static OsmPrimitive createPrimitive(String assertion) {
        Node p;
        CheckParameterUtil.ensureParameterNotNull(assertion, "assertion");
        String[] x = assertion.split("\\s+", 2);
        OsmPrimitive osmPrimitive = "n".equals(x[0]) || "node".equals(x[0]) ? new Node(LatLon.ZERO) : ("w".equals(x[0]) || "way".equals(x[0]) ? new Way() : (p = "r".equals(x[0]) || "relation".equals(x[0]) ? new Relation() : null));
        if (p == null) {
            throw new IllegalArgumentException("Expecting n/node/w/way/r/relation, but got " + x[0]);
        }
        for (Map.Entry<String, String> i : TextTagParser.readTagsFromText(x[1]).entrySet()) {
            p.put(i.getKey(), i.getValue());
        }
        return p;
    }
}

