/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;

public class OsmPrimitiveComparator
implements Comparator<OsmPrimitive> {
    private final Map<OsmPrimitive, String> cache = new HashMap<OsmPrimitive, String>();
    private final boolean relationsFirst;
    private final boolean quick;

    public OsmPrimitiveComparator() {
        this(false, false);
    }

    public OsmPrimitiveComparator(boolean quick, boolean relationsFirst) {
        this.quick = quick;
        this.relationsFirst = relationsFirst;
    }

    private String cachedName(OsmPrimitive p) {
        String name = this.cache.get(p);
        if (name == null) {
            name = p.getDisplayName(DefaultNameFormatter.getInstance());
            this.cache.put(p, name);
        }
        return name;
    }

    private int compareName(OsmPrimitive a, OsmPrimitive b) {
        String an = this.cachedName(a);
        String bn = this.cachedName(b);
        if (Character.isDigit(an.charAt(0)) && Character.isDigit(bn.charAt(0))) {
            return an.compareTo(bn);
        }
        if (Character.isDigit(an.charAt(0)) && !Character.isDigit(bn.charAt(0))) {
            return 1;
        }
        if (!Character.isDigit(an.charAt(0)) && Character.isDigit(bn.charAt(0))) {
            return -1;
        }
        return an.compareTo(bn);
    }

    private static int compareId(OsmPrimitive a, OsmPrimitive b) {
        long idB;
        long idA = a.getUniqueId();
        if (idA < (idB = b.getUniqueId())) {
            return -1;
        }
        if (idA > idB) {
            return 1;
        }
        return 0;
    }

    private int compareType(OsmPrimitive a, OsmPrimitive b) {
        if (this.relationsFirst) {
            if (a.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                return -1;
            }
            if (a.getType().equals((Object)OsmPrimitiveType.NODE)) {
                return 1;
            }
            if (b.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                return 1;
            }
        } else {
            if (a.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return -1;
            }
            if (a.getType().equals((Object)OsmPrimitiveType.NODE)) {
                return 1;
            }
            if (b.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public int compare(OsmPrimitive a, OsmPrimitive b) {
        if (a.getType().equals((Object)b.getType())) {
            return this.quick ? OsmPrimitiveComparator.compareId(a, b) : this.compareName(a, b);
        }
        return this.compareType(a, b);
    }
}

