/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public abstract class OsmPrimitive
extends AbstractPrimitive
implements Comparable<OsmPrimitive>,
TemplateEngineDataProvider {
    protected static final int FLAG_DISABLED = 16;
    protected static final int FLAG_HIDE_IF_DISABLED = 32;
    protected static final int FLAG_DISABLED_TYPE = 64;
    protected static final int FLAG_HIDDEN_TYPE = 128;
    protected static final int FLAG_HAS_DIRECTIONS = 256;
    protected static final int FLAG_TAGGED = 512;
    protected static final int FLAG_DIRECTION_REVERSED = 1024;
    protected static final int FLAG_HIGHLIGHTED = 2048;
    protected static final int FLAG_ANNOTATED = 4096;
    public static final Predicate<OsmPrimitive> isUsablePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.isUsable();
        }
    };
    public static final Predicate<OsmPrimitive> isSelectablePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.isSelectable();
        }
    };
    public static final Predicate<OsmPrimitive> nonDeletedPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return !primitive.isDeleted();
        }
    };
    public static final Predicate<OsmPrimitive> nonDeletedCompletePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return !primitive.isDeleted() && !primitive.isIncomplete();
        }
    };
    public static final Predicate<OsmPrimitive> nonDeletedPhysicalPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return !primitive.isDeleted() && !primitive.isIncomplete() && !(primitive instanceof Relation);
        }
    };
    public static final Predicate<OsmPrimitive> modifiedPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.isModified();
        }
    };
    public static final Predicate<OsmPrimitive> nodePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.getClass() == Node.class;
        }
    };
    public static final Predicate<OsmPrimitive> wayPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.getClass() == Way.class;
        }
    };
    public static final Predicate<OsmPrimitive> relationPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.getClass() == Relation.class;
        }
    };
    public static final Predicate<OsmPrimitive> multipolygonPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.getClass() == Relation.class && ((Relation)primitive).isMultipolygon();
        }
    };
    public static final Predicate<OsmPrimitive> allPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return true;
        }
    };
    public StyleCache mappaintStyle = null;
    public int mappaintCacheIdx;
    private DataSet dataSet;
    private static volatile Collection<String> workinprogress = null;
    private static volatile Collection<String> uninteresting = null;
    private static volatile Collection<String> discardable = null;
    private static volatile SearchCompiler.Match directionKeys = null;
    private static volatile SearchCompiler.Match reversedDirectionKeys = null;
    private Object referrers;

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> list, Class<T> type) {
        if (list == null) {
            return Collections.emptyList();
        }
        LinkedList<T> ret = new LinkedList<T>();
        for (OsmPrimitive p : list) {
            if (!type.isInstance(p)) continue;
            ret.add(type.cast(p));
        }
        return ret;
    }

    public static <T extends OsmPrimitive> Set<T> getFilteredSet(Collection<OsmPrimitive> set, Class<T> type) {
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        if (set != null) {
            for (OsmPrimitive p : set) {
                if (!type.isInstance(p)) continue;
                ret.add(type.cast(p));
            }
        }
        return ret;
    }

    public static Set<OsmPrimitive> getReferrer(Collection<? extends OsmPrimitive> primitives) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        if (primitives == null || primitives.isEmpty()) {
            return ret;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            ret.addAll(osmPrimitive.getReferrers());
        }
        return ret;
    }

    protected OsmPrimitive(long id, boolean allowNegativeId) throws IllegalArgumentException {
        if (allowNegativeId) {
            this.id = id;
        } else {
            if (id < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Expected ID >= 0. Got {0}.", id));
            }
            this.id = id == 0L ? OsmPrimitive.generateUniqueId() : id;
        }
        this.version = 0;
        this.setIncomplete(id > 0L);
    }

    protected OsmPrimitive(long id, int version, boolean allowNegativeId) throws IllegalArgumentException {
        this(id, allowNegativeId);
        this.version = id > 0L ? version : 0;
        this.setIncomplete(id > 0L && version == 0);
    }

    public void clearCachedStyle() {
        this.mappaintStyle = null;
    }

    void setDataset(DataSet dataSet) {
        if (this.dataSet != null && dataSet != null && this.dataSet != dataSet) {
            throw new DataIntegrityProblemException("Primitive cannot be included in more than one Dataset");
        }
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void checkDataset() {
        if (this.dataSet == null) {
            throw new DataIntegrityProblemException("Primitive must be part of the dataset: " + this.toString());
        }
    }

    protected boolean writeLock() {
        if (this.dataSet != null) {
            this.dataSet.beginUpdate();
            return true;
        }
        return false;
    }

    protected void writeUnlock(boolean locked) {
        if (locked) {
            this.dataSet.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOsmId(long id, int version) {
        boolean locked = this.writeLock();
        try {
            if (id <= 0L) {
                throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", id));
            }
            if (version <= 0) {
                throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", version));
            }
            if (this.dataSet != null && id != this.id) {
                DataSet datasetCopy = this.dataSet;
                datasetCopy.removePrimitive(this);
                this.id = id;
                datasetCopy.addPrimitive(this);
            }
            super.setOsmId(id, version);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void clearOsmMetadata() {
        if (this.dataSet != null) {
            throw new DataIntegrityProblemException("Method cannot be called after primitive was added to the dataset");
        }
        super.clearOsmMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUser(User user) {
        boolean locked = this.writeLock();
        try {
            super.setUser(user);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChangesetId(int changesetId) throws IllegalStateException, IllegalArgumentException {
        boolean locked = this.writeLock();
        try {
            int old = this.changesetId;
            super.setChangesetId(changesetId);
            if (this.dataSet != null) {
                this.dataSet.fireChangesetIdChanged(this, old, changesetId);
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(Date timestamp) {
        boolean locked = this.writeLock();
        try {
            super.setTimestamp(timestamp);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    private void updateFlagsNoLock(int flag, boolean value) {
        super.updateFlags(flag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateFlags(int flag, boolean value) {
        boolean locked = this.writeLock();
        try {
            this.updateFlagsNoLock(flag, value);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDisabledState(boolean hidden) {
        boolean locked = this.writeLock();
        try {
            short oldFlags = this.flags;
            this.updateFlagsNoLock(16, true);
            this.updateFlagsNoLock(32, hidden);
            boolean bl = oldFlags != this.flags;
            return bl;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsetDisabledState() {
        boolean locked = this.writeLock();
        try {
            short oldFlags = this.flags;
            this.updateFlagsNoLock(48, false);
            boolean bl = oldFlags != this.flags;
            return bl;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public void setDisabledType(boolean isExplicit) {
        this.updateFlags(64, isExplicit);
    }

    public void setHiddenType(boolean isExplicit) {
        this.updateFlags(128, isExplicit);
    }

    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isDisabledAndHidden() {
        return (this.flags & 0x10) != 0 && (this.flags & 0x20) != 0;
    }

    public boolean getHiddenType() {
        return (this.flags & 0x80) != 0;
    }

    public boolean getDisabledType() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isSelectable() {
        return (this.flags & 0x3C) == 0;
    }

    public boolean isDrawable() {
        return (this.flags & 0x2C) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) throws IllegalStateException {
        boolean locked = this.writeLock();
        try {
            super.setVisible(visible);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean deleted) {
        boolean locked = this.writeLock();
        try {
            super.setDeleted(deleted);
            if (this.dataSet != null) {
                if (deleted) {
                    this.dataSet.firePrimitivesRemoved(Collections.singleton(this), false);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singleton(this), false);
                }
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void setIncomplete(boolean incomplete) {
        boolean locked = this.writeLock();
        try {
            if (this.dataSet != null && incomplete != this.isIncomplete()) {
                if (incomplete) {
                    this.dataSet.firePrimitivesRemoved(Collections.singletonList(this), true);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singletonList(this), true);
                }
            }
            super.setIncomplete(incomplete);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public boolean isSelected() {
        return this.dataSet != null && this.dataSet.isSelected(this);
    }

    public boolean isMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.referrers instanceof Relation && ((OsmPrimitive)this.referrers).isSelected();
        }
        for (OsmPrimitive ref : (OsmPrimitive[])this.referrers) {
            if (!(ref instanceof Relation) || !ref.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isOuterMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.isOuterMemberOfMultipolygon((OsmPrimitive)this.referrers);
        }
        for (OsmPrimitive ref : (OsmPrimitive[])this.referrers) {
            if (!this.isOuterMemberOfMultipolygon(ref)) continue;
            return true;
        }
        return false;
    }

    private boolean isOuterMemberOfMultipolygon(OsmPrimitive ref) {
        if (ref instanceof Relation && ref.isSelected() && ((Relation)ref).isMultipolygon()) {
            for (RelationMember rm : ((Relation)ref).getMembersFor(Collections.singleton(this))) {
                if (!"outer".equals(rm.getRole())) continue;
                return true;
            }
        }
        return false;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.isHighlighted() != highlighted) {
            this.updateFlags(2048, highlighted);
            if (this.dataSet != null) {
                this.dataSet.fireHighlightingChanged(this);
            }
        }
    }

    public boolean isHighlighted() {
        return (this.flags & 0x800) != 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            LinkedList<String> l = new LinkedList<String>(Arrays.asList("source", "source_ref", "source:", "comment", "converted_by", "watch", "watch:", "description", "attribution"));
            l.addAll(OsmPrimitive.getDiscardableKeys());
            l.addAll(OsmPrimitive.getWorkInProgressKeys());
            uninteresting = Main.pref.getCollection("tags.uninteresting", l);
        }
        return uninteresting;
    }

    public static Collection<String> getDiscardableKeys() {
        if (discardable == null) {
            discardable = Main.pref.getCollection("tags.discardable", Arrays.asList("created_by", "geobase:datasetName", "geobase:uuid", "KSJ2:ADS", "KSJ2:ARE", "KSJ2:AdminArea", "KSJ2:COP_label", "KSJ2:DFD", "KSJ2:INT", "KSJ2:INT_label", "KSJ2:LOC", "KSJ2:LPN", "KSJ2:OPC", "KSJ2:PubFacAdmin", "KSJ2:RAC", "KSJ2:RAC_label", "KSJ2:RIC", "KSJ2:RIN", "KSJ2:WSC", "KSJ2:coordinate", "KSJ2:curve_id", "KSJ2:curve_type", "KSJ2:filename", "KSJ2:lake_id", "KSJ2:lat", "KSJ2:long", "KSJ2:river_id", "odbl", "odbl:note", "SK53_bulk:load", "sub_sea:type", "tiger:source", "tiger:separated", "tiger:tlid", "tiger:upload_uuid", "yh:LINE_NAME", "yh:LINE_NUM", "yh:STRUCTURE", "yh:TOTYUMONO", "yh:TYPE", "yh:WIDTH_RANK"));
        }
        return discardable;
    }

    public static Collection<String> getWorkInProgressKeys() {
        if (workinprogress == null) {
            workinprogress = Main.pref.getCollection("tags.workinprogress", Arrays.asList("note", "fixme", "FIXME"));
        }
        return workinprogress;
    }

    public static boolean isUninterestingKey(String key) {
        OsmPrimitive.getUninterestingKeys();
        if (uninteresting.contains(key)) {
            return true;
        }
        int pos = key.indexOf(58);
        if (pos > 0) {
            return uninteresting.contains(key.substring(0, pos + 1));
        }
        return false;
    }

    public Map<String, String> getInterestingTags() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] keys = this.keys;
        if (keys != null) {
            for (int i = 0; i < keys.length; i += 2) {
                if (OsmPrimitive.isUninterestingKey(keys[i])) continue;
                result.put(keys[i], keys[i + 1]);
            }
        }
        return result;
    }

    private void updateTagged() {
        if (this.keys != null) {
            for (String key : this.keySet()) {
                if (OsmPrimitive.isUninterestingKey(key) || "area".equals(key)) continue;
                this.updateFlagsNoLock(512, true);
                return;
            }
        }
        this.updateFlagsNoLock(512, false);
    }

    private void updateAnnotated() {
        if (this.keys != null) {
            for (String key : this.keySet()) {
                if (!OsmPrimitive.getWorkInProgressKeys().contains(key)) continue;
                this.updateFlagsNoLock(4096, true);
                return;
            }
        }
        this.updateFlagsNoLock(4096, false);
    }

    public boolean isTagged() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isAnnotated() {
        return (this.flags & 0x1000) != 0;
    }

    private void updateDirectionFlags() {
        boolean hasDirections = false;
        boolean directionReversed = false;
        if (reversedDirectionKeys.match(this)) {
            hasDirections = true;
            directionReversed = true;
        }
        if (directionKeys.match(this)) {
            hasDirections = true;
        }
        this.updateFlagsNoLock(1024, directionReversed);
        this.updateFlagsNoLock(256, hasDirections);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x100) != 0;
    }

    public boolean reversedDirection() {
        return (this.flags & 0x400) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setKeys(Map<String, String> keys) {
        boolean locked = this.writeLock();
        try {
            super.setKeys(keys);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String key, String value) {
        boolean locked = this.writeLock();
        try {
            super.put(key, value);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(String key) {
        boolean locked = this.writeLock();
        try {
            super.remove(key);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAll() {
        boolean locked = this.writeLock();
        try {
            super.removeAll();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    protected void keysChangedImpl(Map<String, String> originalKeys) {
        this.clearCachedStyle();
        if (this.dataSet != null) {
            for (OsmPrimitive ref : this.getReferrers()) {
                ref.clearCachedStyle();
            }
        }
        this.updateDirectionFlags();
        this.updateTagged();
        this.updateAnnotated();
        if (this.dataSet != null) {
            this.dataSet.fireTagsChanged(this, originalKeys);
        }
    }

    protected void addReferrer(OsmPrimitive referrer) {
        if (this.referrers == null) {
            this.referrers = referrer;
        } else if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers != referrer) {
                this.referrers = new OsmPrimitive[]{(OsmPrimitive)this.referrers, referrer};
            }
        } else {
            for (OsmPrimitive primitive : (OsmPrimitive[])this.referrers) {
                if (primitive != referrer) continue;
                return;
            }
            this.referrers = Utils.addInArrayCopy((OsmPrimitive[])this.referrers, referrer);
        }
    }

    protected void removeReferrer(OsmPrimitive referrer) {
        if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers == referrer) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] orig = (OsmPrimitive[])this.referrers;
            int idx = -1;
            for (int i = 0; i < orig.length; ++i) {
                if (orig[i] != referrer) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                return;
            }
            if (orig.length == 2) {
                this.referrers = orig[1 - idx];
            } else {
                OsmPrimitive[] smaller = new OsmPrimitive[orig.length - 1];
                System.arraycopy(orig, 0, smaller, 0, idx);
                System.arraycopy(orig, idx + 1, smaller, idx, smaller.length - idx);
                this.referrers = smaller;
            }
        }
    }

    public final List<OsmPrimitive> getReferrers(boolean allowWithoutDataset) {
        if (this.dataSet == null && allowWithoutDataset) {
            return Collections.emptyList();
        }
        this.checkDataset();
        Object referrers = this.referrers;
        ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
        if (referrers != null) {
            if (referrers instanceof OsmPrimitive) {
                OsmPrimitive ref = (OsmPrimitive)referrers;
                if (ref.dataSet == this.dataSet) {
                    result.add(ref);
                }
            } else {
                for (OsmPrimitive o : (OsmPrimitive[])referrers) {
                    if (this.dataSet != o.dataSet) continue;
                    result.add(o);
                }
            }
        }
        return result;
    }

    public final List<OsmPrimitive> getReferrers() {
        return this.getReferrers(false);
    }

    public void visitReferrers(Visitor visitor) {
        if (visitor == null) {
            return;
        }
        if (this.referrers == null) {
            return;
        }
        if (this.referrers instanceof OsmPrimitive) {
            OsmPrimitive ref = (OsmPrimitive)this.referrers;
            if (ref.dataSet == this.dataSet) {
                ref.accept(visitor);
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] refs;
            for (OsmPrimitive ref : refs = (OsmPrimitive[])this.referrers) {
                if (ref.dataSet != this.dataSet) continue;
                ref.accept(visitor);
            }
        }
    }

    public final boolean isReferredByWays(int n) {
        Object referrers = this.referrers;
        if (referrers == null) {
            return false;
        }
        this.checkDataset();
        if (referrers instanceof OsmPrimitive) {
            return n <= 1 && referrers instanceof Way && ((OsmPrimitive)referrers).dataSet == this.dataSet;
        }
        int counter = 0;
        for (OsmPrimitive o : (OsmPrimitive[])referrers) {
            if (this.dataSet != o.dataSet || !(o instanceof Way) || ++counter < n) continue;
            return true;
        }
        return false;
    }

    public abstract void accept(Visitor var1);

    public void cloneFrom(OsmPrimitive other) {
        if (this.id != other.id && this.dataSet != null) {
            throw new DataIntegrityProblemException("Osm id cannot be changed after primitive was added to the dataset");
        }
        super.cloneFrom(other);
        this.clearCachedStyle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFrom(OsmPrimitive other) {
        boolean locked = this.writeLock();
        try {
            CheckParameterUtil.ensureParameterNotNull(other, "other");
            if (other.isNew() ^ this.isNew()) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge because either of the participating primitives is new and the other is not", new Object[0]));
            }
            if (!other.isNew() && other.getId() != this.id) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge primitives with different ids. This id is {0}, the other is {1}", this.id, other.getId()));
            }
            this.setKeys(other.getKeys());
            this.timestamp = other.timestamp;
            this.version = other.version;
            this.setIncomplete(other.isIncomplete());
            this.flags = other.flags;
            this.user = other.user;
            this.changesetId = other.changesetId;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public boolean hasSameInterestingTags(OsmPrimitive other) {
        return this.keys == null && other.keys == null || this.keys != null && other.keys != null && this.keys.length == other.keys.length && (this.keys.length == 0 || this.getInterestingTags().equals(other.getInterestingTags()));
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (!this.isNew() && this.id != other.id) {
            return false;
        }
        if (this.isIncomplete() ^ other.isIncomplete()) {
            return false;
        }
        return this.hasSameInterestingTags(other);
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive other) {
        if (other == null) {
            return false;
        }
        return this.isDeleted() == other.isDeleted() && this.isModified() == other.isModified() && this.timestamp == other.timestamp && this.version == other.version && this.isVisible() == other.isVisible() && (this.user == null ? other.user == null : this.user == other.user) && this.changesetId == other.changesetId;
    }

    public void load(PrimitiveData data) {
        this.setKeys(data.getKeys());
        this.setTimestamp(data.getTimestamp());
        this.user = data.getUser();
        this.setChangesetId(data.getChangesetId());
        this.setDeleted(data.isDeleted());
        this.setModified(data.isModified());
        this.setIncomplete(data.isIncomplete());
        this.version = data.getVersion();
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData data) {
        data.setId(this.id);
        data.setKeys(this.getKeys());
        data.setTimestamp(this.getTimestamp());
        data.setUser(this.user);
        data.setDeleted(this.isDeleted());
        data.setModified(this.isModified());
        data.setVisible(this.isVisible());
        data.setIncomplete(this.isIncomplete());
        data.setChangesetId(this.changesetId);
        data.setVersion(this.version);
    }

    public abstract BBox getBBox();

    public abstract void updatePosition();

    @Override
    protected String getFlagsAsString() {
        StringBuilder builder = new StringBuilder(super.getFlagsAsString());
        if (this.isDisabled()) {
            if (this.isDisabledAndHidden()) {
                builder.append("h");
            } else {
                builder.append("d");
            }
        }
        if (this.isTagged()) {
            builder.append("T");
        }
        if (this.hasDirectionKeys()) {
            if (this.reversedDirection()) {
                builder.append("<");
            } else {
                builder.append(">");
            }
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OsmPrimitive) {
            return ((OsmPrimitive)obj).id == this.id && obj.getClass() == this.getClass();
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    public abstract String getDisplayName(NameFormatter var1);

    @Override
    public Collection<String> getTemplateKeys() {
        Collection<String> keySet = this.keySet();
        ArrayList<String> result = new ArrayList<String>(keySet.size() + 2);
        result.add("id");
        result.add("localname");
        result.addAll(keySet);
        return result;
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (special) {
            String lc = name.toLowerCase();
            if ("id".equals(lc)) {
                return this.getId();
            }
            if ("localname".equals(lc)) {
                return this.getLocalName();
            }
            return null;
        }
        return this.getIgnoreCase(name);
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        return condition.match(this);
    }

    public static Set<Relation> getParentRelations(Collection<? extends OsmPrimitive> primitives) {
        HashSet<Relation> ret = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : primitives) {
            ret.addAll(OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Relation.class));
        }
        return ret;
    }

    public final boolean hasAreaTags() {
        return this.hasKey("landuse") || "yes".equals(this.get("area")) || "riverbank".equals(this.get("waterway")) || this.hasKey("natural") || this.hasKey("amenity") || this.hasKey("leisure") || this.hasKey("building") || this.hasKey("building:part");
    }

    public abstract boolean concernsArea();

    public abstract boolean isOutsideDownloadArea();

    static {
        String reversedDirectionDefault = "oneway=\"-1\"";
        String directionDefault = "oneway? | (aerialway=* aerialway!=station) | waterway=stream | waterway=river | waterway=canal | waterway=drain | waterway=rapids | \"piste:type\"=downhill | \"piste:type\"=sled | man_made=\"piste:halfpipe\" | junction=roundabout | (highway=motorway_link & -oneway=no)";
        try {
            reversedDirectionKeys = SearchCompiler.compile(Main.pref.get("tags.reversed_direction", reversedDirectionDefault), false, false);
        }
        catch (SearchCompiler.ParseError e) {
            Main.error("Unable to compile pattern for tags.reversed_direction, trying default pattern: " + e.getMessage());
            try {
                reversedDirectionKeys = SearchCompiler.compile(reversedDirectionDefault, false, false);
            }
            catch (SearchCompiler.ParseError e2) {
                throw new AssertionError("Unable to compile default pattern for direction keys: " + e2.getMessage(), e2);
            }
        }
        try {
            directionKeys = SearchCompiler.compile(Main.pref.get("tags.direction", directionDefault), false, false);
        }
        catch (SearchCompiler.ParseError e) {
            Main.error("Unable to compile pattern for tags.direction, trying default pattern: " + e.getMessage());
            try {
                directionKeys = SearchCompiler.compile(directionDefault, false, false);
            }
            catch (SearchCompiler.ParseError e2) {
                throw new AssertionError("Unable to compile default pattern for direction keys: " + e2.getMessage(), e2);
            }
        }
    }
}

