/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;

public class NoteData {
    private long newNoteId = -1L;
    private final List<Note> noteList;
    private Note selectedNote = null;
    private Comparator<Note> comparator = DEFAULT_COMPARATOR;
    public static final Comparator<Note> DEFAULT_COMPARATOR = new Comparator<Note>(){

        @Override
        public int compare(Note n1, Note n2) {
            if (n1.getId() < 0L && n2.getId() > 0L) {
                return 1;
            }
            if (n1.getId() > 0L && n2.getId() < 0L) {
                return -1;
            }
            if (n1.getState() == Note.State.closed && n2.getState() == Note.State.open) {
                return 1;
            }
            if (n1.getState() == Note.State.open && n2.getState() == Note.State.closed) {
                return -1;
            }
            return Long.valueOf(Math.abs(n1.getId())).compareTo(Math.abs(n2.getId()));
        }
    };
    public static final Comparator<Note> DATE_COMPARATOR = new Comparator<Note>(){

        @Override
        public int compare(Note n1, Note n2) {
            return n1.getCreatedAt().compareTo(n2.getCreatedAt());
        }
    };
    public static final Comparator<Note> USER_COMPARATOR = new Comparator<Note>(){

        @Override
        public int compare(Note n1, Note n2) {
            String n2User;
            String n1User = n1.getFirstComment().getUser().getName();
            if (n1User.equals(n2User = n2.getFirstComment().getUser().getName())) {
                return n1.getCreatedAt().compareTo(n2.getCreatedAt());
            }
            return n1.getFirstComment().getUser().getName().compareTo(n2.getFirstComment().getUser().getName());
        }
    };
    public static final Comparator<Note> LAST_ACTION_COMPARATOR = new Comparator<Note>(){

        @Override
        public int compare(Note n1, Note n2) {
            Date n1Date = n1.getComments().get(n1.getComments().size() - 1).getCommentTimestamp();
            Date n2Date = n2.getComments().get(n2.getComments().size() - 1).getCommentTimestamp();
            return n1Date.compareTo(n2Date);
        }
    };

    public NoteData() {
        this.noteList = new ArrayList<Note>();
    }

    public NoteData(List<Note> notes) {
        this.noteList = notes;
        Collections.sort(notes, this.comparator);
        for (Note note : notes) {
            if (note.getId() > this.newNoteId) continue;
            this.newNoteId = note.getId() - 1L;
        }
    }

    public List<Note> getNotes() {
        return this.noteList;
    }

    public Note getSelectedNote() {
        return this.selectedNote;
    }

    public void setSelectedNote(Note note) {
        this.selectedNote = note;
        if (Main.map != null) {
            Main.map.noteDialog.selectionChanged();
            Main.map.mapView.repaint();
        }
    }

    public synchronized boolean isModified() {
        for (Note note : this.noteList) {
            if (note.getId() < 0L) {
                return true;
            }
            for (NoteComment comment : note.getComments()) {
                if (!comment.getIsNew().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void addNotes(List<Note> newNotes) {
        for (Note newNote : newNotes) {
            if (!this.noteList.contains(newNote)) {
                this.noteList.add(newNote);
            }
            if (newNote.getId() > this.newNoteId) continue;
            this.newNoteId = newNote.getId() - 1L;
        }
        this.dataUpdated();
        if (Main.isDebugEnabled()) {
            Main.debug("notes in current set: " + this.noteList.size());
        }
    }

    public synchronized void createNote(LatLon location, String text) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("Comment can not be blank when creating a note");
        }
        Note note = new Note(location);
        note.setCreatedAt(new Date());
        note.setState(Note.State.open);
        note.setId(this.newNoteId--);
        NoteComment comment = new NoteComment(new Date(), this.getCurrentUser(), text, NoteComment.Action.opened, true);
        note.addComment(comment);
        if (Main.isDebugEnabled()) {
            Main.debug("Created note {0} with comment: {1}", note.getId(), text);
        }
        this.noteList.add(note);
        this.dataUpdated();
    }

    public synchronized void addCommentToNote(Note note, String text) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to modify must be in layer");
        }
        if (note.getState() == Note.State.closed) {
            throw new IllegalStateException("Cannot add a comment to a closed note");
        }
        if (Main.isDebugEnabled()) {
            Main.debug("Adding comment to note {0}: {1}", note.getId(), text);
        }
        NoteComment comment = new NoteComment(new Date(), this.getCurrentUser(), text, NoteComment.Action.commented, true);
        note.addComment(comment);
        this.dataUpdated();
    }

    public synchronized void closeNote(Note note, String text) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to close must be in layer");
        }
        if (note.getState() != Note.State.open) {
            throw new IllegalStateException("Cannot close a note that isn't open");
        }
        if (Main.isDebugEnabled()) {
            Main.debug("closing note {0} with comment: {1}", note.getId(), text);
        }
        NoteComment comment = new NoteComment(new Date(), this.getCurrentUser(), text, NoteComment.Action.closed, true);
        note.addComment(comment);
        note.setState(Note.State.closed);
        note.setClosedAt(new Date());
        this.dataUpdated();
    }

    public synchronized void reOpenNote(Note note, String text) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to reopen must be in layer");
        }
        if (note.getState() != Note.State.closed) {
            throw new IllegalStateException("Cannot reopen a note that isn't closed");
        }
        if (Main.isDebugEnabled()) {
            Main.debug("reopening note {0} with comment: {1}", note.getId(), text);
        }
        NoteComment comment = new NoteComment(new Date(), this.getCurrentUser(), text, NoteComment.Action.reopened, true);
        note.addComment(comment);
        note.setState(Note.State.open);
        this.dataUpdated();
    }

    private void dataUpdated() {
        Collections.sort(this.noteList, this.comparator);
        Main.map.noteDialog.setNoteList(this.noteList);
        Main.map.mapView.repaint();
    }

    private User getCurrentUser() {
        JosmUserIdentityManager userMgr = JosmUserIdentityManager.getInstance();
        return User.createOsmUser(userMgr.getUserId(), userMgr.getUserName());
    }

    public synchronized void updateNotes(Map<Note, Note> updatedNotes) {
        for (Map.Entry<Note, Note> entry : updatedNotes.entrySet()) {
            Note oldNote = entry.getKey();
            Note newNote = entry.getValue();
            oldNote.updateWith(newNote);
        }
        this.dataUpdated();
    }

    public Comparator<Note> getCurrentSortMethod() {
        return this.comparator;
    }

    public void setSortMethod(Comparator<Note> comparator) {
        this.comparator = comparator;
        this.dataUpdated();
    }
}

