/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public final class Node
extends OsmPrimitive
implements INode {
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private double east = Double.NaN;
    private double north = Double.NaN;

    public final boolean isLatLonKnown() {
        return !Double.isNaN(this.lat) && !Double.isNaN(this.lon);
    }

    @Override
    public final void setCoor(LatLon coor) {
        this.updateCoor(coor, null);
    }

    @Override
    public final void setEastNorth(EastNorth eastNorth) {
        this.updateCoor(null, eastNorth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCoor(LatLon coor, EastNorth eastNorth) {
        if (this.getDataSet() != null) {
            boolean locked = this.writeLock();
            try {
                this.getDataSet().fireNodeMoved(this, coor, eastNorth);
            }
            finally {
                this.writeUnlock(locked);
            }
        } else {
            this.setCoorInternal(coor, eastNorth);
        }
    }

    @Override
    public final LatLon getCoor() {
        if (!this.isLatLonKnown()) {
            return null;
        }
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public final EastNorth getEastNorth() {
        if (!this.isLatLonKnown()) {
            return null;
        }
        if (this.getDataSet() == null) {
            return Projections.project(new LatLon(this.lat, this.lon));
        }
        if (Double.isNaN(this.east) || Double.isNaN(this.north)) {
            EastNorth en = Projections.project(new LatLon(this.lat, this.lon));
            this.east = en.east();
            this.north = en.north();
        }
        return new EastNorth(this.east, this.north);
    }

    protected void setCoorInternal(LatLon coor, EastNorth eastNorth) {
        if (coor != null) {
            this.lat = coor.lat();
            this.lon = coor.lon();
            this.invalidateEastNorthCache();
        } else if (eastNorth != null) {
            LatLon ll = Projections.inverseProject(eastNorth);
            this.lat = ll.lat();
            this.lon = ll.lon();
            this.east = eastNorth.east();
            this.north = eastNorth.north();
        } else {
            this.lat = Double.NaN;
            this.lon = Double.NaN;
            this.invalidateEastNorthCache();
            if (this.isVisible()) {
                this.setIncomplete(true);
            }
        }
    }

    protected Node(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long id) throws IllegalArgumentException {
        super(id, false);
    }

    public Node(long id, int version) throws IllegalArgumentException {
        super(id, version, false);
    }

    public Node(Node clone, boolean clearMetadata) {
        super(clone.getUniqueId(), true);
        this.cloneFrom(clone);
        if (clearMetadata) {
            this.clearOsmMetadata();
        }
    }

    public Node(Node clone) {
        this(clone, false);
    }

    public Node(LatLon latlon) {
        super(0L, false);
        this.setCoor(latlon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    @Override
    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        if (!this.isIncomplete() && this.isVisible() && !this.isLatLonKnown()) {
            throw new DataIntegrityProblemException("Complete node with null coordinates: " + this.toString());
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osm) {
        boolean locked = this.writeLock();
        try {
            super.cloneFrom(osm);
            this.setCoor(((Node)osm).getCoor());
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeFrom(OsmPrimitive other) {
        boolean locked = this.writeLock();
        try {
            super.mergeFrom(other);
            if (!other.isIncomplete()) {
                this.setCoor(((Node)other).getCoor());
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData data) {
        boolean locked = this.writeLock();
        try {
            super.load(data);
            this.setCoor(((NodeData)data).getCoor());
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public NodeData save() {
        NodeData data = new NodeData();
        this.saveCommonAttributes(data);
        if (!this.isIncomplete()) {
            data.setCoor(this.getCoor());
        }
        return data;
    }

    public String toString() {
        String coorDesc = this.isLatLonKnown() ? "lat=" + this.lat + ",lon=" + this.lon : "";
        return "{Node id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + coorDesc + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (!(other instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other)) {
            return false;
        }
        Node n = (Node)other;
        LatLon coor = this.getCoor();
        LatLon otherCoor = n.getCoor();
        if (coor == null && otherCoor == null) {
            return true;
        }
        if (coor != null && otherCoor != null) {
            return coor.equalsEpsilon(otherCoor);
        }
        return false;
    }

    @Override
    public int compareTo(OsmPrimitive o) {
        return o instanceof Node ? Long.valueOf(this.getUniqueId()).compareTo(o.getUniqueId()) : 1;
    }

    @Override
    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    @Override
    public BBox getBBox() {
        return new BBox(this);
    }

    @Override
    public void updatePosition() {
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && this.isLatLonKnown();
    }

    public boolean isConnectionNode() {
        return this.isReferredByWays(2);
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }

    @Override
    public boolean concernsArea() {
        return false;
    }

    public boolean isConnectedTo(Collection<Node> otherNodes, int hops, Predicate<Node> predicate) {
        CheckParameterUtil.ensureParameterNotNull(otherNodes);
        CheckParameterUtil.ensureThat(!otherNodes.isEmpty(), "otherNodes must not be empty!");
        CheckParameterUtil.ensureThat(hops >= 0, "hops must be non-negative!");
        return hops == 0 ? this.isConnectedTo(otherNodes, hops, predicate, null) : this.isConnectedTo(otherNodes, hops, predicate, new TreeSet<Node>());
    }

    private boolean isConnectedTo(Collection<Node> otherNodes, int hops, Predicate<Node> predicate, Set<Node> visited) {
        if (otherNodes.contains(this)) {
            return true;
        }
        if (hops > 0) {
            visited.add(this);
            for (Way w : Utils.filteredCollection(this.getReferrers(), Way.class)) {
                for (Node n : w.getNodes()) {
                    boolean containsN = visited.contains(n);
                    visited.add(n);
                    if (containsN || predicate != null && !predicate.evaluate(n) || !n.isConnectedTo(otherNodes, hops - 1, predicate, visited)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isOutsideDownloadArea() {
        return !this.isNewOrUndeleted() && this.getDataSet() != null && this.getDataSet().getDataSourceArea() != null && !this.getCoor().isIn(this.getDataSet().getDataSourceArea());
    }
}

