/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class MultipolygonBuilder {
    private static final Pair<Integer, ExecutorService> THREAD_POOL = Utils.newThreadPool("multipolygon_creation.numberOfThreads");
    public final List<JoinedPolygon> outerWays;
    public final List<JoinedPolygon> innerWays;

    public MultipolygonBuilder(List<JoinedPolygon> outerWays, List<JoinedPolygon> innerWays) {
        this.outerWays = outerWays;
        this.innerWays = innerWays;
    }

    public MultipolygonBuilder() {
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
    }

    public String makeFromWays(Collection<Way> ways) {
        try {
            List<JoinedPolygon> joinedWays = MultipolygonBuilder.joinWays(ways);
            return this.makeFromPolygons(joinedWays);
        }
        catch (JoinedPolygonCreationException ex) {
            return ex.getMessage();
        }
    }

    public static List<JoinedPolygon> joinWays(Collection<Way> ways) throws JoinedPolygonCreationException {
        ArrayList<JoinedPolygon> joinedWays = new ArrayList<JoinedPolygon>();
        MultiMap<Node, Way> nodesWithConnectedWays = new MultiMap<Node, Way>();
        HashSet<Way> usedWays = new HashSet<Way>();
        for (Way w : ways) {
            if (w.getNodesCount() < 2) {
                throw new JoinedPolygonCreationException(I18n.tr("Cannot add a way with only {0} nodes.", w.getNodesCount()));
            }
            if (w.isClosed()) {
                JoinedPolygon jw = new JoinedPolygon(w);
                joinedWays.add(jw);
                usedWays.add(w);
                continue;
            }
            nodesWithConnectedWays.put(w.lastNode(), w);
            nodesWithConnectedWays.put(w.firstNode(), w);
        }
        for (Way startWay : ways) {
            if (usedWays.contains(startWay)) continue;
            Node startNode = startWay.firstNode();
            ArrayList<Way> collectedWays = new ArrayList<Way>();
            ArrayList<Boolean> collectedWaysReverse = new ArrayList<Boolean>();
            Way curWay = startWay;
            Node prevNode = startNode;
            while (true) {
                boolean curWayReverse = prevNode == curWay.lastNode();
                Node nextNode = curWayReverse ? curWay.firstNode() : curWay.lastNode();
                collectedWays.add(curWay);
                collectedWaysReverse.add(curWayReverse);
                if (nextNode == startNode) break;
                Set adjacentWays = nodesWithConnectedWays.get(nextNode);
                if (adjacentWays.size() != 2) {
                    throw new JoinedPolygonCreationException(I18n.tr("Each node must connect exactly 2 ways", new Object[0]));
                }
                Way nextWay = null;
                for (Way way : adjacentWays) {
                    if (way == curWay) continue;
                    nextWay = way;
                }
                curWay = nextWay;
                prevNode = nextNode;
            }
            usedWays.addAll(collectedWays);
            joinedWays.add(new JoinedPolygon(collectedWays, collectedWaysReverse));
        }
        return joinedWays;
    }

    private String makeFromPolygons(List<JoinedPolygon> polygons) {
        List<PolygonLevel> list = MultipolygonBuilder.findOuterWaysMultiThread(polygons);
        if (list == null) {
            return I18n.tr("There is an intersection between ways.", new Object[0]);
        }
        this.outerWays.clear();
        this.innerWays.clear();
        for (PolygonLevel pol : list) {
            if (pol.level % 2 == 0) {
                this.outerWays.add(pol.outerWay);
                continue;
            }
            this.innerWays.add(pol.outerWay);
        }
        return null;
    }

    private static Pair<Boolean, List<JoinedPolygon>> findInnerWaysCandidates(JoinedPolygon outerWay, Collection<JoinedPolygon> boundaryWays) {
        boolean outerGood = true;
        ArrayList<JoinedPolygon> innerCandidates = new ArrayList<JoinedPolygon>();
        for (JoinedPolygon innerWay : boundaryWays) {
            if (innerWay == outerWay || !outerWay.bounds.intersects(innerWay.bounds)) continue;
            Geometry.PolygonIntersection intersection = Geometry.polygonIntersection(outerWay.area, innerWay.area);
            if (intersection == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                outerGood = false;
                break;
            }
            if (intersection == Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) {
                innerCandidates.add(innerWay);
                continue;
            }
            if (intersection != Geometry.PolygonIntersection.CROSSING) continue;
            return null;
        }
        return new Pair<Boolean, List<JoinedPolygon>>(outerGood, innerCandidates);
    }

    private static List<PolygonLevel> findOuterWaysMultiThread(List<JoinedPolygon> boundaryWays) {
        ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
        ArrayList<Worker> tasks = new ArrayList<Worker>();
        int bucketsize = Math.max(32, boundaryWays.size() / (Integer)MultipolygonBuilder.THREAD_POOL.a / 3);
        int noBuckets = (boundaryWays.size() + bucketsize - 1) / bucketsize;
        boolean singleThread = (Integer)MultipolygonBuilder.THREAD_POOL.a == 1 || noBuckets == 1;
        for (int i = 0; i < noBuckets; ++i) {
            int from = i * bucketsize;
            int to = Math.min((i + 1) * bucketsize, boundaryWays.size());
            ArrayList<PolygonLevel> target = singleThread ? result : new ArrayList<PolygonLevel>(to - from);
            tasks.add(new Worker(boundaryWays, from, to, target));
        }
        if (singleThread) {
            try {
                for (Worker task : tasks) {
                    if (task.call() != null) continue;
                    return null;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (!tasks.isEmpty()) {
            try {
                for (Future future : ((ExecutorService)MultipolygonBuilder.THREAD_POOL.b).invokeAll(tasks)) {
                    List res = (List)future.get();
                    if (res == null) {
                        return null;
                    }
                    result.addAll(res);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    private static class Worker
    implements Callable<List<PolygonLevel>> {
        private final List<JoinedPolygon> input;
        private final int from;
        private final int to;
        private final List<PolygonLevel> output;

        public Worker(List<JoinedPolygon> input, int from, int to, List<PolygonLevel> output) {
            this.input = input;
            this.from = from;
            this.to = to;
            this.output = output;
        }

        private static List<PolygonLevel> findOuterWaysRecursive(int level, List<JoinedPolygon> boundaryWays) {
            ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
            for (JoinedPolygon outerWay : boundaryWays) {
                if (Worker.processOuterWay(level, boundaryWays, result, outerWay) != null) continue;
                return null;
            }
            return result;
        }

        private static List<PolygonLevel> processOuterWay(int level, List<JoinedPolygon> boundaryWays, List<PolygonLevel> result, JoinedPolygon outerWay) {
            Pair p = MultipolygonBuilder.findInnerWaysCandidates(outerWay, boundaryWays);
            if (p == null) {
                return null;
            }
            if (((Boolean)p.a).booleanValue()) {
                PolygonLevel pol = new PolygonLevel(outerWay, level);
                if (!((List)p.b).isEmpty()) {
                    List<PolygonLevel> innerList = Worker.findOuterWaysRecursive(level + 1, (List)p.b);
                    if (innerList == null) {
                        return null;
                    }
                    result.addAll(innerList);
                    for (PolygonLevel pl : innerList) {
                        if (pl.level != level + 1) continue;
                        pol.innerWays.add(pl.outerWay);
                    }
                }
                result.add(pol);
            }
            return result;
        }

        @Override
        public List<PolygonLevel> call() throws Exception {
            for (int i = this.from; i < this.to; ++i) {
                if (Worker.processOuterWay(0, this.input, this.output, this.input.get(i)) != null) continue;
                return null;
            }
            return this.output;
        }
    }

    public static class JoinedPolygonCreationException
    extends RuntimeException {
        public JoinedPolygonCreationException(String message) {
            super(message);
        }
    }

    static class PolygonLevel {
        public final int level;
        public final JoinedPolygon outerWay;
        public List<JoinedPolygon> innerWays;

        public PolygonLevel(JoinedPolygon pol, int level) {
            this.outerWay = pol;
            this.level = level;
            this.innerWays = new ArrayList<JoinedPolygon>();
        }
    }

    public static class JoinedPolygon {
        public final List<Way> ways;
        public final List<Boolean> reversed;
        public final List<Node> nodes;
        public final Area area;
        public final Rectangle bounds;

        public JoinedPolygon(List<Way> ways, List<Boolean> reversed) {
            this.ways = ways;
            this.reversed = reversed;
            this.nodes = this.getNodes();
            this.area = Geometry.getArea(this.nodes);
            this.bounds = this.area.getBounds();
        }

        public JoinedPolygon(Way way) {
            this(Collections.singletonList(way), Collections.singletonList(Boolean.FALSE));
        }

        public List<Node> getNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int waypos = 0; waypos < this.ways.size(); ++waypos) {
                int pos;
                Way way = this.ways.get(waypos);
                boolean reversed = this.reversed.get(waypos);
                if (!reversed) {
                    for (pos = 0; pos < way.getNodesCount() - 1; ++pos) {
                        nodes.add(way.getNode(pos));
                    }
                    continue;
                }
                for (pos = way.getNodesCount() - 1; pos > 0; --pos) {
                    nodes.add(way.getNode(pos));
                }
            }
            return nodes;
        }
    }
}

