/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.Utils;

public final class FilterWorker {
    public static boolean executeFilters(Collection<OsmPrimitive> all, FilterMatcher filterMatcher) {
        boolean changed = false;
        changed = FilterWorker.doExecuteFilters(Utils.filter(all, OsmPrimitive.relationPredicate), filterMatcher);
        changed |= FilterWorker.doExecuteFilters(Utils.filter(all, OsmPrimitive.wayPredicate), filterMatcher);
        return changed |= FilterWorker.doExecuteFilters(Utils.filter(all, OsmPrimitive.nodePredicate), filterMatcher);
    }

    private static boolean doExecuteFilters(Collection<OsmPrimitive> all, FilterMatcher filterMatcher) {
        boolean changed = false;
        for (OsmPrimitive primitive : all) {
            FilterMatcher.FilterType hiddenType = filterMatcher.isHidden(primitive);
            if (hiddenType != FilterMatcher.FilterType.NOT_FILTERED) {
                changed |= primitive.setDisabledState(true);
                primitive.setHiddenType(hiddenType == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            FilterMatcher.FilterType disabledType = filterMatcher.isDisabled(primitive);
            if (disabledType != FilterMatcher.FilterType.NOT_FILTERED) {
                changed |= primitive.setDisabledState(false);
                primitive.setDisabledType(disabledType == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            changed |= primitive.unsetDisabledState();
        }
        return changed;
    }

    public static boolean executeFilters(OsmPrimitive primitive, FilterMatcher filterMatcher) {
        return FilterWorker.doExecuteFilters(Collections.singleton(primitive), filterMatcher);
    }

    public static void clearFilterFlags(Collection<OsmPrimitive> prims) {
        for (OsmPrimitive osm : prims) {
            osm.unsetDisabledState();
        }
    }
}

