/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class FilterMatcher {
    private final List<FilterInfo> hiddenFilters = new ArrayList<FilterInfo>();
    private final List<FilterInfo> disabledFilters = new ArrayList<FilterInfo>();

    public void update(Collection<Filter> filters) throws SearchCompiler.ParseError {
        this.hiddenFilters.clear();
        this.disabledFilters.clear();
        for (Filter filter : filters) {
            if (!filter.enable) continue;
            FilterInfo fi = new FilterInfo(filter);
            if (fi.isDelete) {
                if (filter.hiding) {
                    this.hiddenFilters.add(fi);
                    continue;
                }
                this.disabledFilters.add(fi);
                this.hiddenFilters.add(fi);
                continue;
            }
            if (filter.mode == SearchAction.SearchMode.replace && filter.hiding) {
                this.hiddenFilters.clear();
                this.disabledFilters.clear();
            }
            this.disabledFilters.add(fi);
            if (!filter.hiding) continue;
            this.hiddenFilters.add(fi);
        }
    }

    private boolean isFiltered(OsmPrimitive primitive, boolean hidden) {
        return hidden ? primitive.isDisabledAndHidden() : primitive.isDisabled();
    }

    private boolean isFilterExplicit(OsmPrimitive primitive, boolean hidden) {
        return hidden ? primitive.getHiddenType() : primitive.getDisabledType();
    }

    private boolean allParentWaysFiltered(OsmPrimitive primitive, boolean hidden) {
        List<OsmPrimitive> refs = primitive.getReferrers();
        boolean isExplicit = false;
        for (OsmPrimitive p : refs) {
            if (!(p instanceof Way)) continue;
            if (!this.isFiltered(p, hidden)) {
                return false;
            }
            isExplicit |= this.isFilterExplicit(p, hidden);
        }
        return isExplicit;
    }

    private boolean oneParentWayNotFiltered(OsmPrimitive primitive, boolean hidden) {
        List<OsmPrimitive> refs = primitive.getReferrers();
        for (OsmPrimitive p : refs) {
            if (!(p instanceof Way) || this.isFiltered(p, hidden)) continue;
            return true;
        }
        return false;
    }

    private boolean allParentMultipolygonsFiltered(OsmPrimitive primitive, boolean hidden) {
        boolean isExplicit = false;
        for (Relation r : new SubclassFilteredCollection(primitive.getReferrers(), OsmPrimitive.multipolygonPredicate)) {
            if (!this.isFiltered(r, hidden)) {
                return false;
            }
            isExplicit |= this.isFilterExplicit(r, hidden);
        }
        return isExplicit;
    }

    private boolean oneParentMultipolygonNotFiltered(OsmPrimitive primitive, boolean hidden) {
        for (Relation r : new SubclassFilteredCollection(primitive.getReferrers(), OsmPrimitive.multipolygonPredicate)) {
            if (this.isFiltered(r, hidden)) continue;
            return true;
        }
        return false;
    }

    private FilterType test(List<FilterInfo> filters, OsmPrimitive primitive, boolean hidden) {
        if (primitive.isIncomplete()) {
            return FilterType.NOT_FILTERED;
        }
        boolean filtered = false;
        boolean explicitlyFiltered = false;
        for (FilterInfo fi : filters) {
            if (fi.isDelete) {
                if (!filtered || !fi.match.match(primitive)) continue;
                filtered = false;
                continue;
            }
            if (filtered && (explicitlyFiltered || fi.isInverted) || !fi.match.match(primitive)) continue;
            filtered = true;
            if (fi.isInverted) continue;
            explicitlyFiltered = true;
        }
        if (primitive instanceof Node) {
            if (filtered) {
                if (explicitlyFiltered) {
                    return FilterType.PASSIV;
                }
                if (this.oneParentWayNotFiltered(primitive, hidden)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!primitive.isTagged() && this.allParentWaysFiltered(primitive, hidden)) {
                return FilterType.PASSIV;
            }
            return FilterType.NOT_FILTERED;
        }
        if (primitive instanceof Way) {
            if (filtered) {
                if (explicitlyFiltered) {
                    return FilterType.EXPLICIT;
                }
                if (this.oneParentMultipolygonNotFiltered(primitive, hidden)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!primitive.isTagged() && this.allParentMultipolygonsFiltered(primitive, hidden)) {
                return FilterType.EXPLICIT;
            }
            return FilterType.NOT_FILTERED;
        }
        if (filtered) {
            return explicitlyFiltered ? FilterType.EXPLICIT : FilterType.PASSIV;
        }
        return FilterType.NOT_FILTERED;
    }

    public FilterType isHidden(OsmPrimitive primitive) {
        return this.test(this.hiddenFilters, primitive, true);
    }

    public FilterType isDisabled(OsmPrimitive primitive) {
        return this.test(this.disabledFilters, primitive, false);
    }

    private static class FilterInfo {
        final SearchCompiler.Match match;
        final boolean isDelete;
        final boolean isInverted;

        FilterInfo(Filter filter) throws SearchCompiler.ParseError {
            this.isDelete = filter.mode == SearchAction.SearchMode.remove || filter.mode == SearchAction.SearchMode.in_selection;
            SearchCompiler.Match compiled = SearchCompiler.compile(filter.text, filter.caseSensitive, filter.regexSearch);
            this.match = filter.inverted ? new SearchCompiler.Not(compiled) : compiled;
            this.isInverted = filter.inverted;
        }
    }

    public static enum FilterType {
        NOT_FILTERED,
        EXPLICIT,
        PASSIV;

    }
}

