/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DatasetConsistencyTest {
    private final DataSet dataSet;
    private final PrintWriter writer;
    private int errorCount;

    public DatasetConsistencyTest(DataSet dataSet, Writer writer) {
        this.dataSet = dataSet;
        this.writer = new PrintWriter(writer);
    }

    private void printError(String type, String message, Object ... args) {
        ++this.errorCount;
        if (this.errorCount <= 100) {
            this.writer.println("[" + type + "] " + String.format(message, args));
        }
    }

    public void checkReferrers() {
        long startTime = System.currentTimeMillis();
        for (Way way : this.dataSet.getWays()) {
            if (way.isDeleted()) continue;
            for (Node n : way.getNodes()) {
                if (n.getDataSet() == null || n.getReferrers().contains(way)) continue;
                this.printError("WAY NOT IN REFERRERS", "%s is part of %s but is not in referrers", n, way);
            }
        }
        for (Relation relation : this.dataSet.getRelations()) {
            if (relation.isDeleted()) continue;
            for (RelationMember m : relation.getMembers()) {
                if (m.getMember().getDataSet() == null || m.getMember().getReferrers().contains(relation)) continue;
                this.printError("RELATION NOT IN REFERRERS", "%s is part of %s but is not in referrers", m.getMember(), relation);
            }
        }
        this.printElapsedTime(startTime);
    }

    public void checkCompleteWaysWithIncompleteNodes() {
        long startTime = System.currentTimeMillis();
        for (Way way : this.dataSet.getWays()) {
            if (!way.isUsable()) continue;
            for (Node node : way.getNodes()) {
                if (!node.isIncomplete()) continue;
                this.printError("USABLE HAS INCOMPLETE", "%s is usable but contains incomplete node '%s'", way, node);
            }
        }
        this.printElapsedTime(startTime);
    }

    public void checkCompleteNodesWithoutCoordinates() {
        long startTime = System.currentTimeMillis();
        for (Node node : this.dataSet.getNodes()) {
            if (node.isIncomplete() || !node.isVisible() || node.isLatLonKnown()) continue;
            this.printError("COMPLETE WITHOUT COORDINATES", "%s is not incomplete but has null coordinates", node);
        }
        this.printElapsedTime(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchNodes() {
        long startTime = System.currentTimeMillis();
        this.dataSet.getReadLock().lock();
        try {
            for (Node n : this.dataSet.getNodes()) {
                if (!n.isDrawable() || this.dataSet.containsNode(n)) continue;
                this.printError("SEARCH NODES", "%s not found using Dataset.containsNode()", n);
            }
        }
        finally {
            this.dataSet.getReadLock().unlock();
        }
        this.printElapsedTime(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchWays() {
        long startTime = System.currentTimeMillis();
        this.dataSet.getReadLock().lock();
        try {
            for (Way w : this.dataSet.getWays()) {
                if (w.isIncomplete() || w.isDeleted() || w.getNodesCount() < 2 || this.dataSet.containsWay(w)) continue;
                this.printError("SEARCH WAYS", "%s not found using Dataset.containsWay()", w);
            }
        }
        finally {
            this.dataSet.getReadLock().unlock();
        }
        this.printElapsedTime(startTime);
    }

    private void checkReferredPrimitive(OsmPrimitive primitive, OsmPrimitive parent) {
        if (primitive.getDataSet() == null) {
            this.printError("NO DATASET", "%s is referenced by %s but not found in dataset", primitive, parent);
        } else if (this.dataSet.getPrimitiveById(primitive) == null) {
            this.printError("REFERENCED BUT NOT IN DATA", "%s is referenced by %s but not found in dataset", primitive, parent);
        } else if (this.dataSet.getPrimitiveById(primitive) != primitive) {
            this.printError("DIFFERENT INSTANCE", "%s is different instance that referred by %s", primitive, parent);
        }
        if (primitive.isDeleted()) {
            this.printError("DELETED REFERENCED", "%s refers to deleted primitive %s", parent, primitive);
        }
    }

    public void referredPrimitiveNotInDataset() {
        long startTime = System.currentTimeMillis();
        for (Way way : this.dataSet.getWays()) {
            for (Node node : way.getNodes()) {
                this.checkReferredPrimitive(node, way);
            }
        }
        for (Relation relation : this.dataSet.getRelations()) {
            for (RelationMember member : relation.getMembers()) {
                this.checkReferredPrimitive(member.getMember(), relation);
            }
        }
        this.printElapsedTime(startTime);
    }

    public void checkZeroNodesWays() {
        long startTime = System.currentTimeMillis();
        for (Way way : this.dataSet.getWays()) {
            if (way.isUsable() && way.getNodesCount() == 0) {
                this.printError("WARN - ZERO NODES", "Way %s has zero nodes", way);
                continue;
            }
            if (!way.isUsable() || way.getNodesCount() != 1) continue;
            this.printError("WARN - NO NODES", "Way %s has only one node", way);
        }
        this.printElapsedTime(startTime);
    }

    private void printElapsedTime(long startTime) {
        if (Main.isDebugEnabled()) {
            StackTraceElement item = Thread.currentThread().getStackTrace()[2];
            String operation = this.getClass().getSimpleName() + "." + item.getMethodName();
            long elapsedTime = System.currentTimeMillis() - startTime;
            Main.debug(I18n.tr("Test ''{0}'' completed in {1}", operation, Utils.getDurationString(elapsedTime)));
        }
    }

    public void runTest() {
        try {
            long startTime = System.currentTimeMillis();
            this.referredPrimitiveNotInDataset();
            this.checkReferrers();
            this.checkCompleteWaysWithIncompleteNodes();
            this.checkCompleteNodesWithoutCoordinates();
            this.searchNodes();
            this.searchWays();
            this.checkZeroNodesWays();
            this.printElapsedTime(startTime);
            if (this.errorCount > 100) {
                this.writer.println(this.errorCount - 100 + " more...");
            }
        }
        catch (Exception e) {
            this.writer.println("Exception during dataset integrity test:");
            e.printStackTrace(this.writer);
        }
    }

    public static String runTests(DataSet dataSet) {
        StringWriter writer = new StringWriter();
        new DatasetConsistencyTest(dataSet, writer).runTest();
        return writer.toString();
    }
}

