/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.data.osm.DefaultChangesetCacheEvent;
import org.openstreetmap.josm.gui.util.GuiHelper;

public final class ChangesetCache
implements Preferences.PreferenceChangedListener {
    private static final ChangesetCache instance = new ChangesetCache();
    private final Map<Integer, Changeset> cache = new HashMap<Integer, Changeset>();
    private final CopyOnWriteArrayList<ChangesetCacheListener> listeners = new CopyOnWriteArrayList();

    public static ChangesetCache getInstance() {
        return instance;
    }

    private ChangesetCache() {
        Main.pref.addPreferenceChangeListener(this);
    }

    public void addChangesetCacheListener(ChangesetCacheListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeChangesetCacheListener(ChangesetCacheListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireChangesetCacheEvent(final ChangesetCacheEvent e) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (ChangesetCacheListener l : ChangesetCache.this.listeners) {
                    l.changesetCacheUpdated(e);
                }
            }
        });
    }

    protected void update(Changeset cs, DefaultChangesetCacheEvent e) {
        if (cs == null) {
            return;
        }
        if (cs.isNew()) {
            return;
        }
        Changeset inCache = this.cache.get(cs.getId());
        if (inCache != null) {
            inCache.mergeFrom(cs);
            e.rememberUpdatedChangeset(inCache);
        } else {
            e.rememberAddedChangeset(cs);
            this.cache.put(cs.getId(), cs);
        }
    }

    public void update(Changeset cs) {
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        this.update(cs, e);
        this.fireChangesetCacheEvent(e);
    }

    public void update(Collection<Changeset> changesets) {
        if (changesets == null || changesets.isEmpty()) {
            return;
        }
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        for (Changeset cs : changesets) {
            this.update(cs, e);
        }
        this.fireChangesetCacheEvent(e);
    }

    public boolean contains(int id) {
        if (id <= 0) {
            return false;
        }
        return this.cache.get(id) != null;
    }

    public boolean contains(Changeset cs) {
        if (cs == null) {
            return false;
        }
        if (cs.isNew()) {
            return false;
        }
        return this.contains(cs.getId());
    }

    public Changeset get(int id) {
        return this.cache.get(id);
    }

    public Set<Changeset> getChangesets() {
        return new HashSet<Changeset>(this.cache.values());
    }

    protected void remove(int id, DefaultChangesetCacheEvent e) {
        if (id <= 0) {
            return;
        }
        Changeset cs = this.cache.get(id);
        if (cs == null) {
            return;
        }
        this.cache.remove(id);
        e.rememberRemovedChangeset(cs);
    }

    public void remove(int id) {
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        this.remove(id, e);
        if (!e.isEmpty()) {
            this.fireChangesetCacheEvent(e);
        }
    }

    public void remove(Changeset cs) {
        if (cs == null) {
            return;
        }
        if (cs.isNew()) {
            return;
        }
        this.remove(cs.getId());
    }

    public void remove(Collection<Changeset> changesets) {
        if (changesets == null) {
            return;
        }
        DefaultChangesetCacheEvent evt = new DefaultChangesetCacheEvent(this);
        for (Changeset cs : changesets) {
            if (cs == null || cs.isNew()) continue;
            this.remove(cs.getId(), evt);
        }
        if (!evt.isEmpty()) {
            this.fireChangesetCacheEvent(evt);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        DefaultChangesetCacheEvent e = new DefaultChangesetCacheEvent(this);
        for (Changeset cs : this.cache.values()) {
            e.rememberRemovedChangeset(cs);
        }
        this.cache.clear();
        this.fireChangesetCacheEvent(e);
    }

    public List<Changeset> getOpenChangesets() {
        ArrayList<Changeset> ret = new ArrayList<Changeset>();
        for (Changeset cs : this.cache.values()) {
            if (!cs.isOpen()) continue;
            ret.add(cs);
        }
        return ret;
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        if (e.getKey() == null || !"osm-server.url".equals(e.getKey())) {
            return;
        }
        if (e.getOldValue() == null || e.getNewValue() == null || !e.getOldValue().equals(e.getNewValue())) {
            this.clear();
        }
    }
}

