/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Utils;

public class BBox {
    private double xmin = Double.POSITIVE_INFINITY;
    private double xmax = Double.NEGATIVE_INFINITY;
    private double ymin = Double.POSITIVE_INFINITY;
    private double ymax = Double.NEGATIVE_INFINITY;

    public BBox(double x, double y) {
        this.xmax = this.xmin = x;
        this.ymax = this.ymin = y;
        this.sanity();
    }

    public BBox(LatLon a, LatLon b) {
        this(a.lon(), a.lat(), b.lon(), b.lat());
    }

    public BBox(BBox copy) {
        this.xmin = copy.xmin;
        this.xmax = copy.xmax;
        this.ymin = copy.ymin;
        this.ymax = copy.ymax;
    }

    public BBox(double a_x, double a_y, double b_x, double b_y) {
        if (a_x > b_x) {
            this.xmax = a_x;
            this.xmin = b_x;
        } else {
            this.xmax = b_x;
            this.xmin = a_x;
        }
        if (a_y > b_y) {
            this.ymax = a_y;
            this.ymin = b_y;
        } else {
            this.ymax = b_y;
            this.ymin = a_y;
        }
        this.sanity();
    }

    public BBox(Way w) {
        for (Node n : w.getNodes()) {
            LatLon coor = n.getCoor();
            if (coor == null) continue;
            this.add(coor);
        }
    }

    public BBox(Node n) {
        LatLon coor = n.getCoor();
        if (coor == null) {
            this.ymax = 0.0;
            this.ymin = 0.0;
            this.xmax = 0.0;
            this.xmin = 0.0;
        } else {
            this.xmin = this.xmax = coor.lon();
            this.ymin = this.ymax = coor.lat();
        }
    }

    private void sanity() {
        if (this.xmin < -180.0) {
            this.xmin = -180.0;
        }
        if (this.xmax > 180.0) {
            this.xmax = 180.0;
        }
        if (this.ymin < -90.0) {
            this.ymin = -90.0;
        }
        if (this.ymax > 90.0) {
            this.ymax = 90.0;
        }
    }

    public final void add(LatLon c) {
        this.add(c.lon(), c.lat());
    }

    public final void add(double x, double y) {
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        this.sanity();
    }

    public final void add(BBox box) {
        this.xmin = Math.min(this.xmin, box.xmin);
        this.xmax = Math.max(this.xmax, box.xmax);
        this.ymin = Math.min(this.ymin, box.ymin);
        this.ymax = Math.max(this.ymax, box.ymax);
        this.sanity();
    }

    public void addPrimitive(OsmPrimitive primitive, double extraSpace) {
        BBox primBbox = primitive.getBBox();
        this.add(primBbox.xmin - extraSpace, primBbox.ymin - extraSpace);
        this.add(primBbox.xmax + extraSpace, primBbox.ymax + extraSpace);
    }

    public double height() {
        return this.ymax - this.ymin;
    }

    public double width() {
        return this.xmax - this.xmin;
    }

    public boolean bounds(BBox b) {
        return this.xmin <= b.xmin && this.xmax >= b.xmax && this.ymin <= b.ymin && this.ymax >= b.ymax;
    }

    public boolean bounds(LatLon c) {
        return this.xmin <= c.lon() && this.xmax >= c.lon() && this.ymin <= c.lat() && this.ymax >= c.lat();
    }

    public boolean intersects(BBox b) {
        if (this.xmin > b.xmax) {
            return false;
        }
        if (this.xmax < b.xmin) {
            return false;
        }
        if (this.ymin > b.ymax) {
            return false;
        }
        return !(this.ymax < b.ymin);
    }

    public LatLon getTopLeft() {
        return new LatLon(this.ymax, this.xmin);
    }

    public double getTopLeftLat() {
        return this.ymax;
    }

    public double getTopLeftLon() {
        return this.xmin;
    }

    public LatLon getBottomRight() {
        return new LatLon(this.ymin, this.xmax);
    }

    public double getBottomRightLat() {
        return this.ymin;
    }

    public double getBottomRightLon() {
        return this.xmax;
    }

    public LatLon getCenter() {
        return new LatLon(this.ymin + (this.ymax - this.ymin) / 2.0, this.xmin + (this.xmax - this.xmin) / 2.0);
    }

    int getIndex(int level) {
        int idx1 = QuadTiling.index(this.ymin, this.xmin, level);
        int idx2 = QuadTiling.index(this.ymin, this.xmax, level);
        if (idx1 == -1) {
            idx1 = idx2;
        } else if (idx1 != idx2) {
            return -1;
        }
        int idx3 = QuadTiling.index(this.ymax, this.xmin, level);
        if (idx1 == -1) {
            idx1 = idx3;
        } else if (idx1 != idx3) {
            return -1;
        }
        int idx4 = QuadTiling.index(this.ymax, this.xmax, level);
        if (idx1 == -1) {
            idx1 = idx4;
        } else if (idx1 != idx4) {
            return -1;
        }
        return idx1;
    }

    public Rectangle2D toRectangle() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public int hashCode() {
        return (int)(this.ymin * this.xmin);
    }

    public boolean equals(Object o) {
        if (o instanceof BBox) {
            BBox b = (BBox)o;
            return b.xmax == this.xmax && b.ymax == this.ymax && b.xmin == this.xmin && b.ymin == this.ymin;
        }
        return false;
    }

    public String toString() {
        return "[ x: " + this.xmin + " -> " + this.xmax + ", y: " + this.ymin + " -> " + this.ymax + " ]";
    }

    public String toStringCSV(String separator) {
        return Utils.join(separator, Arrays.asList(LatLon.cDdFormatter.format(this.xmin), LatLon.cDdFormatter.format(this.ymin), LatLon.cDdFormatter.format(this.xmax), LatLon.cDdFormatter.format(this.ymax)));
    }
}

