/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractPrimitive
implements IPrimitive {
    private static final AtomicLong idCounter = new AtomicLong(0L);
    protected static final int FLAG_MODIFIED = 1;
    protected static final int FLAG_VISIBLE = 2;
    protected static final int FLAG_DELETED = 4;
    protected static final int FLAG_INCOMPLETE = 8;
    protected volatile short flags = (short)2;
    protected long id = 0L;
    protected User user = null;
    protected int version = 0;
    protected int changesetId;
    protected int timestamp;
    protected String[] keys;

    static long generateUniqueId() {
        return idCounter.decrementAndGet();
    }

    public void cloneFrom(AbstractPrimitive other) {
        this.setKeys(other.getKeys());
        this.id = other.id;
        if (this.id <= 0L) {
            this.version = 0;
            this.changesetId = 0;
        }
        this.timestamp = other.timestamp;
        if (this.id > 0L) {
            this.version = other.version;
        }
        this.flags = other.flags;
        this.user = other.user;
        if (this.id > 0L && other.changesetId > 0) {
            this.setChangesetId(other.changesetId);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getId() {
        long id = this.id;
        return id >= 0L ? id : 0L;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    @Override
    public boolean isNewOrUndeleted() {
        return this.id <= 0L || (this.flags & 6) == 0;
    }

    @Override
    public void setOsmId(long id, int version) {
        if (id <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", id));
        }
        if (version <= 0) {
            throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", version));
        }
        this.id = id;
        this.version = version;
        this.setIncomplete(false);
    }

    public void clearOsmMetadata() {
        this.id = AbstractPrimitive.generateUniqueId();
        this.version = 0;
        this.user = null;
        this.changesetId = 0;
        this.timestamp = 0;
        this.setIncomplete(false);
        this.setDeleted(false);
        this.setVisible(true);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public int getChangesetId() {
        return this.changesetId;
    }

    @Override
    public void setChangesetId(int changesetId) throws IllegalStateException, IllegalArgumentException {
        if (this.changesetId == changesetId) {
            return;
        }
        if (changesetId < 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected, got {1}", "changesetId", changesetId));
        }
        if (this.isNew() && changesetId > 0) {
            throw new IllegalStateException(I18n.tr("Cannot assign a changesetId > 0 to a new primitive. Value of changesetId is {0}", changesetId));
        }
        this.changesetId = changesetId;
    }

    @Override
    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    public OsmPrimitiveType getDisplayType() {
        return this.getType();
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.timestamp = (int)(timestamp.getTime() / 1000L);
    }

    @Override
    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    @Override
    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    protected void updateFlags(int flag, boolean value) {
        this.flags = value ? (short)(this.flags | flag) : (short)(this.flags & ~flag);
    }

    @Override
    public void setModified(boolean modified) {
        this.updateFlags(1, modified);
    }

    @Override
    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isDeleted() {
        return (this.flags & 4) != 0;
    }

    public boolean isUndeleted() {
        return (this.flags & 6) == 0;
    }

    public boolean isUsable() {
        return (this.flags & 0xC) == 0;
    }

    @Override
    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setVisible(boolean visible) throws IllegalStateException {
        if (this.isNew() && !visible) {
            throw new IllegalStateException(I18n.tr("A primitive with ID = 0 cannot be invisible.", new Object[0]));
        }
        this.updateFlags(2, visible);
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.updateFlags(4, deleted);
        this.setModified(deleted ^ !this.isVisible());
    }

    protected void setIncomplete(boolean incomplete) {
        this.updateFlags(8, incomplete);
    }

    @Override
    public boolean isIncomplete() {
        return (this.flags & 8) != 0;
    }

    protected String getFlagsAsString() {
        StringBuilder builder = new StringBuilder();
        if (this.isIncomplete()) {
            builder.append("I");
        }
        if (this.isModified()) {
            builder.append("M");
        }
        if (this.isVisible()) {
            builder.append("V");
        }
        if (this.isDeleted()) {
            builder.append("D");
        }
        return builder.toString();
    }

    @Override
    public Map<String, String> getKeys() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] keys = this.keys;
        if (keys != null) {
            for (int i = 0; i < keys.length; i += 2) {
                result.put(keys[i], keys[i + 1]);
            }
        }
        return result;
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        Map<String, String> originalKeys = this.getKeys();
        if (keys == null || keys.isEmpty()) {
            this.keys = null;
            this.keysChangedImpl(originalKeys);
            return;
        }
        String[] newKeys = new String[keys.size() * 2];
        int index = 0;
        for (Map.Entry<String, String> entry : keys.entrySet()) {
            newKeys[index++] = entry.getKey();
            newKeys[index++] = entry.getValue();
        }
        this.keys = newKeys;
        this.keysChangedImpl(originalKeys);
    }

    @Override
    public void put(String key, String value) {
        Map<String, String> originalKeys = this.getKeys();
        if (key == null || Utils.strip(key).isEmpty()) {
            return;
        }
        if (value == null) {
            this.remove(key);
        } else if (this.keys == null) {
            this.keys = new String[]{key, value};
            this.keysChangedImpl(originalKeys);
        } else {
            for (int i = 0; i < this.keys.length; i += 2) {
                if (!this.keys[i].equals(key)) continue;
                this.keys[i + 1] = value;
                this.keysChangedImpl(originalKeys);
                return;
            }
            String[] newKeys = new String[this.keys.length + 2];
            for (int i = 0; i < this.keys.length; i += 2) {
                newKeys[i] = this.keys[i];
                newKeys[i + 1] = this.keys[i + 1];
            }
            newKeys[this.keys.length] = key;
            newKeys[this.keys.length + 1] = value;
            this.keys = newKeys;
            this.keysChangedImpl(originalKeys);
        }
    }

    @Override
    public void remove(String key) {
        if (key == null || this.keys == null) {
            return;
        }
        if (!this.hasKey(key)) {
            return;
        }
        Map<String, String> originalKeys = this.getKeys();
        if (this.keys.length == 2) {
            this.keys = null;
            this.keysChangedImpl(originalKeys);
            return;
        }
        String[] newKeys = new String[this.keys.length - 2];
        int j = 0;
        for (int i = 0; i < this.keys.length; i += 2) {
            if (this.keys[i].equals(key)) continue;
            newKeys[j++] = this.keys[i];
            newKeys[j++] = this.keys[i + 1];
        }
        this.keys = newKeys;
        this.keysChangedImpl(originalKeys);
    }

    @Override
    public void removeAll() {
        if (this.keys != null) {
            Map<String, String> originalKeys = this.getKeys();
            this.keys = null;
            this.keysChangedImpl(originalKeys);
        }
    }

    @Override
    public final String get(String key) {
        String[] keys = this.keys;
        if (key == null) {
            return null;
        }
        if (keys == null) {
            return null;
        }
        for (int i = 0; i < keys.length; i += 2) {
            if (!keys[i].equals(key)) continue;
            return keys[i + 1];
        }
        return null;
    }

    public final boolean isKeyTrue(String key) {
        return OsmUtils.isTrue(this.get(key));
    }

    public final boolean isKeyFalse(String key) {
        return OsmUtils.isFalse(this.get(key));
    }

    public final String getIgnoreCase(String key) {
        String[] keys = this.keys;
        if (key == null) {
            return null;
        }
        if (keys == null) {
            return null;
        }
        for (int i = 0; i < keys.length; i += 2) {
            if (!keys[i].equalsIgnoreCase(key)) continue;
            return keys[i + 1];
        }
        return null;
    }

    public final int getNumKeys() {
        return this.keys == null ? 0 : this.keys.length / 2;
    }

    @Override
    public final Collection<String> keySet() {
        String[] keys = this.keys;
        if (keys == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(keys.length / 2);
        for (int i = 0; i < keys.length; i += 2) {
            result.add(keys[i]);
        }
        return result;
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null;
    }

    public boolean hasKey(String key) {
        String[] keys = this.keys;
        if (key == null) {
            return false;
        }
        if (keys == null) {
            return false;
        }
        for (int i = 0; i < keys.length; i += 2) {
            if (!keys[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    protected abstract void keysChangedImpl(Map<String, String> var1);

    @Override
    public String getName() {
        return this.get("name");
    }

    @Override
    public String getLocalName() {
        Locale locale = Locale.getDefault();
        String key = "name:" + locale.toString();
        String val = this.get(key);
        if (val != null) {
            return val;
        }
        String language = locale.getLanguage();
        key = "name:" + language + "_" + locale.getCountry();
        val = this.get(key);
        if (val != null) {
            return val;
        }
        key = "name:" + language;
        val = this.get(key);
        if (val != null) {
            return val;
        }
        return this.getName();
    }

    public boolean hasTag(String key, String value) {
        return Objects.equals(value, this.get(key));
    }

    public boolean hasTag(String key, String ... values) {
        return this.hasTag(key, Arrays.asList(values));
    }

    public boolean hasTag(String key, Collection<String> values) {
        return values.contains(this.get(key));
    }
}

