/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.net.MalformedURLException;
import java.net.URL;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthParameters {
    public static final String DEFAULT_JOSM_CONSUMER_KEY = "F7zPYlVCqE2BUH9Hr4SsWZSOnrKjpug1EgqkbsSb";
    public static final String DEFAULT_JOSM_CONSUMER_SECRET = "rIkjpPcBNkMQxrqzcOvOC4RRuYupYr7k8mfP13H5";
    public static final String DEFAULT_REQUEST_TOKEN_URL = Main.getOSMWebsite() + "/oauth/request_token";
    public static final String DEFAULT_ACCESS_TOKEN_URL = Main.getOSMWebsite() + "/oauth/access_token";
    public static final String DEFAULT_AUTHORISE_URL = Main.getOSMWebsite() + "/oauth/authorize";
    private String consumerKey;
    private String consumerSecret;
    private String requestTokenUrl;
    private String accessTokenUrl;
    private String authoriseUrl;

    public static OAuthParameters createDefault() {
        return OAuthParameters.createDefault(null);
    }

    public static OAuthParameters createDefault(String apiUrl) {
        OAuthParameters parameters = new OAuthParameters();
        parameters.setConsumerKey(DEFAULT_JOSM_CONSUMER_KEY);
        parameters.setConsumerSecret(DEFAULT_JOSM_CONSUMER_SECRET);
        parameters.setRequestTokenUrl(DEFAULT_REQUEST_TOKEN_URL);
        parameters.setAccessTokenUrl(DEFAULT_ACCESS_TOKEN_URL);
        parameters.setAuthoriseUrl(DEFAULT_AUTHORISE_URL);
        if (!"https://api.openstreetmap.org/api".equals(apiUrl)) {
            try {
                String host = new URL(apiUrl).getHost();
                if (host.endsWith("dev.openstreetmap.org")) {
                    parameters.setRequestTokenUrl(DEFAULT_REQUEST_TOKEN_URL.replace("www.openstreetmap.org", host));
                    parameters.setAccessTokenUrl(DEFAULT_ACCESS_TOKEN_URL.replace("www.openstreetmap.org", host));
                    parameters.setAuthoriseUrl(DEFAULT_AUTHORISE_URL.replace("www.openstreetmap.org", host));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return parameters;
    }

    public static OAuthParameters createFromPreferences(Preferences pref2) {
        OAuthParameters parameters = OAuthParameters.createDefault(pref2.get("osm-server.url"));
        parameters.setConsumerKey(pref2.get("oauth.settings.consumer-key", parameters.getConsumerKey()));
        parameters.setConsumerSecret(pref2.get("oauth.settings.consumer-secret", parameters.getConsumerSecret()));
        parameters.setRequestTokenUrl(pref2.get("oauth.settings.request-token-url", parameters.getRequestTokenUrl()));
        parameters.setAccessTokenUrl(pref2.get("oauth.settings.access-token-url", parameters.getAccessTokenUrl()));
        parameters.setAuthoriseUrl(pref2.get("oauth.settings.authorise-url", parameters.getAuthoriseUrl()));
        return parameters;
    }

    public OAuthParameters() {
    }

    public OAuthParameters(OAuthParameters other) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.consumerKey = other.consumerKey;
        this.consumerSecret = other.consumerSecret;
        this.accessTokenUrl = other.accessTokenUrl;
        this.requestTokenUrl = other.requestTokenUrl;
        this.authoriseUrl = other.authoriseUrl;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public void setRequestTokenUrl(String requestTokenUrl) {
        this.requestTokenUrl = requestTokenUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getAuthoriseUrl() {
        return this.authoriseUrl;
    }

    public void setAuthoriseUrl(String authoriseUrl) {
        this.authoriseUrl = authoriseUrl;
    }

    public OAuthConsumer buildConsumer() {
        return new DefaultOAuthConsumer(this.consumerKey, this.consumerSecret);
    }

    public OAuthProvider buildProvider(OAuthConsumer consumer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(consumer, "consumer");
        return new DefaultOAuthProvider(this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessTokenUrl == null ? 0 : this.accessTokenUrl.hashCode());
        result = 31 * result + (this.authoriseUrl == null ? 0 : this.authoriseUrl.hashCode());
        result = 31 * result + (this.consumerKey == null ? 0 : this.consumerKey.hashCode());
        result = 31 * result + (this.consumerSecret == null ? 0 : this.consumerSecret.hashCode());
        result = 31 * result + (this.requestTokenUrl == null ? 0 : this.requestTokenUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthParameters other = (OAuthParameters)obj;
        if (this.accessTokenUrl == null ? other.accessTokenUrl != null : !this.accessTokenUrl.equals(other.accessTokenUrl)) {
            return false;
        }
        if (this.authoriseUrl == null ? other.authoriseUrl != null : !this.authoriseUrl.equals(other.authoriseUrl)) {
            return false;
        }
        if (this.consumerKey == null ? other.consumerKey != null : !this.consumerKey.equals(other.consumerKey)) {
            return false;
        }
        if (this.consumerSecret == null ? other.consumerSecret != null : !this.consumerSecret.equals(other.consumerSecret)) {
            return false;
        }
        return !(this.requestTokenUrl == null ? other.requestTokenUrl != null : !this.requestTokenUrl.equals(other.requestTokenUrl));
    }
}

