/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.notes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.NoteComment;

public class Note {
    private long id;
    private LatLon latLon;
    private Date createdAt;
    private Date closedAt;
    private State state;
    private List<NoteComment> comments = new ArrayList<NoteComment>();

    public Note(LatLon latLon) {
        this.latLon = latLon;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public List<NoteComment> getComments() {
        return this.comments;
    }

    public void addComment(NoteComment comment) {
        this.comments.add(comment);
    }

    public NoteComment getFirstComment() {
        return this.comments.get(0);
    }

    public void updateWith(Note note) {
        this.comments = note.comments;
        this.createdAt = note.createdAt;
        this.id = note.id;
        this.state = note.state;
        this.latLon = note.latLon;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Note other = (Note)obj;
        return this.id == other.id;
    }

    public static enum State {
        open,
        closed;

    }
}

