/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public class TMSCachedTileLoaderJob
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry>
implements TileJob,
ICachedLoaderListener {
    private static final Logger log = FeatureAdapter.getLogger(TMSCachedTileLoaderJob.class.getCanonicalName());
    private Tile tile;
    private TileLoaderListener listener;
    private volatile URL url;
    public static IntegerProperty THREAD_LIMIT = new IntegerProperty("imagery.tms.tmsloader.maxjobs", 25);
    private static ThreadPoolExecutor DOWNLOAD_JOB_DISPATCHER = new ThreadPoolExecutor(THREAD_LIMIT.get(), THREAD_LIMIT.get(), 30L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingDeque<Runnable>(5){

        @Override
        public boolean offer(Runnable t) {
            return super.offerFirst(t);
        }

        @Override
        public Runnable remove() {
            return (Runnable)super.removeFirst();
        }
    });

    public TMSCachedTileLoaderJob(TileLoaderListener listener, Tile tile, ICacheAccess<String, BufferedImageCacheEntry> cache, int connectTimeout, int readTimeout, Map<String, String> headers) {
        super(cache, connectTimeout, readTimeout, headers);
        this.tile = tile;
        this.listener = listener;
    }

    @Override
    public Tile getTile() {
        return this.getCachedTile();
    }

    @Override
    public String getCacheKey() {
        if (this.tile != null) {
            return this.tile.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getUrl() {
        if (this.url == null) {
            try {
                TMSCachedTileLoaderJob tMSCachedTileLoaderJob = this;
                synchronized (tMSCachedTileLoaderJob) {
                    if (this.url == null) {
                        this.url = new URL(this.tile.getUrl());
                    }
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "JCS TMS Cache - error creating URL for tile {0}: {1}", new Object[]{this.tile.getKey(), e.getMessage()});
                log.log(Level.INFO, "Exception: ", e);
            }
        }
        return this.url;
    }

    @Override
    public boolean isObjectLoadable() {
        if (this.cacheData != null) {
            byte[] content = ((BufferedImageCacheEntry)this.cacheData).getContent();
            try {
                return content != null || ((BufferedImageCacheEntry)this.cacheData).getImage() != null || this.cacheAsEmpty();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "JCS TMS - error loading from cache for tile {0}: {1}", new Object[]{this.tile.getKey(), e.getMessage()});
            }
        }
        return false;
    }

    @Override
    protected boolean cacheAsEmpty() {
        if (this.attributes != null && this.attributes.isNoTileAtZoom()) {
            log.log(Level.FINE, "JCS TMS - Tile valid, but no file, as no tiles at this level {0}", this.tile);
            this.tile.setError("No tile at this zoom level");
            this.tile.putValue("tile-info", "no-tile");
            return true;
        }
        return false;
    }

    @Override
    protected Executor getDownloadExecutor() {
        return DOWNLOAD_JOB_DISPATCHER;
    }

    @Override
    public void submit() {
        this.tile.initLoading();
        super.submit(this);
    }

    @Override
    public void loadingFinished(CacheEntry object, boolean success) {
        block3: {
            try {
                this.loadTile(object, success);
                if (this.listener != null) {
                    this.listener.tileLoadingFinished(this.tile, success);
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "JCS TMS - error loading object for tile {0}: {1}", new Object[]{this.tile.getKey(), e.getMessage()});
                this.tile.setError(e.getMessage());
                this.tile.setLoaded(false);
                if (this.listener == null) break block3;
                this.listener.tileLoadingFinished(this.tile, false);
            }
        }
    }

    public Tile getCachedTile() {
        BufferedImageCacheEntry data = (BufferedImageCacheEntry)this.get();
        if (this.isObjectLoadable()) {
            try {
                this.loadTile(data);
                return this.tile;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "JCS TMS - error loading object for tile {0}: {1}", new Object[]{this.tile.getKey(), e.getMessage()});
                return null;
            }
        }
        return null;
    }

    private void loadTile(CacheEntry object, boolean success) throws IOException {
        byte[] content;
        this.tile.finishLoading();
        if (object != null && (content = object.getContent()) != null && content.length > 0) {
            this.tile.loadImage(new ByteArrayInputStream(content));
        }
        if (!success) {
            this.tile.setError("Problem loading tile");
        }
    }

    private void loadTile(BufferedImageCacheEntry object) throws IOException {
        this.tile.finishLoading();
        if ((this.cacheAsEmpty() || object != null) && object.getImage() != null) {
            this.tile.setImage(object.getImage());
        }
    }

    @Override
    protected boolean handleNotFound() {
        this.tile.setError("No tile at this zoom level");
        this.tile.putValue("tile-info", "no-tile");
        return true;
    }

    @Override
    protected String getServerKey() {
        TileSource ts = this.tile.getSource();
        if (ts instanceof AbstractTMSTileSource) {
            return ((AbstractTMSTileSource)ts).getBaseUrl();
        }
        return super.getServerKey();
    }

    @Override
    protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
        return new BufferedImageCacheEntry(content);
    }
}

