/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoaderJob;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public class TMSCachedTileLoader
implements CachedTileLoader,
TileCache,
TileLoader {
    private ICacheAccess<String, BufferedImageCacheEntry> cache;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> headers;
    private TileLoaderListener listener;
    public static final String PREFERENCE_PREFIX = "imagery.tms.cache.";
    public static IntegerProperty MAX_OBJECTS_ON_DISK = new IntegerProperty("imagery.tms.cache.max_objects_disk", 25000);

    public TMSCachedTileLoader(TileLoaderListener listener, String name, int connectTimeout, int readTimeout, Map<String, String> headers, String cacheDir) throws IOException {
        this.cache = JCSCacheManager.getCache(name, 1000, MAX_OBJECTS_ON_DISK.get(), cacheDir);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.headers = headers;
        this.listener = listener;
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new TMSCachedTileLoaderJob(this.listener, tile, this.cache, this.connectTimeout, this.readTimeout, this.headers);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Tile getTile(TileSource source, int x, int y, int z) {
        return this.createTileLoaderJob(new Tile(source, x, y, z)).getTile();
    }

    @Override
    public void addTile(Tile tile) {
        this.createTileLoaderJob(tile).getTile();
    }

    @Override
    public int getTileCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public String getStats() {
        return this.cache.getStats();
    }
}

