/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

public class OffsetBookmark {
    public static final List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    public String projectionCode;
    public String layerName;
    public String name;
    public double dx;
    public double dy;
    public double centerX;
    public double centerY;

    public boolean isUsable(ImageryLayer layer) {
        if (this.projectionCode == null) {
            return false;
        }
        if (!Main.getProjection().toCode().equals(this.projectionCode)) {
            return false;
        }
        return layer.getInfo().getName().equals(this.layerName);
    }

    public OffsetBookmark(String projectionCode, String layerName, String name, double dx, double dy) {
        this(projectionCode, layerName, name, dx, dy, 0.0, 0.0);
    }

    public OffsetBookmark(String projectionCode, String layerName, String name, double dx, double dy, double centerX, double centerY) {
        this.projectionCode = projectionCode;
        this.layerName = layerName;
        this.name = name;
        this.dx = dx;
        this.dy = dy;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public OffsetBookmark(Collection<String> list) {
        ArrayList<String> array = new ArrayList<String>(list);
        this.projectionCode = (String)array.get(0);
        this.layerName = (String)array.get(1);
        this.name = (String)array.get(2);
        this.dx = Double.valueOf((String)array.get(3));
        this.dy = Double.valueOf((String)array.get(4));
        if (array.size() >= 7) {
            this.centerX = Double.valueOf((String)array.get(5));
            this.centerY = Double.valueOf((String)array.get(6));
        }
        if (this.projectionCode == null) {
            Main.error(I18n.tr("Projection ''{0}'' is not found, bookmark ''{1}'' is not usable", this.projectionCode, this.name));
        }
    }

    public List<String> getInfoArray() {
        ArrayList<String> res = new ArrayList<String>(7);
        if (this.projectionCode != null) {
            res.add(this.projectionCode);
        } else {
            res.add("");
        }
        res.add(this.layerName);
        res.add(this.name);
        res.add(String.valueOf(this.dx));
        res.add(String.valueOf(this.dy));
        if (this.centerX != 0.0 || this.centerY != 0.0) {
            res.add(String.valueOf(this.centerX));
            res.add(String.valueOf(this.centerY));
        }
        return res;
    }

    public static void loadBookmarks() {
        for (Collection<String> c : Main.pref.getArray("imagery.offsets", Collections.emptySet())) {
            allBookmarks.add(new OffsetBookmark(c));
        }
    }

    public static void saveBookmarks() {
        LinkedList<Collection<String>> coll = new LinkedList<Collection<String>>();
        for (OffsetBookmark b : allBookmarks) {
            coll.add(b.getInfoArray());
        }
        Main.pref.putArray("imagery.offsets", coll);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer layer, String name) {
        for (OffsetBookmark b : allBookmarks) {
            if (!b.isUsable(layer) || !name.equals(b.name)) continue;
            return b;
        }
        return null;
    }

    public static void bookmarkOffset(String name, ImageryLayer layer) {
        LatLon center = Main.isDisplayingMapView() ? Main.getProjection().eastNorth2latlon(Main.map.mapView.getCenter()) : new LatLon(0.0, 0.0);
        OffsetBookmark nb = new OffsetBookmark(Main.getProjection().toCode(), layer.getInfo().getName(), name, layer.getDx(), layer.getDy(), center.lon(), center.lat());
        ListIterator<OffsetBookmark> it = allBookmarks.listIterator();
        while (it.hasNext()) {
            OffsetBookmark b = it.next();
            if (!b.isUsable(layer) || !name.equals(b.name)) continue;
            it.set(nb);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(nb);
        OffsetBookmark.saveBookmarks();
    }
}

